/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.Translation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.akvo.flow.xml.XmlAltText;
import org.akvo.flow.xml.XmlQuestionGroup;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.gwt.client.survey.TranslationDto;

@JacksonXmlRootElement(localName="survey")
public final class XmlForm {
    @JacksonXmlElementWrapper(localName="altText", useWrapping=false)
    private List<XmlAltText> altText;
    @JacksonXmlElementWrapper(localName="questionGroup", useWrapping=false)
    private List<XmlQuestionGroup> questionGroup;
    @JacksonXmlProperty(localName="name", isAttribute=true)
    private String name;
    @JacksonXmlProperty(localName="defaultLanguageCode", isAttribute=true)
    private String defaultLanguageCode;
    @JacksonXmlProperty(localName="version", isAttribute=true)
    private String version;
    @JacksonXmlProperty(localName="app", isAttribute=true)
    private String app;
    @JacksonXmlProperty(localName="surveyGroupId", isAttribute=true)
    private Long surveyGroupId;
    @JacksonXmlProperty(localName="surveyGroupName", isAttribute=true)
    private String surveyGroupName;
    @JacksonXmlProperty(localName="surveyId", isAttribute=true)
    private long surveyId;

    public XmlForm() {
    }

    public XmlForm(Survey form, SurveyGroup survey, String appStr) {
        this.surveyId = form.getKey().getId();
        this.surveyGroupId = form.getSurveyGroupId();
        this.surveyGroupName = survey.getCode();
        this.defaultLanguageCode = form.getDefaultLanguageCode();
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = "en";
        }
        this.name = form.getCode();
        if (this.name == null) {
            this.name = form.getName();
        }
        this.version = form.getVersion().toString();
        this.app = appStr;
        this.altText = new ArrayList<XmlAltText>();
        if (form.getTranslationMap() != null && !form.getTranslationMap().isEmpty()) {
            for (Translation t : form.getTranslationMap().values()) {
                this.altText.add(new XmlAltText(t));
            }
        }
        this.questionGroup = new ArrayList<XmlQuestionGroup>();
        if (form.getQuestionGroupMap() != null) {
            for (QuestionGroup g : form.getQuestionGroupMap().values()) {
                this.questionGroup.add(new XmlQuestionGroup(g));
            }
        }
    }

    public SurveyDto toDto() {
        SurveyDto dto = new SurveyDto();
        dto.setKeyId(this.surveyId);
        dto.setName(this.name);
        dto.setCode(this.name);
        dto.setVersion(this.version);
        if (this.altText != null) {
            HashMap<String, TranslationDto> qMap = new HashMap<String, TranslationDto>();
            for (XmlAltText alt : this.altText) {
                qMap.put(alt.getLanguage(), alt.toDto());
            }
            dto.setTranslationMap(qMap);
        }
        if (this.questionGroup != null) {
            ArrayList<QuestionGroupDto> gList = new ArrayList<QuestionGroupDto>();
            int i = 1;
            for (XmlQuestionGroup g : this.questionGroup) {
                g.setOrder(i++);
                gList.add(g.toDto());
            }
            dto.setQuestionGroupList(gList);
        }
        return dto;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<XmlQuestionGroup> getQuestionGroup() {
        return this.questionGroup;
    }

    public void setQuestionGroup(List<XmlQuestionGroup> qgl) {
        this.questionGroup = qgl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public void setDefaultLanguageCode(String defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public Long getSurveyGroupId() {
        return this.surveyGroupId;
    }

    public void setSurveyGroupId(Long surveyGroupId) {
        this.surveyGroupId = surveyGroupId;
    }

    public String getSurveyGroupName() {
        return this.surveyGroupName;
    }

    public void setSurveyGroupName(String surveyGroupName) {
        this.surveyGroupName = surveyGroupName;
    }

    public long getSurveyId() {
        return this.surveyId;
    }

    public void setSurveyId(String surveyId) {
        this.surveyId = Long.parseLong(surveyId);
    }

    public List<XmlAltText> getAltText() {
        return this.altText;
    }

    public void setAltText(List<XmlAltText> altText) {
        this.altText = altText;
    }

    public String toString() {
        return "Form{questionGroups=" + this.questionGroup.toString() + '}';
    }
}

