/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.serialization.response;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.logging.Logger;
import org.akvo.flow.util.FlowJsonObjectReader;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.waterforpeople.mapping.domain.response.value.Media;

public class MediaResponse {
    private static final Logger log = Logger.getLogger(MediaResponse.class.getName());
    private static FlowJsonObjectReader jsonObjectReader = new FlowJsonObjectReader();
    private static FlowJsonObjectWriter jsonObjectWriter = new FlowJsonObjectWriter();
    private static FlowJsonObjectWriter jsonObjectWriterNoNulls = new FlowJsonObjectWriter().withExcludeNullValues();
    public static final int VERSION_STRING = 0;
    public static final int VERSION_GEOTAGGING = 1;

    public static String format(String value, int version) {
        int savedVersion;
        Media media;
        try {
            media = jsonObjectReader.readObject(value, new TypeReference<Media>(){});
            savedVersion = 1;
        }
        catch (IOException e) {
            media = new Media();
            media.setFilename(value);
            savedVersion = 0;
        }
        if (version == savedVersion) {
            return value;
        }
        if (version == 1) {
            try {
                return jsonObjectWriter.writeAsString(media);
            }
            catch (IOException e) {
                log.warning(e.getMessage());
                return "";
            }
        }
        return media.getFilename();
    }

    public static String formatWithGeotag(Media media) {
        try {
            return jsonObjectWriter.writeAsString(media);
        }
        catch (IOException e) {
            log.warning(e.getMessage());
            return "";
        }
    }

    public static String formatWithoutGeotag(Media media) {
        media.setLocation(null);
        try {
            return jsonObjectWriterNoNulls.writeAsString(media);
        }
        catch (IOException e) {
            log.warning(e.getMessage());
            return "";
        }
    }

    public static Media parse(String value) {
        try {
            return jsonObjectReader.readObject(value, new TypeReference<Media>(){});
        }
        catch (IOException iOException) {
            Media media = new Media();
            media.setFilename(value);
            return media;
        }
    }
}

