/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.gallatinsystems.common.util.MD5Util;
import com.gallatinsystems.survey.domain.SurveyGroup;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.akvo.flow.util.FlowJsonObjectReader;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.waterforpeople.mapping.app.gwt.client.devicefiles.DeviceFilesDto;
import org.waterforpeople.mapping.app.gwt.client.survey.OptionContainerDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDependencyDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.TranslationDto;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.app.web.dto.InstanceDataDto;
import org.waterforpeople.mapping.dataexport.service.NameValuePair;

public class BulkDataServiceClient {
    private static final Logger log = Logger.getLogger(BulkDataServiceClient.class);
    private static final String DATA_SERVLET_PATH = "/databackout";
    public static final String RESPONSE_KEY = "dtoList";
    private static final String SURVEY_SERVLET_PATH = "/surveyrestapi";
    private static final String INSTANCE_DATA_SERVLET_PATH = "/instancedata";
    private static final String DEVICE_FILES_SERVLET_PATH = "/devicefilesrestapi?action=";

    public static Map<Long, Map<Long, String>> fetchQuestionResponses(String instanceId, String serverBase, String apiKey) throws Exception {
        String instanceValues = BulkDataServiceClient.fetchDataFromServer(serverBase + DATA_SERVLET_PATH, "?action=listInstanceResponse&surveyInstanceId=" + instanceId, true, apiKey);
        return BulkDataServiceClient.parseSurveyInstanceResponse(instanceValues);
    }

    public static Map<String, String> fetchInstanceIds(String surveyId, String serverBase, String apiKey, boolean lastCollection, String from, String to, String limit) throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        String instanceString = BulkDataServiceClient.fetchDataFromServer(serverBase + DATA_SERVLET_PATH, "?action=listInstance&surveyId=" + surveyId + "&" + "includeDate" + "=true&" + "lastCollection" + "=" + lastCollection + "&" + "fromDate" + "=" + from + "&" + "toDate" + "=" + to + "&" + "limit" + "=" + limit, true, apiKey);
        if (instanceString != null && instanceString.trim().length() != 0) {
            StringTokenizer strTok = new StringTokenizer(instanceString, ",");
            while (strTok.hasMoreTokens()) {
                String instanceId = strTok.nextToken();
                String dateString = "";
                if (instanceId.contains("|")) {
                    dateString = instanceId.substring(instanceId.indexOf("|") + 1);
                    instanceId = instanceId.substring(0, instanceId.indexOf("|"));
                }
                values.put(instanceId, dateString.replaceAll("\n", " ").trim());
            }
        }
        return values;
    }

    public static Long fetchInstanceCount(String formId, String serverBase, String apiKey, String from, String to) throws Exception {
        String instanceString = BulkDataServiceClient.fetchDataFromServer(serverBase + DATA_SERVLET_PATH, "?action=countInstance&surveyId=" + formId + "&" + "fromDate" + "=" + from + "&" + "toDate" + "=" + to, true, apiKey);
        Long count = null;
        if (instanceString != null) {
            try {
                count = Long.parseLong(instanceString.trim());
            }
            catch (Exception e) {
                log.error((Object)("Unparsable instance count " + e.getMessage()));
            }
        }
        return count;
    }

    public static void main(String[] args) {
        try {
            Map<String, String> results = BulkDataServiceClient.fetchInstanceIds(args[1], args[0], args[2], false, null, null, null);
            if (results != null) {
                log.info(results);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error: " + e.getMessage()), (Throwable)e);
        }
    }

    private static final Map<Long, Map<Long, String>> parseSurveyInstanceResponse(String responseData) {
        HashMap<Long, Map<Long, String>> result = new HashMap<Long, Map<Long, String>>();
        StringTokenizer lines = new StringTokenizer(responseData, "\n");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            String[] tokens = line.split(",", 3);
            Long questionId = Long.valueOf(tokens[0]);
            Long iteration = Long.valueOf(tokens[1]);
            byte[] decodedToken = Base64.getUrlDecoder().decode(tokens[2].getBytes(StandardCharsets.UTF_8));
            String value = new String(decodedToken, StandardCharsets.UTF_8).trim();
            Map iterationMap = (Map)result.get(questionId);
            if (iterationMap != null) {
                assert (iterationMap.get(iteration) == null);
                iterationMap.put(iteration, value);
                continue;
            }
            HashMap<Long, String> newIterationMap = new HashMap<Long, String>();
            newIterationMap.put(iteration, value);
            result.put(questionId, newIterationMap);
        }
        return result;
    }

    public static QuestionDto loadQuestionDetails(String serverBase, Long questionId, String apiKey) throws Exception {
        List<QuestionDto> dtoList = null;
        dtoList = BulkDataServiceClient.parseQuestions(BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, "?action=getQuestionDetails&questionID=" + questionId, true, apiKey));
        if (dtoList != null && dtoList.size() > 0) {
            return dtoList.get(0);
        }
        return null;
    }

    public static Object[] loadQuestions(String surveyId, String serverBase, String apiKey) throws Exception {
        Object[] results = new Object[2];
        HashMap<String, QuestionDto> questions = new HashMap<String, QuestionDto>();
        List<QuestionGroupDto> groups = BulkDataServiceClient.fetchQuestionGroups(serverBase, surveyId, apiKey);
        ArrayList<String> keyList = new ArrayList<String>();
        if (groups != null) {
            for (QuestionGroupDto group : groups) {
                List<QuestionDto> questionDtos = BulkDataServiceClient.fetchQuestions(serverBase, group.getKeyId(), apiKey);
                if (questionDtos == null) continue;
                for (QuestionDto question : questionDtos) {
                    keyList.add(question.getKeyId().toString());
                    questions.put(question.getKeyId().toString(), question);
                }
            }
        }
        results[0] = keyList;
        results[1] = questions;
        return results;
    }

    public static List<QuestionDto> fetchQuestions(String serverBase, Long groupId, String apiKey) throws Exception {
        return BulkDataServiceClient.parseQuestions(BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, "?action=listQuestions&questionGroupId=" + groupId, true, apiKey));
    }

    public static Map<Long, List<QuestionOptionDto>> fetchOptionNodes(String surveyId, String serverBase, String apiKey, List<Long> questionIds) throws Exception {
        HashMap<Long, List<QuestionOptionDto>> result = new HashMap<Long, List<QuestionOptionDto>>();
        for (Long questionId : questionIds) {
            List<QuestionOptionDto> questionOptions = BulkDataServiceClient.parseQuestionOptions(BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, "?action=listQuestionOptions&questionID=" + questionId, true, apiKey));
            result.put(questionId, questionOptions);
        }
        return result;
    }

    public static List<QuestionOptionDto> fetchSurveyQuestionOptions(String surveyId, String serverBase, String apiKey) throws Exception {
        return BulkDataServiceClient.parseQuestionOptions(BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, "?action=listSurveyQuestionOptions&surveyId=" + surveyId, true, apiKey));
    }

    public static SurveyInstanceDto findSurveyInstance(Long id, String serverBase, String apiKey) throws Exception {
        return BulkDataServiceClient.parseSurveyInstance(BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, "?action=getSurveyInstance&instanceId=" + id, true, apiKey));
    }

    public static InstanceDataDto fetchInstanceData(Long surveyInstanceId, String serverBase, String apiKey) throws Exception {
        String baseUrl = serverBase + INSTANCE_DATA_SERVLET_PATH;
        String urlQueryString = "?action=" + "getInstanceData" + "&" + "surveyInstanceId" + "=" + surveyInstanceId;
        String instanceDataResponse = BulkDataServiceClient.fetchDataFromServer(baseUrl, urlQueryString, true, apiKey);
        return BulkDataServiceClient.parseInstanceData(instanceDataResponse);
    }

    private static InstanceDataDto parseInstanceData(String instanceDataResponse) {
        FlowJsonObjectReader jsonReader = new FlowJsonObjectReader();
        TypeReference<InstanceDataDto> typeReference = new TypeReference<InstanceDataDto>(){};
        try {
            InstanceDataDto instanceData = jsonReader.readObject(instanceDataResponse, typeReference);
            return instanceData;
        }
        catch (IOException e) {
            log.error((Object)"Error while parsing: ", (Throwable)e);
            return new InstanceDataDto();
        }
    }

    public static List<QuestionGroupDto> fetchQuestionGroups(String serverBase, String surveyId, String apiKey) throws Exception {
        return BulkDataServiceClient.parseQuestionGroups(BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, "?action=listGroups&surveyId=" + surveyId, true, apiKey));
    }

    public static SurveyGroupDto fetchSurveyGroup(String surveyId, String serverBase, String apiKey) {
        SurveyGroupDto surveyGroupDto = null;
        try {
            String surveyGroupResponse = BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, "action=getSurveyGroup&surveyId=" + surveyId, true, apiKey);
            log.debug((Object)("response: " + surveyGroupResponse));
            FlowJsonObjectReader jsonDeserialiser = new FlowJsonObjectReader();
            TypeReference<SurveyGroupDto> listItemTypeReference = new TypeReference<SurveyGroupDto>(){};
            List<SurveyGroupDto> surveyGroupList = jsonDeserialiser.readDtoListObject(surveyGroupResponse, listItemTypeReference);
            if (surveyGroupList != null && !surveyGroupList.isEmpty()) {
                surveyGroupDto = surveyGroupList.get(0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return surveyGroupDto;
    }

    public static List<SurveyGroupDto> fetchSurveyGroups(String serverBase, String apiKey) throws Exception {
        ArrayList<SurveyGroupDto> result = new ArrayList<SurveyGroupDto>();
        String cursor = null;
        do {
            String qs = "?action=listSurveyGroups";
            if (cursor != null && !"".equals(cursor)) {
                qs = qs + "&cursor=" + cursor;
            }
            String resp = BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, qs, true, apiKey);
            try {
                JSONObject jsonResp = new JSONObject(resp);
                cursor = jsonResp.isNull("cursor") ? null : jsonResp.getString("cursor");
            }
            catch (JSONException e) {
                cursor = null;
            }
            result.addAll(BulkDataServiceClient.parseSurveyGroups(resp));
        } while (cursor != null);
        return result;
    }

    public static List<SurveyDto> fetchSurveys(Long surveyGroupId, String serverBase, String apiKey) throws Exception {
        return BulkDataServiceClient.parseSurveys(BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, "?action=listSurveys&surveyGroupId=" + surveyGroupId, true, apiKey));
    }

    public static List<SurveyDto> fetchSurvey(Long surveyId, String serverBase, String apiKey) throws Exception {
        return BulkDataServiceClient.parseSurveys(BulkDataServiceClient.fetchDataFromServer(serverBase + SURVEY_SERVLET_PATH, "?action=getSurvey&surveyId=" + surveyId, true, apiKey));
    }

    private static SurveyInstanceDto parseSurveyInstance(String response) throws Exception {
        JSONObject json;
        JSONArray arr;
        SurveyInstanceDto dto = null;
        if (response != null && (arr = BulkDataServiceClient.getJsonArray(response)) != null && arr.length() > 0 && (json = arr.getJSONObject(0)) != null) {
            dto = new SurveyInstanceDto();
            if (json.has("keyId")) {
                dto.setKeyId(json.getLong("keyId"));
            }
            if (json.has("surveyId")) {
                dto.setSurveyId(json.getLong("surveyId"));
            }
            if (json.has("userID") && !json.isNull("userID")) {
                dto.setUserID(json.getLong("userID"));
            }
            if (json.has("surveyalTime") && !json.isNull("surveyalTime")) {
                dto.setSurveyalTime(json.getLong("surveyalTime"));
            }
            if (json.has("submitterName")) {
                dto.setSubmitterName(json.getString("submitterName"));
            }
            if (json.has("approvedFlag")) {
                dto.setApprovedFlag(json.getString("approvedFlag"));
            }
            if (json.has("deviceIdentifier")) {
                dto.setDeviceIdentifier(json.getString("deviceIdentifier"));
            }
            if (json.has("surveyedLocaleId") && !json.isNull("surveyedLocaleId")) {
                dto.setSurveyedLocaleId(json.getLong("surveyedLocaleId"));
            }
            if (json.has("surveyedLocaleDisplayName") && !json.isNull("surveyedLocaleDisplayName")) {
                dto.setSurveyedLocaleDisplayName(json.getString("surveyedLocaleDisplayName"));
            }
            if (json.has("surveyedLocaleIdentifier") && !json.isNull("surveyedLocaleIdentifier")) {
                dto.setSurveyedLocaleIdentifier(json.getString("surveyedLocaleIdentifier"));
            }
            if (json.has("collectionDate")) {
                dto.setCollectionDate(new Date(json.getLong("collectionDate")));
            }
            if (!json.has("formVersion")) {
                dto.setFormVersion(json.getDouble("formVersion"));
            }
        }
        return dto;
    }

    private static List<QuestionGroupDto> parseQuestionGroups(String response) throws Exception {
        ArrayList<QuestionGroupDto> dtoList = new ArrayList<QuestionGroupDto>();
        JSONArray arr = BulkDataServiceClient.getJsonArray(response);
        if (arr != null) {
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject json = arr.getJSONObject(i);
                if (json == null) continue;
                QuestionGroupDto dto = new QuestionGroupDto();
                try {
                    if (!json.isNull("code")) {
                        dto.setCode(json.getString("code"));
                    }
                    if (!json.isNull("keyId")) {
                        dto.setKeyId(json.getLong("keyId"));
                    }
                    if (!json.isNull("displayName")) {
                        dto.setName(json.getString("displayName"));
                    }
                    if (!json.isNull("order")) {
                        dto.setOrder(json.getInt("order"));
                    }
                    if (!json.isNull("path")) {
                        dto.setPath(json.getString("path"));
                    }
                    if (!json.isNull("surveyId")) {
                        dto.setSurveyId(json.getLong("surveyId"));
                    }
                    if (!json.isNull("repeatable")) {
                        dto.setRepeatable(json.getBoolean("repeatable"));
                    }
                    dtoList.add(dto);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Error in json parsing: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return dtoList;
    }

    private static List<SurveyGroupDto> parseSurveyGroups(String response) throws Exception {
        ArrayList<SurveyGroupDto> dtoList = new ArrayList<SurveyGroupDto>();
        JSONArray arr = BulkDataServiceClient.getJsonArray(response);
        if (arr != null) {
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject json = arr.getJSONObject(i);
                if (json == null) continue;
                SurveyGroupDto dto = new SurveyGroupDto();
                try {
                    if (!json.isNull("code")) {
                        dto.setCode(json.getString("code"));
                    }
                    if (!json.isNull("keyId")) {
                        dto.setKeyId(json.getLong("keyId"));
                    }
                    if (!json.isNull("displayName")) {
                        dto.setName(json.getString("displayName"));
                    }
                    if (!json.isNull("description")) {
                        dto.setDescription(json.getString("description"));
                    }
                    if (!json.isNull("projectType")) {
                        dto.setProjectType(SurveyGroup.ProjectType.valueOf(json.getString("projectType")));
                    }
                    if (!json.isNull("parentId")) {
                        dto.setParentId(json.getLong("parentId"));
                    }
                    if (!json.isNull("path")) {
                        dto.setPath(json.getString("path"));
                    }
                    if (!json.isNull("ancestorIds")) {
                        JSONArray idArr = json.getJSONArray("ancestorIds");
                        ArrayList<Long> ancestorIds = new ArrayList<Long>();
                        for (int ix = 0; ix < idArr.length(); ++ix) {
                            ancestorIds.add(idArr.getLong(ix));
                        }
                        dto.setAncestorIds(ancestorIds);
                    }
                    if (!json.isNull("defaultLanguageCode")) {
                        dto.setDefaultLanguageCode(json.getString("defaultLanguageCode"));
                    }
                    if (!json.isNull("monitoringGroup")) {
                        dto.setMonitoringGroup(json.getBoolean("monitoringGroup"));
                    }
                    if (!json.isNull("newLocaleSurveyId")) {
                        dto.setNewLocaleSurveyId(json.getLong("newLocaleSurveyId"));
                    }
                    dtoList.add(dto);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Error in json parsing: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return dtoList;
    }

    private static List<SurveyDto> parseSurveys(String response) throws Exception {
        ArrayList<SurveyDto> dtoList = new ArrayList<SurveyDto>();
        JSONArray arr = BulkDataServiceClient.getJsonArray(response);
        if (arr != null) {
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject json = arr.getJSONObject(i);
                if (json == null) continue;
                SurveyDto dto = new SurveyDto();
                try {
                    if (!json.isNull("code")) {
                        dto.setCode(json.getString("code"));
                    }
                    if (!json.isNull("defaultLanguageCode")) {
                        dto.setDefaultLanguageCode(json.getString("defaultLanguageCode"));
                    }
                    if (!json.isNull("description")) {
                        dto.setDescription(json.getString("description"));
                    }
                    if (!json.isNull("keyId")) {
                        dto.setKeyId(json.getLong("keyId"));
                    }
                    if (!json.isNull("name")) {
                        dto.setName(json.getString("name"));
                    }
                    if (!json.isNull("path")) {
                        dto.setPath(json.getString("path"));
                    }
                    if (!json.isNull("requireApproval")) {
                        dto.setRequireApproval(json.getBoolean("requireApproval"));
                    }
                    if (!json.isNull("status")) {
                        dto.setStatus(json.getString("status"));
                    }
                    if (!json.isNull("surveyGroupId")) {
                        dto.setSurveyGroupId(json.getLong("surveyGroupId"));
                    }
                    if (!json.isNull("version")) {
                        dto.setVersion(json.getString("version"));
                    }
                    if (!json.isNull("translationMap")) {
                        dto.setTranslationMap(BulkDataServiceClient.parseTranslations(json.getJSONObject("translationMap")));
                    }
                    if (!json.isNull("ancestorIds")) {
                        JSONArray idArr = json.getJSONArray("ancestorIds");
                        ArrayList<Long> ancestorIds = new ArrayList<Long>();
                        for (int ix = 0; ix < idArr.length(); ++ix) {
                            ancestorIds.add(idArr.getLong(ix));
                        }
                        dto.setAncestorIds(ancestorIds);
                    }
                    dtoList.add(dto);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Error in json parsing: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return dtoList;
    }

    private static List<DeviceFilesDto> parseDeviceFiles(String response) throws Exception {
        if (response.startsWith("{")) {
            ArrayList<DeviceFilesDto> dtoList = new ArrayList<DeviceFilesDto>();
            JSONArray arr = BulkDataServiceClient.getJsonArray(response);
            if (arr != null) {
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject json = arr.getJSONObject(i);
                    dtoList.add(BulkDataServiceClient.parseDeviceFile(json));
                }
                return dtoList;
            }
            return null;
        }
        return null;
    }

    public static DeviceFilesDto parseDeviceFile(JSONObject json) throws JSONException {
        DeviceFilesDto dto = new DeviceFilesDto();
        if (json != null) {
            String x;
            if (json.has("processingMessage")) {
                x = json.getString("processingMessage");
                dto.setProcessingMessage(x);
            }
            if (json.has("phoneNumber")) {
                x = json.getString("phoneNumber");
                dto.setPhoneNumber(x);
            }
            if (json.has("processedStatus")) {
                x = json.getString("processedStatus");
                dto.setProcessedStatus(x);
            }
            if (json.has("checksum")) {
                x = json.getString("checksum");
                dto.setChecksum(x);
            }
            if (json.has("processDate")) {
                x = json.getString("processDate");
                dto.setProcessDate(x);
            }
            if (json.has("URI")) {
                x = json.getString("URI");
                dto.setURI(x);
            }
            if (json.has("surveyInstanceId")) {
                x = json.getString("surveyInstanceId");
                dto.setSurveyInstanceId(Long.parseLong(x));
            }
        }
        return dto;
    }

    private static List<QuestionDto> parseQuestions(String response) throws Exception {
        if (response.startsWith("{")) {
            ArrayList<QuestionDto> dtoList = new ArrayList<QuestionDto>();
            JSONArray arr = BulkDataServiceClient.getJsonArray(response);
            if (arr != null) {
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject json = arr.getJSONObject(i);
                    if (json == null) continue;
                    QuestionDto dto = new QuestionDto();
                    try {
                        if (json.has("surveyId") && json.getString("surveyId") != null) {
                            String numberC = json.getString("surveyId");
                            try {
                                dto.setSurveyId(Long.parseLong(numberC));
                            }
                            catch (NumberFormatException nex) {
                                dto.setSurveyId(null);
                            }
                        }
                        if (!json.isNull("allowMultipleFlag")) {
                            dto.setAllowMultipleFlag(json.getBoolean("allowMultipleFlag"));
                        }
                        if (!json.isNull("allowOtherFlag")) {
                            dto.setAllowOtherFlag(json.getBoolean("allowOtherFlag"));
                        }
                        if (!json.isNull("order")) {
                            dto.setOrder(json.getInt("order"));
                        }
                        if (!json.isNull("questionGroupId")) {
                            dto.setQuestionGroupId(json.getLong("questionGroupId"));
                        }
                        if (!json.isNull("tip")) {
                            dto.setTip(json.optString("tip"));
                        }
                        if (!json.isNull("variableName")) {
                            dto.setVariableName(json.optString("variableName"));
                        }
                        if (!json.isNull("path")) {
                            dto.setPath(json.getString("path"));
                        }
                        if (!json.isNull("text")) {
                            dto.setText(json.getString("text"));
                        }
                        if (!json.isNull("keyId")) {
                            dto.setKeyId(json.getLong("keyId"));
                        }
                        if (!json.isNull("collapseable")) {
                            dto.setCollapseable(json.getBoolean("collapseable"));
                        }
                        if (!json.isNull("dependentFlag")) {
                            dto.setDependentFlag(json.getBoolean("dependentFlag"));
                        }
                        if (!json.isNull("dependentQuestionAnswer")) {
                            dto.setDependentQuestionAnswer(json.optString("dependentQuestionAnswer"));
                        }
                        if (json.has("dependentQuestionId")) {
                            try {
                                dto.setDependentQuestionId(json.getLong("dependentQuestionId"));
                            }
                            catch (Exception e) {
                                dto.setDependentQuestionId(null);
                            }
                        }
                        if (!json.isNull("geoLocked")) {
                            dto.setGeoLocked(json.getBoolean("geoLocked"));
                        }
                        if (!json.isNull("caddisflyResourceUuid")) {
                            dto.setCaddisflyResourceUuid(json.getString("caddisflyResourceUuid"));
                        }
                        if (!json.isNull("immutable")) {
                            dto.setImmutable(json.getBoolean("immutable"));
                        }
                        if (!json.isNull("isName")) {
                            dto.setName(json.getBoolean("isName"));
                        }
                        if (!json.isNull("localeNameFlag")) {
                            dto.setLocaleNameFlag(json.getBoolean("localeNameFlag"));
                        }
                        if (!json.isNull("mandatoryFlag")) {
                            dto.setMandatoryFlag(json.getBoolean("mandatoryFlag"));
                        }
                        if (json.has("metricId")) {
                            try {
                                dto.setMetricId(json.getLong("metricId"));
                            }
                            catch (Exception e) {
                                dto.setMetricId(null);
                            }
                        }
                        if (!json.isNull("requireDoubleEntry")) {
                            dto.setRequireDoubleEntry(json.getBoolean("requireDoubleEntry"));
                        }
                        if (json.has("sourceId")) {
                            try {
                                dto.setSourceId(json.getLong("sourceId"));
                            }
                            catch (Exception e) {
                                dto.setSourceId(null);
                            }
                        }
                        if (!json.isNull("allowDecimal")) {
                            dto.setAllowDecimal(json.getBoolean("allowDecimal"));
                        }
                        if (!json.isNull("allowSign")) {
                            dto.setAllowSign(json.getBoolean("allowSign"));
                        }
                        if (json.has("minVal")) {
                            try {
                                dto.setMinVal(json.getDouble("minVal"));
                            }
                            catch (Exception e) {
                                dto.setMinVal(null);
                            }
                        }
                        if (json.has("maxVal")) {
                            try {
                                dto.setMaxVal(json.getDouble("maxVal"));
                            }
                            catch (Exception e) {
                                dto.setMaxVal(null);
                            }
                        }
                        if (!json.isNull("translationMap")) {
                            dto.setTranslationMap(BulkDataServiceClient.parseTranslations(json.getJSONObject("translationMap")));
                        }
                        if (!json.isNull("type")) {
                            dto.setType(QuestionDto.QuestionType.valueOf(json.getString("type")));
                        }
                        if (!json.isNull("allowPoints")) {
                            dto.setAllowPoints(json.getBoolean("allowPoints"));
                        }
                        if (!json.isNull("allowLine")) {
                            dto.setAllowLine(json.getBoolean("allowLine"));
                        }
                        if (!json.isNull("allowPolygon")) {
                            dto.setAllowPolygon(json.getBoolean("allowPolygon"));
                        }
                        if (!json.isNull("optionContainerDto")) {
                            OptionContainerDto container = new OptionContainerDto();
                            JSONObject contJson = json.getJSONObject("optionContainerDto");
                            if (!contJson.isNull("optionsList")) {
                                JSONArray optArray = contJson.getJSONArray("optionsList");
                                if (optArray != null) {
                                    for (int j = 0; j < optArray.length(); ++j) {
                                        JSONObject optJson = optArray.getJSONObject(j);
                                        QuestionOptionDto opt = new QuestionOptionDto();
                                        opt.setKeyId(optJson.getLong("keyId"));
                                        opt.setText(optJson.getString("text"));
                                        if (!optJson.isNull("code")) {
                                            opt.setCode(optJson.getString("code"));
                                        }
                                        opt.setOrder(optJson.getInt("order"));
                                        if (!optJson.isNull("translationMap")) {
                                            opt.setTranslationMap(BulkDataServiceClient.parseTranslations(optJson.getJSONObject("translationMap")));
                                        }
                                        container.addQuestionOption(opt);
                                    }
                                }
                                dto.setOptionContainerDto(container);
                            }
                        }
                        if (!json.isNull("questionDependency")) {
                            QuestionDependencyDto dep = new QuestionDependencyDto();
                            JSONObject depJson = json.getJSONObject("questionDependency");
                            dep.setQuestionId(depJson.getLong("questionId"));
                            dep.setAnswerValue(depJson.getString("answerValue"));
                            dto.setQuestionDependency(dep);
                        }
                        if (!json.isNull("levelNames")) {
                            ArrayList<String> levelNames = new ArrayList<String>();
                            JSONArray array = json.getJSONArray("levelNames");
                            for (int c = 0; c < array.length(); ++c) {
                                levelNames.add(array.getString(c));
                            }
                            dto.setLevelNames(levelNames);
                        }
                        dtoList.add(dto);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error in json parsing: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            return dtoList;
        }
        return null;
    }

    private static List<QuestionOptionDto> parseQuestionOptions(String response) {
        ArrayList<QuestionOptionDto> dtoList = new ArrayList<QuestionOptionDto>();
        try {
            JSONArray jsonArray = BulkDataServiceClient.getJsonArray(response);
            if (jsonArray != null) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject json = jsonArray.getJSONObject(i);
                    if (json == null) continue;
                    QuestionOptionDto dto = new QuestionOptionDto();
                    dto.setQuestionId(json.getLong("questionId"));
                    dto.setText(json.optString("text", null));
                    dto.setCode(json.optString("code", null));
                    dtoList.add(dto);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)("Could not parse question options: " + response), (Throwable)e);
        }
        return dtoList;
    }

    private static TreeMap<String, TranslationDto> parseTranslations(JSONObject translationMapJson) throws Exception {
        Iterator keyIter = translationMapJson.keys();
        TreeMap<String, TranslationDto> translationMap = null;
        if (keyIter != null) {
            translationMap = new TreeMap<String, TranslationDto>();
            while (keyIter.hasNext()) {
                String lang = (String)keyIter.next();
                JSONObject transObj = translationMapJson.getJSONObject(lang);
                if (transObj == null) continue;
                TranslationDto tDto = new TranslationDto();
                tDto.setKeyId(transObj.getLong("keyId"));
                tDto.setParentId(transObj.getLong("parentId"));
                tDto.setParentType(transObj.getString("parentType"));
                tDto.setLangCode(lang);
                tDto.setText(transObj.getString("text"));
                translationMap.put(lang, tDto);
            }
        }
        return translationMap;
    }

    private static Map<String, TranslationDto> parseTranslationsForGroups(JSONObject translationMapJson) throws Exception {
        Iterator keyIter = translationMapJson.keys();
        HashMap<String, TranslationDto> translationMap = null;
        if (keyIter != null) {
            translationMap = new HashMap<String, TranslationDto>();
            while (keyIter.hasNext()) {
                String lang = (String)keyIter.next();
                JSONObject transObj = translationMapJson.getJSONObject(lang);
                if (transObj == null) continue;
                TranslationDto tDto = new TranslationDto();
                tDto.setKeyId(transObj.getLong("keyId"));
                tDto.setParentId(transObj.getLong("parentId"));
                tDto.setParentType(transObj.getString("parentType"));
                tDto.setLangCode(lang);
                tDto.setText(transObj.getString("text"));
                translationMap.put(lang, tDto);
            }
        }
        return translationMap;
    }

    public static String fetchDataFromServer(String baseUrl, String queryString, boolean shouldSign, String apiKey) throws Exception {
        if (shouldSign && apiKey != null) {
            if (queryString == null) {
                queryString = new String();
            } else {
                if (queryString.trim().startsWith("?")) {
                    queryString = queryString.trim().substring(1);
                }
                queryString = queryString + "&";
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            queryString = queryString + "ts=" + URLEncoder.encode(df.format(new Date()), "UTF-8");
            queryString = BulkDataServiceClient.sortQueryString(queryString);
            queryString = queryString + "&h=" + MD5Util.generateHMAC(queryString, apiKey);
        }
        return BulkDataServiceClient.fetchDataFromServer(baseUrl + (queryString != null && queryString.trim().length() > 0 ? "?" + queryString : ""));
    }

    public static String fetchDataFromServer(String fullUrl) throws Exception {
        if (fullUrl != null) {
            if (fullUrl.length() > 1900) {
                return BulkDataServiceClient.fetchDataFromServerPOST(fullUrl);
            }
            return BulkDataServiceClient.fetchDataFromServerGET(fullUrl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchDataFromServerPOST(String fullUrl) throws Exception {
        String result = null;
        try (BufferedReader reader = null;){
            String baseUrl = fullUrl;
            String queryString = null;
            if (fullUrl.contains("?")) {
                baseUrl = fullUrl.substring(0, fullUrl.indexOf("?"));
                queryString = fullUrl.substring(fullUrl.indexOf("?") + 1);
            } else {
                queryString = "";
            }
            URL url = new URL(baseUrl);
            log.debug((Object)("Calling: " + baseUrl + " with params: " + queryString));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(30000);
            conn.setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Length", "" + Integer.toString(queryString.getBytes().length));
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.addRequestProperty("Accept-Encoding", "gzip");
            conn.addRequestProperty("User-Agent", "gzip");
            DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
            wr.writeBytes(queryString);
            wr.flush();
            wr.close();
            InputStream instream = conn.getInputStream();
            String contentEncoding = conn.getHeaderField("Content-Encoding");
            reader = contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(instream), "UTF-8")) : new BufferedReader(new InputStreamReader(instream, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            result = sb.toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchDataFromServerGET(String fullUrl) throws Exception {
        String result = null;
        try (BufferedReader reader = null;){
            URL url = new URL(fullUrl);
            log.debug((Object)("Calling: " + url.toString()));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(30000);
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.addRequestProperty("Accept-Encoding", "gzip");
            conn.addRequestProperty("User-Agent", "gzip");
            InputStream instream = conn.getInputStream();
            String contentEncoding = conn.getHeaderField("Content-Encoding");
            reader = contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(instream), "UTF-8")) : new BufferedReader(new InputStreamReader(instream, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            result = sb.toString();
        }
        return result;
    }

    private static String sortQueryString(String queryString) throws UnsupportedEncodingException {
        String[] parts = queryString.split("&");
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (int i = 0; i < parts.length; ++i) {
            String[] nvp = parts[i].split("=");
            if (nvp.length <= 1) continue;
            if (nvp.length == 2) {
                pairs.add(new NameValuePair(nvp[0], nvp[1]));
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int j = 1; j < nvp.length; ++j) {
                if (builder.length() > 0) {
                    builder.append("=");
                }
                builder.append(nvp[j]);
            }
            pairs.add(new NameValuePair(nvp[0], builder.toString()));
        }
        Collections.sort(pairs);
        StringBuilder result = new StringBuilder();
        for (NameValuePair nvp : pairs) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(nvp.getName()).append("=");
            if (nvp.getName().equals("ts")) {
                result.append(nvp.getValue());
                continue;
            }
            result.append(URLEncoder.encode(nvp.getValue(), "UTF-8"));
        }
        return result.toString();
    }

    public static JSONArray getJsonArray(String response) throws Exception {
        JSONObject json;
        log.debug((Object)("response: " + response));
        if (response != null && (json = new JSONObject(response)) != null) {
            return json.getJSONArray(RESPONSE_KEY);
        }
        return null;
    }
}

