/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.common.util.MemCacheUtils;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.framework.exceptions.IllegalDeletionException;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.dao.QuestionHelpMediaDao;
import com.gallatinsystems.survey.dao.QuestionOptionDao;
import com.gallatinsystems.survey.dao.ScoringRuleDao;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.QuestionHelpMedia;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.Translation;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Transaction;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.annotations.NotPersistent;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;

public class QuestionDao
extends BaseDAO<Question> {
    private QuestionOptionDao optionDao = new QuestionOptionDao();
    private QuestionHelpMediaDao helpDao = new QuestionHelpMediaDao();
    private TranslationDao translationDao = new TranslationDao();
    private ScoringRuleDao scoringRuleDao = new ScoringRuleDao();
    private Cache cache = MemCacheUtils.initCache(14400);

    public QuestionDao() {
        super(Question.class);
    }

    public Question getQuestionHeader(Long id) {
        return this.getByKey(id);
    }

    public List<Question> listQuestionsBySurvey(Long surveyId) {
        List<Question> questionsList = this.listByProperty("surveyId", (Object)surveyId, "Long", "order", "asc");
        if (questionsList == null) {
            return Collections.emptyList();
        }
        this.cache(questionsList);
        return questionsList;
    }

    @Override
    public void delete(List<Question> qList) {
        this.uncache(qList);
        super.delete(qList);
    }

    @Override
    public void delete(Question question) throws IllegalDeletionException {
        this.delete(question, Boolean.FALSE);
    }

    public void delete(Question question, Boolean adjustQuestionOrder) throws IllegalDeletionException {
        TreeMap<Integer, Question> groupQs;
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        if (qasDao.listByQuestion(question.getKey().getId()).size() > 0) {
            throw new IllegalDeletionException("Cannot delete question with id " + question.getKey().getId() + " (" + question.getText() + ") because there are already survey responses stored for this question. Please delete all survey responses first.");
        }
        this.helpDao.deleteHelpMediaForQuestion(question.getKey().getId());
        this.optionDao.deleteOptionsForQuestion(question.getKey().getId());
        this.translationDao.deleteTranslationsForParent(question.getKey().getId(), Translation.ParentType.QUESTION_TEXT);
        Long deletedQuestionGroupId = question.getQuestionGroupId();
        Integer deletedQuestionOrder = question.getOrder();
        this.uncache(Arrays.asList(question));
        super.delete(question);
        if (adjustQuestionOrder != null && adjustQuestionOrder.booleanValue() && (groupQs = this.listQuestionsByQuestionGroup(deletedQuestionGroupId, false)) != null) {
            for (Question gq : groupQs.values()) {
                if (gq.getOrder() < deletedQuestionOrder) continue;
                gq.setOrder(gq.getOrder() - 1);
            }
        }
    }

    public void deleteQuestionsForGroup(Long questionGroupId) throws IllegalDeletionException {
        for (Question q : this.listQuestionsByQuestionGroup(questionGroupId, Boolean.TRUE).values()) {
            this.delete(q, Boolean.FALSE);
        }
    }

    public List<Question> listQuestionsInOrderForGroup(Long groupId) {
        return this.listByProperty("questionGroupId", (Object)groupId, "Long", "order", "asc");
    }

    public List<Question> listQuestionsInOrder(Long surveyId, Question.Type type) {
        ArrayList<Question> orderedQuestionList = new ArrayList<Question>();
        QuestionGroupDao qgDao = new QuestionGroupDao();
        List<QuestionGroup> orderedGroupList = qgDao.listQuestionGroupBySurvey(surveyId);
        HashMap idMap = new HashMap();
        for (QuestionGroup group : orderedGroupList) {
            ArrayList arrayList = new ArrayList();
            idMap.put(group.getKey().getId(), arrayList);
        }
        List<Object> unorderedQuestions = type == null ? this.listByProperty("surveyId", surveyId, "Long") : this.getBySurveyAndType(surveyId, type);
        for (Question question : unorderedQuestions) {
            List myList = (List)idMap.get(question.getQuestionGroupId());
            if (myList == null) continue;
            myList.add(question);
        }
        for (QuestionGroup questionGroup : orderedGroupList) {
            List questions = (List)idMap.get(questionGroup.getKey().getId());
            Collections.sort(questions, new Comparator<Question>(){

                @Override
                public int compare(Question o1, Question o2) {
                    int v1 = o1.getOrder() != null ? o1.getOrder() : 0;
                    int v2 = o2.getOrder() != null ? o2.getOrder() : 0;
                    return v1 - v2;
                }
            });
            orderedQuestionList.addAll(questions);
        }
        return orderedQuestionList;
    }

    private List<Question> getBySurveyAndType(long surveyId, Question.Type type) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Question.class);
        query.setFilter(" surveyId == surveyIdParam && type == questionTypeParam");
        query.declareParameters("Long surveyIdParam, String questionTypeParam");
        List results = (List)query.execute((Object)surveyId, (Object)type.toString());
        if (results != null && results.size() > 0) {
            return results;
        }
        return Collections.emptyList();
    }

    public Question saveTransactional(Question q) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Transaction txn = datastore.beginTransaction();
        Entity question = null;
        try {
            if (q.getKey() != null) {
                try {
                    question = datastore.get(q.getKey());
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "Key is set but not found. Assuming this is an import");
                    question = new Entity(q.getKey());
                }
            } else {
                question = new Entity("Question");
            }
            Field[] f = Question.class.getDeclaredFields();
            for (int i = 0; i < f.length; ++i) {
                if ("key".equals(f[i].getName()) || f[i].getAnnotation(NotPersistent.class) != null || "type".equals(f[i].getName()) || f[i].getName().startsWith("jdo") || f[i].getName().equals("serialVersionUID")) continue;
                f[i].setAccessible(true);
                question.setProperty(f[i].getName(), f[i].get(q));
            }
            question.setProperty("type", (Object)q.getType().toString());
            Date date = new Date();
            if (question.getProperty("createdDateTime") == null) {
                question.setProperty("createdDateTime", (Object)date);
            }
            if (question.getProperty("lastUpdateDateTime") == null) {
                question.setProperty("lastUpdateDateTime", (Object)date);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Could not set entity fields", e);
        }
        Key key = datastore.put(question);
        q.setKey(key);
        this.cache(Arrays.asList(q));
        txn.commit();
        return q;
    }

    public Question save(Question question, Long questionGroupId) {
        List<Translation> translations;
        QuestionOptionDao qoDao;
        TreeMap<Integer, QuestionOption> qoMap;
        Long surveyId = null;
        if (questionGroupId != null) {
            question.setQuestionGroupId(questionGroupId);
            QuestionGroup group = this.getByKey(questionGroupId, QuestionGroup.class);
            if (group != null) {
                surveyId = group.getSurveyId();
                question.setSurveyId(surveyId);
            }
        }
        if ((qoMap = (qoDao = new QuestionOptionDao()).listOptionByQuestion((question = this.saveTransactional(question)).getKey().getId())) != null) {
            for (Map.Entry<Integer, QuestionOption> entry : qoMap.entrySet()) {
                qoDao.delete((BaseDomain)entry.getValue());
            }
        }
        if (question.getQuestionOptionMap() != null) {
            for (QuestionOption opt : question.getQuestionOptionMap().values()) {
                opt.setQuestionId(question.getKey().getId());
                if (opt.getText() != null && opt.getText().contains(",")) {
                    opt.setText(opt.getText().replaceAll(",", "-"));
                    if (opt.getCode() != null) {
                        opt.setCode(opt.getCode().replaceAll(",", "-"));
                    }
                }
                this.save(opt);
                HashMap<String, Translation> optionsTranslationMap = opt.getTranslationMap();
                if (optionsTranslationMap == null) continue;
                for (Translation t : optionsTranslationMap.values()) {
                    t.setParentId(opt.getKey().getId());
                    t.setSurveyId(surveyId);
                    t.setQuestionGroupId(questionGroupId);
                }
                super.save(optionsTranslationMap.values());
            }
        }
        if ((translations = question.getTranslations()) != null) {
            for (Translation t : translations) {
                t.setParentId(question.getKey().getId());
                t.setSurveyId(surveyId);
                t.setQuestionGroupId(questionGroupId);
            }
            super.save(translations);
        }
        if (question.getQuestionHelpMediaMap() != null) {
            for (QuestionHelpMedia help : question.getQuestionHelpMediaMap().values()) {
                help.setQuestionId(question.getKey().getId());
                this.save(help);
                if (help.getTranslationMap() == null) continue;
                for (Translation t : help.getTranslationMap().values()) {
                    if (t.getParentId() != null) continue;
                    t.setParentId(help.getKey().getId());
                }
                super.save(help.getTranslationMap().values());
            }
        }
        return question;
    }

    @Override
    public Question save(Question question) {
        Question savedQuestion = super.save(question);
        this.cache(Arrays.asList(savedQuestion));
        return savedQuestion;
    }

    @Override
    public List<Question> save(List<Question> qList) {
        List savedQuestions = (List)super.save(qList);
        this.cache(savedQuestions);
        return savedQuestions;
    }

    private void cache(List<Question> qList) {
        if (qList == null || qList.isEmpty()) {
            return;
        }
        HashMap<Object, Object> cacheMap = new HashMap<Object, Object>();
        for (Question qn : qList) {
            if (qn == null) continue;
            String cacheKey = null;
            try {
                cacheKey = this.getCacheKey(qn);
                cacheMap.put(cacheKey, qn);
            }
            catch (CacheException e) {
                this.log.log(Level.WARNING, e.getMessage());
            }
        }
        MemCacheUtils.putObjects(this.cache, cacheMap);
    }

    private void uncache(List<Question> qList) {
        if (qList == null || qList.isEmpty()) {
            return;
        }
        for (Question qn : qList) {
            if (qn == null) continue;
            try {
                String cacheKey = this.getCacheKey(qn);
                if (!MemCacheUtils.containsKey(this.cache, cacheKey)) continue;
                this.cache.remove((Object)cacheKey);
            }
            catch (CacheException e) {
                this.log.log(Level.WARNING, e.getMessage());
            }
        }
    }

    @Deprecated
    public Question findByReferenceId(String refid) {
        Question q = (Question)this.findByProperty("referenceIndex", refid, "String");
        return q;
    }

    public Question getByKey(Long id, boolean needDetails) {
        Question q = this.getByKey(id);
        if (needDetails) {
            q.setQuestionHelpMediaMap(this.helpDao.listHelpByQuestion(q.getKey().getId()));
            if (Question.Type.OPTION == q.getType()) {
                q.setQuestionOptionMap(this.optionDao.listOptionByQuestion(q.getKey().getId()));
            }
            q.setTranslations(this.translationDao.findTranslations(q.getKey().getId(), Translation.ParentType.QUESTION_TEXT, Translation.ParentType.QUESTION_TIP));
            if (Question.Type.OPTION == q.getType() || Question.Type.FREE_TEXT == q.getType() || Question.Type.NUMBER == q.getType()) {
                q.setScoringRules(this.scoringRuleDao.listRulesByQuestion(q.getKey().getId()));
            }
        }
        return q;
    }

    @Override
    public Question getByKey(Key key) {
        return (Question)super.getByKey(key);
    }

    @Override
    public Question getByKey(Long questionId) {
        Question question = null;
        String cacheKey = null;
        try {
            cacheKey = this.getCacheKey(questionId.toString());
            if (MemCacheUtils.containsKey(this.cache, cacheKey)) {
                return (Question)this.cache.get((Object)cacheKey);
            }
        }
        catch (CacheException e) {
            this.log.log(Level.WARNING, e.getMessage());
        }
        question = (Question)super.getByKey(questionId);
        this.cache(Arrays.asList(question));
        return question;
    }

    public List<Question> listQuestionsByQuestionGroupOrderByCreatedDateTime(Long questionGroupId) {
        return this.listByProperty("questionGroupId", (Object)questionGroupId, "Long", "createdDateTime", "asc");
    }

    public TreeMap<Integer, Question> listQuestionsByQuestionGroup(Long questionGroupId, boolean needDetails) {
        return this.listQuestionsByQuestionGroup(questionGroupId, needDetails, true);
    }

    public List<Question> listQuestionsByForm(Long formId, boolean needDetails) {
        List<Question> qList = this.listByProperty("surveyId", (Object)formId, "Long", "order", "asc");
        TreeMap<Integer, Question> map = new TreeMap<Integer, Question>();
        if (qList != null) {
            for (Question q : qList) {
                if (needDetails) {
                    CascadeResource cr;
                    if (Question.Type.OPTION == q.getType()) {
                        q.setQuestionOptionMap(this.optionDao.listOptionByQuestion(q.getKey().getId()));
                    }
                    q.setTranslations(this.translationDao.findTranslations(q.getKey().getId(), Translation.ParentType.QUESTION_TEXT, Translation.ParentType.QUESTION_TIP));
                    if (q.getType().equals((Object)Question.Type.CASCADE) && q.getCascadeResourceId() != null && (cr = (CascadeResource)new CascadeResourceDao().getByKey(q.getCascadeResourceId())) != null) {
                        q.setCascadeResource(cr.getResourceId());
                        q.setLevelNames(cr.getLevelNames());
                    }
                }
                if (q.getOrder() == null) {
                    q.setOrder(qList.size() + 1);
                }
                map.put(q.getOrder(), q);
            }
        }
        return qList;
    }

    public TreeMap<Integer, Question> listQuestionsByQuestionGroup(Long questionGroupId, boolean needDetails, boolean allowSideEffects) {
        List qList = this.listByProperty("questionGroupId", (Object)questionGroupId, "Long", "order", "asc");
        TreeMap<Integer, Question> map = new TreeMap<Integer, Question>();
        if (qList != null) {
            for (Question q : qList) {
                if (needDetails) {
                    CascadeResource cr;
                    q.setQuestionHelpMediaMap(this.helpDao.listHelpByQuestion(q.getKey().getId()));
                    if (Question.Type.OPTION == q.getType() || Question.Type.STRENGTH == q.getType()) {
                        q.setQuestionOptionMap(this.optionDao.listOptionByQuestion(q.getKey().getId()));
                    }
                    q.setTranslations(this.translationDao.findTranslations(q.getKey().getId(), Translation.ParentType.QUESTION_TEXT));
                    if (q.getType().equals((Object)Question.Type.CASCADE) && q.getCascadeResourceId() != null && (cr = (CascadeResource)new CascadeResourceDao().getByKey(q.getCascadeResourceId())) != null) {
                        q.setLevelNames(cr.getLevelNames());
                    }
                }
                if (q.getOrder() == null) {
                    q.setOrder(qList.size() + 1);
                } else if (allowSideEffects) {
                    if (q.getOrder() != map.size() + 1) {
                        this.log.log(Level.WARNING, "Reordering question in group " + questionGroupId + " from " + q.getOrder() + " to " + (map.size() + 1));
                        q.setOrder(map.size() + 1);
                        super.save(q);
                    } else if (map.size() == 0) {
                        super.save(q);
                    }
                }
                map.put(q.getOrder(), q);
            }
        }
        return map;
    }

    public Question getByPath(Integer order, String path) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Question.class);
        query.setFilter(" path == pathParam && order == orderParam");
        query.declareParameters("String pathParam, String orderParam");
        List results = (List)query.execute((Object)path, (Object)order);
        if (results != null && results.size() > 0) {
            return (Question)results.get(0);
        }
        return null;
    }

    public Question getByQuestionGroupId(Long questionGroupId, String questionText) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Question.class);
        query.setFilter(" questionGroupId == questionGroupIdParam && text == questionTextParam");
        query.declareParameters("Long questionGroupIdParam, String questionTextParam");
        List results = (List)query.execute((Object)questionGroupId, (Object)questionText);
        if (results != null && results.size() > 0) {
            return (Question)results.get(0);
        }
        return null;
    }

    public Question getByGroupIdAndOrder(Long questionGroupId, Integer order) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Question.class);
        query.setFilter(" questionGroupId == questionGroupIdParam && order == orderParam");
        query.declareParameters("Long questionGroupIdParam, Integer orderParam");
        List results = (List)query.execute((Object)questionGroupId, (Object)order);
        if (results != null && results.size() > 0) {
            return (Question)results.get(0);
        }
        return null;
    }

    public void updateQuestionOrder(List<Question> questionList) {
        if (questionList != null) {
            for (Question q : questionList) {
                Question persistentQuestion = this.getByKey(q.getKey());
                persistentQuestion.setOrder(q.getOrder());
            }
        }
    }

    public void updateQuestionGroupOrder(List<QuestionGroup> groupList) {
        if (groupList != null) {
            for (QuestionGroup q : groupList) {
                QuestionGroup persistentGroup = this.getByKey(q.getKey(), QuestionGroup.class);
                persistentGroup.setOrder(q.getOrder());
            }
        }
    }

    public List<Question> listQuestionsByDependency(Long questionId) {
        return this.listByProperty("dependentQuestionId", questionId, "Long");
    }

    public List<Question> listDisplayNameQuestionsBySurveyId(Long surveyId) {
        QuestionGroupDao qgDao = new QuestionGroupDao();
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Question.class);
        query.setFilter("surveyId == surveyIdParam && localeNameFlag == true");
        query.declareParameters("Long surveyIdParam");
        query.setOrdering("order asc");
        List results = (List)query.execute((Object)surveyId);
        if (results != null && results.size() > 0) {
            TreeMap<Integer, Question> orderedQuestionMap = new TreeMap<Integer, Question>();
            for (Question question : results) {
                int orderIndex = 0;
                QuestionGroup qg = (QuestionGroup)qgDao.getByKey(question.getQuestionGroupId());
                if (qg != null) {
                    orderIndex = qg.getOrder() != null ? qg.getOrder() * 1000 : 0;
                    orderIndex += question.getOrder() != null ? question.getOrder() : 0;
                }
                orderedQuestionMap.put(orderIndex, question);
            }
            return new ArrayList<Question>(orderedQuestionMap.values());
        }
        return Collections.emptyList();
    }

    public List<Question> listByCascadeResourceId(Long cascadeResourceId) {
        return this.listByProperty("cascadeResourceId", cascadeResourceId, "Long");
    }

    public List<Question> listBySourceQuestionId(List<Long> sourceQuestionIds) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Question.class, ":p1.contains(sourceQuestionId)");
        List results = (List)query.execute(sourceQuestionIds);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }
}

