/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.api.app.DataPointRequest;
import org.akvo.flow.api.app.DataPointResponse;
import org.akvo.flow.api.app.DataPointUtil;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;

public class DataPointOnlyServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(DataPointOnlyServlet.class.getName());
    private static final int LIMIT_DATAPOINTS_1000 = 1000;

    public DataPointOnlyServlet() {
        this.setMode("JSON");
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DataPointRequest restRequest = new DataPointRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        List<SurveyedLocale> dpList;
        DataPointRequest dpReq = (DataPointRequest)req;
        DataPointResponse res = new DataPointResponse();
        if (dpReq.getSurveyId() == null) {
            res.setCode(String.valueOf(403));
            res.setMessage("Invalid Survey");
            return res;
        }
        DataPointUtil dpu = new DataPointUtil();
        try {
            dpList = dpu.getAssignedDataPoints(dpReq.getAndroidId(), dpReq.getSurveyId(), dpReq.getCursor(), 1000);
        }
        catch (Exception e) {
            res.setCode(String.valueOf(404));
            res.setMessage(e.getMessage());
            return res;
        }
        res = this.convertToResponse(dpList);
        res.setCursor(BaseDAO.getCursor(dpList));
        return res;
    }

    private DataPointResponse convertToResponse(List<SurveyedLocale> slList) {
        DataPointResponse resp = new DataPointResponse();
        if (slList == null) {
            resp.setCode(String.valueOf(500));
            resp.setMessage("Internal Server Error");
            return resp;
        }
        resp.setCode(String.valueOf(200));
        resp.setResultCount(slList.size());
        DataPointUtil dpu = new DataPointUtil();
        List<SurveyedLocaleDto> dtoList = dpu.getSimpleSurveyedLocaleDtosList(slList);
        resp.setDataPointData(dtoList);
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        int sc;
        try {
            sc = Integer.valueOf(resp.getCode());
        }
        catch (NumberFormatException ignored) {
            sc = 500;
        }
        this.getResponse().setStatus(sc);
        if (sc == 200) {
            FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
            ServletOutputStream stream = this.getResponse().getOutputStream();
            writer.writeValue((OutputStream)stream, resp);
            PrintWriter endwriter = new PrintWriter((OutputStream)stream);
            endwriter.println();
        } else {
            this.getResponse().getWriter().println(resp.getMessage());
        }
    }
}

