/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.domain;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.akvo.flow.util.FlowJsonObjectReader;
import org.apache.log4j.Logger;

public class DataUtils {
    private static final Logger log = Logger.getLogger(DataUtils.class);

    public static String[] optionResponsesTextArray(String optionResponse) {
        String[] responseArray = null;
        if (optionResponse == null || optionResponse.trim().equals("")) {
            return new String[0];
        }
        List<Map<String, String>> optionNodes = DataUtils.jsonStringToList(optionResponse);
        if (optionNodes != null) {
            responseArray = new String[optionNodes.size()];
            for (int i = 0; i < responseArray.length; ++i) {
                String text = optionNodes.get(i).get("text");
                if (text == null || "".equals(text.trim())) continue;
                responseArray[i] = text.trim();
            }
        } else {
            responseArray = optionResponse.split("\\|");
        }
        return responseArray;
    }

    public static String[] cascadeResponseValues(String data) {
        String[] values = null;
        if (data == null || data.trim().equals("")) {
            return new String[0];
        }
        List<Map<String, String>> nodes = DataUtils.jsonStringToList(data);
        if (nodes != null) {
            values = new String[nodes.size()];
            for (int i = 0; i < values.length; ++i) {
                String text = nodes.get(i).get("name");
                if (text == null || "".equals(text.trim())) continue;
                values[i] = text.trim();
            }
        } else {
            values = data.split("\\|", -1);
        }
        return values;
    }

    public static String jsonResponsesToPipeSeparated(String optionResponses) {
        StringBuilder pipeSeparated = new StringBuilder();
        List<Map<String, String>> options = DataUtils.jsonStringToList(optionResponses);
        if (options != null) {
            for (Map<String, String> option : options) {
                if (option.get("text") != null) {
                    pipeSeparated.append("|").append(option.get("text"));
                    continue;
                }
                if (option.get("name") == null) continue;
                pipeSeparated.append("|").append(option.get("name"));
            }
        }
        if (pipeSeparated.length() > 0) {
            pipeSeparated.deleteCharAt(0);
        }
        return pipeSeparated.toString();
    }

    public static List<Map<String, String>> jsonStringToList(String data) {
        FlowJsonObjectReader jsonReader = new FlowJsonObjectReader();
        TypeReference<List<Map<String, String>>> typeReference = new TypeReference<List<Map<String, String>>>(){};
        try {
            return jsonReader.readObject(data, typeReference);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String parseSignatory(String value) {
        FlowJsonObjectReader jsonReader = new FlowJsonObjectReader();
        Map<String, String> signatureResponse = null;
        TypeReference<Map<String, String>> typeReference = new TypeReference<Map<String, String>>(){};
        try {
            signatureResponse = jsonReader.readObject(value, typeReference);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (String)signatureResponse.get("name");
    }

    public static Map<String, Object> parseCaddisflyResponseValue(String caddisflyValue) {
        Map<String, Object> caddisflyResponseMap = null;
        FlowJsonObjectReader jsonReader = new FlowJsonObjectReader();
        TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>(){};
        try {
            caddisflyResponseMap = jsonReader.readObject(caddisflyValue, typeReference);
        }
        catch (IOException e) {
            log.warn((Object)"Failed to parse the caddisfly response");
        }
        if (caddisflyResponseMap != null) {
            return caddisflyResponseMap;
        }
        return Collections.emptyMap();
    }
}

