/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Translation;
import java.util.ArrayList;
import java.util.List;
import org.akvo.flow.xml.XmlAltText;

public class XmlHelp {
    @JacksonXmlProperty(localName="type", isAttribute=true)
    private String type;
    @JacksonXmlProperty(localName="text", isAttribute=false)
    private String text;
    @JacksonXmlElementWrapper(localName="altText", useWrapping=false)
    private List<XmlAltText> altText;

    public XmlHelp(Question q) {
        this.text = q.getTip();
        List<Translation> translations = q.getTranslations();
        for (Translation t : translations) {
            if (!Translation.ParentType.QUESTION_TIP.equals((Object)t.getParentType())) continue;
            if (this.altText == null) {
                this.altText = new ArrayList<XmlAltText>();
            }
            this.altText.add(new XmlAltText(t));
        }
    }

    public String toString() {
        return "help{type='" + this.type + "',text='" + this.text + "'}";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<XmlAltText> getAltText() {
        return this.altText;
    }

    public void setAltText(List<XmlAltText> altText) {
        this.altText = altText;
    }
}

