/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.domain.Translation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class TranslationDao
extends BaseDAO<Translation> {
    public TranslationDao() {
        super(Translation.class);
    }

    public HashMap<String, Translation> findTranslations(Translation.ParentType parentType, Long parentId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Translation.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("parentType", filterString, paramString, "String", (Object)parentType, paramMap);
        this.appendNonNullParam("parentId", filterString, paramString, "Long", parentId, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        HashMap<String, Translation> translations = new HashMap<String, Translation>();
        List translationList = (List)query.executeWithMap(paramMap);
        if (translationList != null) {
            for (Translation t : translationList) {
                translations.put(t.getLanguageCode(), t);
            }
        }
        return translations;
    }

    public List<Translation> listTranslationsByQuestionGroup(long questionGroupId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Translation.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("questionGroupId", filterString, paramString, "Long", questionGroupId, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        List result = (List)query.executeWithMap(paramMap);
        return result;
    }

    public void deleteTranslationsForParent(Long parentId, Translation.ParentType parentType) {
        HashMap<String, Translation> trans = this.findTranslations(parentType, parentId);
        Collection<Translation> values = trans.values();
        if (values != null && values.size() > 0) {
            this.delete(trans.values());
        }
    }

    public List<Translation> listTranslations(Integer count, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query q = pm.newQuery(Translation.class);
        this.prepareCursor(cursorString, count, q);
        List tList = (List)q.execute();
        return tList;
    }

    public List<Translation> listByFormId(long id) {
        return this.listByProperty("surveyId", id, "Long");
    }
}

