/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.WebForm;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.akvo.flow.util.OneTimePadCypher;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.SurveyNotValidAsWebformException;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.app.web.rest.dto.SurveyPayload;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;

@Controller
@RequestMapping(value={"/surveys"})
public class SurveyRestService {
    private static final Logger log = Logger.getLogger(SurveyRestService.class.getName());
    private SurveyDAO surveyDao = new SurveyDAO();
    private SurveyGroupDAO surveyGroupDao = new SurveyGroupDAO();
    private QuestionDao questionDao = new QuestionDao();
    private QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();

    public Map<String, Object> listSurveys() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<SurveyDto> results = new ArrayList<SurveyDto>();
        List<Survey> surveys = this.surveyDao.listAllFilteredByUserAuthorization();
        if (surveys != null) {
            for (Survey s : surveys) {
                SurveyDto dto = new SurveyDto();
                DtoMarshaller.copyToDto(s, dto);
                dto.setDescription(s.getDesc());
                results.add(dto);
            }
        }
        response.put("surveys", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listSurveysByGroupId(@RequestParam(value="surveyGroupId", defaultValue="") Long surveyGroupId, @RequestParam(value="ids[]", defaultValue="") Long[] ids, @RequestParam(value="preflight", defaultValue="") String preflight, @RequestParam(value="surveyId", defaultValue="") Long surveyId) {
        if (surveyGroupId == null && ids[0] == null && preflight.equals("") && surveyId == null) {
            return this.listSurveys();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<SurveyDto> results = new ArrayList<SurveyDto>();
        List<Survey> surveys = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        if (preflight != null && preflight.equals("delete") && surveyId != null) {
            statusDto.setStatus("preflight-delete-survey");
            statusDto.setMessage("cannot_delete");
            if (this.qasDao.listBySurvey(surveyId).size() == 0) {
                statusDto.setMessage("can_delete");
                statusDto.setKeyId(surveyId);
            }
            response.put("surveys", results);
            response.put("meta", statusDto);
            return response;
        }
        if (surveyGroupId != null) {
            surveys = this.surveyDao.listSurveysByGroup(surveyGroupId);
        } else if (ids[0] != null) {
            surveys = this.surveyDao.listByKeys(ids);
        }
        if (surveys != null) {
            for (Survey s : this.surveyDao.filterByUserAuthorizationObjectId(surveys)) {
                SurveyDto dto = new SurveyDto();
                DtoMarshaller.copyToDto(s, dto);
                dto.setDescription(s.getDesc());
                results.add(dto);
            }
        }
        response.put("surveys", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/webform_id"})
    @ResponseBody
    public Map<String, String> webformUrl(@PathVariable(value="id") Long id) {
        HashMap<String, String> response = new HashMap<String, String>();
        List<Question> questions = this.questionDao.listQuestionsBySurvey(id);
        Survey survey = this.surveyDao.getById(id);
        boolean validWebForm = WebForm.validWebForm((SurveyGroup)this.surveyGroupDao.getByKey(survey.getSurveyGroupId()), survey, questions);
        if (!validWebForm) {
            throw new SurveyNotValidAsWebformException("Webforms don't support monitoring surveys, or repeatable question groups or the following question types: geoshape, signature or caddisfly");
        }
        survey.setWebForm(validWebForm);
        this.surveyDao.save(survey);
        response.put("webformId", OneTimePadCypher.encrypt(PropertyUtil.getProperty("restPrivateKey"), id.toString()));
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, SurveyDto> findSurvey(@PathVariable(value="id") Long id) {
        HashMap<String, SurveyDto> response = new HashMap<String, SurveyDto>();
        Survey s = (Survey)this.surveyDao.getByKey(id);
        SurveyDto dto = null;
        if (s != null) {
            dto = new SurveyDto();
            DtoMarshaller.copyToDto(s, dto);
            dto.setDescription(s.getDesc());
        }
        response.put("survey", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteSurveyById(@PathVariable(value="id") Long surveyId) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        Survey survey = (Survey)this.surveyDao.getByKey(surveyId);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (survey != null) {
            try {
                TaskOptions deleteSurveyTask = TaskOptions.Builder.withUrl((String)"/app_worker/surveytask").param("action", "deleteSurvey").param("id", surveyId.toString());
                QueueFactory.getQueue((String)"deletequeue").add(deleteSurveyTask);
                statusDto.setStatus("ok");
                statusDto.setMessage("deleted");
            }
            catch (Exception e) {
                statusDto.setStatus("failed");
                statusDto.setMessage(e.getMessage());
            }
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingSurvey(@RequestBody SurveyPayload payLoad) {
        Survey s;
        SurveyDto requestDto = payLoad.getSurvey();
        HashMap<String, Object> response = new HashMap<String, Object>();
        SurveyDto responseDto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (requestDto != null && requestDto.getKeyId() != null && (s = (Survey)this.surveyDao.getByKey(requestDto.getKeyId())) != null) {
            BeanUtils.copyProperties((Object)requestDto, (Object)s, (String[])new String[]{"createdDateTime", "status", "sector", "version", "lastUpdateDateTime", "description", "ancestorIds"});
            s.setAncestorIds(SurveyUtils.retrieveAncestorIds(s));
            s.setDesc(requestDto.getDescription());
            String name = s.getName();
            if (name != null) {
                String trimmedName = name.replaceAll(",", " ").trim();
                s.setName(trimmedName);
                s.setCode(trimmedName);
                s.setPath(SurveyUtils.fixPath(s.getPath(), trimmedName));
            }
            if (requestDto.getStatus() != null && s.getStatus().equals((Object)Survey.Status.PUBLISHED) && !s.getStatus().equals((Object)Survey.Status.valueOf(requestDto.getStatus()))) {
                s.incrementVersion();
            }
            s.setStatus(Survey.Status.NOT_PUBLISHED);
            if (!requestDto.getVersion().equals(s.getVersion().toString())) {
                log.log(Level.WARNING, "Survey version does not match (dashboard=" + requestDto.getVersion() + " datastore=" + s.getVersion() + ")");
            }
            s = this.surveyDao.save(s);
            responseDto = new SurveyDto();
            DtoMarshaller.copyToDto(s, responseDto);
            responseDto.setDescription(s.getDesc());
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("survey", responseDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewSurvey(@RequestBody SurveyPayload payLoad) {
        SurveyDto surveyDto = payLoad.getSurvey();
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (surveyDto == null) {
            return this.getErrorResponse();
        }
        Survey s = null;
        s = surveyDto.getSourceId() == null ? this.newSurvey(surveyDto) : this.copySurvey(surveyDto);
        if (s == null) {
            return this.getErrorResponse();
        }
        RestStatusDto statusDto = new RestStatusDto();
        SurveyDto dto = new SurveyDto();
        DtoMarshaller.copyToDto(s, dto);
        dto.setDescription(s.getDesc());
        statusDto.setStatus("ok");
        response.put("meta", statusDto);
        response.put("survey", dto);
        return response;
    }

    private Survey newSurvey(SurveyDto dto) {
        Survey result = this.surveyDao.save(this.marshallToDomain(dto));
        return result;
    }

    private Survey copySurvey(SurveyDto dto) {
        Survey source = this.surveyDao.getById(dto.getSourceId());
        if (source == null) {
            return null;
        }
        return SurveyUtils.copySurvey(source, dto, false);
    }

    private Survey marshallToDomain(SurveyDto dto) {
        Survey s = new Survey();
        BeanUtils.copyProperties((Object)dto, (Object)s, (String[])new String[]{"createdDateTime", "status", "sector", "version", "lastUpdateDateTime", "displayName", "questionGroupList", "ancestorIds"});
        if (dto.getStatus() != null) {
            s.setStatus(Survey.Status.valueOf(dto.getStatus().toString()));
        }
        s.setAncestorIds(SurveyUtils.retrieveAncestorIds(s));
        s.getVersion();
        s.setCode(s.getName());
        return s;
    }

    private Map<String, Object> getErrorResponse() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        response.put("meta", statusDto);
        response.put("survey", null);
        return response;
    }
}

