/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.ApprovalStepDAO;
import com.gallatinsystems.survey.dao.DataPointApprovalDAO;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.domain.ApprovalStep;
import com.gallatinsystems.survey.domain.DataPointApproval;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.api.app.FormInstanceResponse;
import org.akvo.flow.api.app.FormInstanceUtil;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.springframework.beans.BeanUtils;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.app.web.dto.InstanceDataDto;
import org.waterforpeople.mapping.app.web.dto.SurveyInstanceRequest;
import org.waterforpeople.mapping.app.web.dto.SurveyInstanceResponse;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class SurveyInstanceServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(SurveyInstanceServlet.class.getName());
    private static final String UUID = "UUID";
    private static final String GEO = "GEO";
    private static final long serialVersionUID = -7690514561766005021L;
    private SurveyInstanceDAO surveyInstanceDao;
    private DataPointApprovalDAO approvalDao;
    private ApprovalStepDAO approvalStepDao;
    public static final int LIMIT_FORM_INSTANCES_30 = 30;

    public SurveyInstanceServlet() {
        this.setMode("JSON");
        this.surveyInstanceDao = new SurveyInstanceDAO();
        this.approvalDao = new DataPointApprovalDAO();
        this.approvalStepDao = new ApprovalStepDAO();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyInstanceRequest restRequest = new SurveyInstanceRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        SurveyInstance si;
        SurveyInstanceRequest siReq = (SurveyInstanceRequest)req;
        SurveyInstanceDAO siDao = new SurveyInstanceDAO();
        if ("getInstanceData".equals(siReq.getAction())) {
            return this.retrieveInstanceData(siReq.surveyInstanceId);
        }
        if ("getFormInstances".equals(siReq.getAction())) {
            FormInstanceResponse response = new FormInstanceResponse();
            FormInstanceUtil formInstanceUtil = new FormInstanceUtil();
            try {
                List<SurveyInstance> formInstances = formInstanceUtil.getFormInstances(siReq.getAndroidId(), siReq.getDataPointIdentifier(), 30, siReq.getCursor());
                response.setSurveyInstances(formInstanceUtil.getFormInstancesDtoList(formInstances));
                response.setCursor(BaseDAO.getCursor(formInstances));
                response.setResultCount(formInstances.size());
                return response;
            }
            catch (Exception e) {
                log.warning("Exception accessing endpoint: " + e.getMessage());
                response.setCode(String.valueOf(404));
                response.setMessage(e.getMessage());
                return response;
            }
        }
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        SurveyInstanceResponse sir = new SurveyInstanceResponse();
        if (GEO.equalsIgnoreCase(siReq.getFieldName())) {
            List<QuestionAnswerStore> qasList = qasDao.listByTypeValue(siReq.getFieldName(), siReq.getValue());
            if (qasList != null && qasList.size() > 0) {
                sir.setSurveyInstanceId(qasList.get(0).getSurveyInstanceId());
                sir.setCreatedDateTime(qasList.get(0).getCreatedDateTime());
            }
        } else if (UUID.equalsIgnoreCase(siReq.getFieldName()) && (si = siDao.findByUUID(siReq.getValue())) != null) {
            sir.setSurveyInstanceId(si.getKey().getId());
            sir.setCreatedDateTime(si.getCreatedDateTime());
        }
        return sir;
    }

    private RestResponse retrieveInstanceData(Long surveyInstanceId) {
        SurveyInstance si = (SurveyInstance)this.surveyInstanceDao.getByKey(surveyInstanceId);
        si.setSurveyedLocaleDisplayName(this.makeDatapointName(si));
        SurveyInstanceDto siDto = new SurveyInstanceDto();
        BeanUtils.copyProperties((Object)si, (Object)siDto);
        siDto.setKeyId(si.getKey().getId());
        InstanceDataDto instanceData = new InstanceDataDto();
        instanceData.surveyInstanceData = siDto;
        if (si.getSurveyedLocaleId() != null) {
            instanceData.latestApprovalStatus = this.retrieveDataPointApprovalStatus(si.getSurveyedLocaleId());
        }
        return instanceData;
    }

    private String makeDatapointName(SurveyInstance si) {
        SurveyedLocaleDao slDao = new SurveyedLocaleDao();
        QuestionDao qDao = new QuestionDao();
        SurveyInstanceDAO siDao = new SurveyInstanceDAO();
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        Long surveyedLocaleId = si.getSurveyedLocaleId();
        if (surveyedLocaleId == null) {
            return "";
        }
        SurveyedLocale sl = slDao.getById(surveyedLocaleId);
        if (sl == null) {
            return "";
        }
        Long regSurveyId = sl.getCreationSurveyId() == null ? si.getSurveyId() : sl.getCreationSurveyId();
        if (regSurveyId == null) {
            return "";
        }
        List<Question> nameQuestions = qDao.listDisplayNameQuestionsBySurveyId(regSurveyId);
        if (nameQuestions == null) {
            return "";
        }
        SurveyInstance regSurveyInstance = siDao.getRegistrationSurveyInstance(sl, regSurveyId);
        if (regSurveyInstance == null) {
            return "";
        }
        List<QuestionAnswerStore> responses = qasDao.listBySurveyInstance(regSurveyInstance.getKey().getId());
        sl.assembleDisplayName(nameQuestions, responses);
        return sl.getDisplayName();
    }

    private String retrieveDataPointApprovalStatus(Long surveyedLocaleId) {
        List<DataPointApproval> approvals = this.approvalDao.listBySurveyedLocaleId(surveyedLocaleId);
        List<Long> approvalStepIds = this.extractApprovalStepIds(approvals);
        ApprovalStep latestApprovalStep = this.retrieveLatestApprovalStep(approvalStepIds);
        return this.buildLatestApprovalStatus(latestApprovalStep, approvals);
    }

    private List<Long> extractApprovalStepIds(List<DataPointApproval> approvals) {
        ArrayList<Long> stepIds = new ArrayList<Long>();
        for (DataPointApproval approval : approvals) {
            stepIds.add(approval.getApprovalStepId());
        }
        return stepIds;
    }

    private ApprovalStep retrieveLatestApprovalStep(List<Long> approvalStepIds) {
        ApprovalStep latestApprovalStep = null;
        for (ApprovalStep step : this.approvalStepDao.listByKeys(approvalStepIds)) {
            if (latestApprovalStep != null && latestApprovalStep.getOrder() >= step.getOrder()) continue;
            latestApprovalStep = step;
        }
        return latestApprovalStep;
    }

    private String buildLatestApprovalStatus(ApprovalStep latestApprovalStep, List<DataPointApproval> approvals) {
        StringBuilder latestApprovalStatus = new StringBuilder();
        if (latestApprovalStep != null || !approvals.isEmpty()) {
            for (DataPointApproval approval : approvals) {
                if (!approval.getApprovalStepId().equals(latestApprovalStep.getKey().getId())) continue;
                latestApprovalStatus.append(latestApprovalStep.getTitle()).append(" - ").append((Object)approval.getStatus());
            }
        }
        return latestApprovalStatus.toString();
    }

    @Override
    protected void writeOkResponse(RestResponse response) throws Exception {
        this.getResponse().setStatus(200);
        FlowJsonObjectWriter writer = new FlowJsonObjectWriter().withExcludeNullValues();
        writer.writeValue((OutputStream)this.getResponse().getOutputStream(), response);
    }
}

