/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.gallatinsystems.framework.dataexport.applet.DataExporter;
import com.gallatinsystems.survey.domain.SurveyGroup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyGroupDto;
import org.waterforpeople.mapping.dataexport.service.BulkDataServiceClient;

public class StatisticsExporter
implements DataExporter {
    private static final Logger log = Logger.getLogger(StatisticsExporter.class);
    private static final String INSTANCE_COUNT_SHEET_NAME = "Form submissions";
    private static final String SURVEY_STATS_SHEET_NAME = "Survey statistics";
    private static final String SURVEY_STATS_HEADER1 = "Items";
    private static final String SURVEY_STATS_HEADER2 = "Count";
    private static final String SURVEY_HEADER = "Survey";
    private static final String FORM_HEADER = "Form name";
    private static final String FORM_ID_HEADER = "Form Id";
    private static final String COUNT_HEADER = "Submissions";
    private static final String SURVEY_GROUP_COUNT_LABEL = "Folders";
    private static final String SURVEY_COUNT_LABEL = "Surveys";
    private static final String FORM_COUNT_LABEL = "Total Forms";
    private static final String PUBLISHED_COUNT_LABEL = "Published Forms";
    private static final int COL_WIDTH = 10000;
    private static final String FROM_OPT = "from";
    private static final String TO_OPT = "to";
    private static final String PATH_DELIM = " / ";
    private static final SimpleDateFormat idf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat odf = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void export(Map<String, String> criteria, File fileName, String serverBase, Map<String, String> options) {
        try {
            String apiKey = criteria.get("apiKey");
            String from = options.get(FROM_OPT);
            String to = options.get(TO_OPT);
            List<SurveyGroupDto> groupList = BulkDataServiceClient.fetchSurveyGroups(serverBase, apiKey);
            HashMap<Long, SurveyGroupDto> groupMap = new HashMap<Long, SurveyGroupDto>();
            HashMap<SurveyGroupDto, List<SurveyDto>> formMap = new HashMap<SurveyGroupDto, List<SurveyDto>>();
            HashMap<SurveyDto, Long> instanceCounts = new HashMap<SurveyDto, Long>();
            for (SurveyGroupDto sg : groupList) {
                groupMap.put(sg.getKeyId(), sg);
                if (!SurveyGroup.ProjectType.PROJECT.equals((Object)sg.getProjectType())) continue;
                List<SurveyDto> formList = BulkDataServiceClient.fetchSurveys(sg.getKeyId(), serverBase, apiKey);
                formMap.put(sg, formList);
                for (SurveyDto form : formList) {
                    Long c = BulkDataServiceClient.fetchInstanceCount(form.getKeyId().toString(), serverBase, apiKey, from, to);
                    instanceCounts.put(form, c);
                }
            }
            log.debug((Object)("Surveys and Groups: " + groupMap.size()));
            log.debug((Object)("Surveys: " + formMap.size()));
            log.debug((Object)("Instance Counts: " + instanceCounts.size()));
            String title = INSTANCE_COUNT_SHEET_NAME;
            if (from != null && !"".equals(from.trim())) {
                Date fromDate = idf.parse(from);
                title = title + " from " + odf.format(fromDate);
            }
            if (to != null && !"".equals(to.trim())) {
                Date toDate = idf.parse(to);
                title = title + " to " + odf.format(toDate);
            }
            this.writeStats(title, fileName, groupMap, formMap, instanceCounts);
        }
        catch (Exception e) {
            log.error((Object)"Could not write stats", (Throwable)e);
        }
    }

    private void writeStats(String title, File fileName, Map<Long, SurveyGroupDto> groupMap, Map<SurveyGroupDto, List<SurveyDto>> formMap, Map<SurveyDto, Long> instanceCounts) throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFCellStyle headerStyle = wb.createCellStyle();
        headerStyle.setAlignment((short)2);
        XSSFFont headerFont = wb.createFont();
        headerFont.setBoldweight((short)700);
        headerStyle.setFont((Font)headerFont);
        XSSFCellStyle questionStyle = wb.createCellStyle();
        questionStyle.setVerticalAlignment((short)0);
        questionStyle.setWrapText(true);
        this.writeInstanceSheet(title, groupMap, formMap, instanceCounts, wb, headerStyle, questionStyle);
        this.writeSurveyStatsSheet(SURVEY_STATS_HEADER1, SURVEY_STATS_HEADER2, groupMap, formMap, wb, headerStyle, questionStyle);
        FileOutputStream fileOut = new FileOutputStream(fileName);
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    private void writeInstanceSheet(String title, Map<Long, SurveyGroupDto> groupMap, Map<SurveyGroupDto, List<SurveyDto>> formMap, Map<SurveyDto, Long> instanceCounts, XSSFWorkbook wb, XSSFCellStyle headerStyle, XSSFCellStyle questionStyle) {
        XSSFSheet sheet = wb.createSheet(INSTANCE_COUNT_SHEET_NAME);
        sheet.setColumnWidth(0, 10000);
        sheet.setColumnWidth(1, 10000);
        int curRow = 0;
        XSSFRow row = sheet.createRow(curRow++);
        sheet.addMergedRegion(new CellRangeAddress(curRow - 1, curRow - 1, 0, 3));
        this.createCell(row, 0, title, headerStyle);
        row = sheet.createRow(curRow++);
        this.createCell(row, 0, SURVEY_HEADER, headerStyle);
        this.createCell(row, 1, FORM_HEADER, headerStyle);
        this.createCell(row, 2, FORM_ID_HEADER, headerStyle);
        this.createCell(row, 3, COUNT_HEADER, headerStyle);
        TreeMap<String, SurveyGroupDto> surveyMap = new TreeMap<String, SurveyGroupDto>();
        for (SurveyGroupDto surveyGroupDto : groupMap.values()) {
            int loops;
            if (!SurveyGroup.ProjectType.PROJECT.equals((Object)surveyGroupDto.getProjectType())) continue;
            String name = surveyGroupDto.getCode();
            SurveyGroupDto parent = groupMap.get(surveyGroupDto.getParentId());
            for (loops = 0; parent != null && loops < 100; ++loops) {
                name = parent.getCode() + PATH_DELIM + name;
                parent = groupMap.get(parent.getParentId());
            }
            if (loops == 100) {
                log.error((Object)("Infinite Survey Group loop for " + surveyGroupDto.getKeyId()));
                name = "### structure error - infinite loop ###";
            }
            surveyMap.put(name, surveyGroupDto);
        }
        for (Map.Entry entry : surveyMap.entrySet()) {
            List<SurveyDto> formList = formMap.get(entry.getValue());
            for (SurveyDto form : formList) {
                row = sheet.createRow(curRow++);
                this.createCell(row, 0, (String)entry.getKey(), questionStyle);
                this.createCell(row, 1, form.getCode(), questionStyle);
                this.createCell(row, 2, form.getKeyId(), questionStyle);
                this.createCell(row, 3, instanceCounts.get(form), questionStyle);
            }
        }
    }

    private void writeSurveyStatsSheet(String title1, String title2, Map<Long, SurveyGroupDto> groupMap, Map<SurveyGroupDto, List<SurveyDto>> formMap, XSSFWorkbook wb, XSSFCellStyle headerStyle, XSSFCellStyle bodyStyle) {
        XSSFSheet sheet = wb.createSheet(SURVEY_STATS_SHEET_NAME);
        long formCount = 0L;
        long publishedCount = 0L;
        for (List<SurveyDto> formList : formMap.values()) {
            formCount += (long)formList.size();
            for (SurveyDto form : formList) {
                if (!"PUBLISHED".equals(form.getStatus())) continue;
                ++publishedCount;
            }
        }
        sheet.setColumnWidth(0, 10000);
        sheet.setColumnWidth(1, 10000);
        int curRow = 0;
        XSSFRow row = sheet.createRow(curRow++);
        this.createCell(row, 0, title1, headerStyle);
        this.createCell(row, 1, title2, headerStyle);
        row = sheet.createRow(curRow++);
        this.createCell(row, 0, SURVEY_GROUP_COUNT_LABEL, bodyStyle);
        this.createCell(row, 1, Long.valueOf(groupMap.size() - formMap.size()), bodyStyle);
        row = sheet.createRow(curRow++);
        this.createCell(row, 0, SURVEY_COUNT_LABEL, bodyStyle);
        this.createCell(row, 1, Long.valueOf(formMap.size()), bodyStyle);
        row = sheet.createRow(curRow++);
        this.createCell(row, 0, FORM_COUNT_LABEL, bodyStyle);
        this.createCell(row, 1, formCount, bodyStyle);
        row = sheet.createRow(curRow++);
        this.createCell(row, 0, PUBLISHED_COUNT_LABEL, bodyStyle);
        this.createCell(row, 1, publishedCount, bodyStyle);
    }

    private XSSFCell createCell(XSSFRow row, int col, String value, XSSFCellStyle headerStyle) {
        XSSFCell cell = row.createCell(col);
        if (headerStyle != null) {
            cell.setCellStyle((CellStyle)headerStyle);
        }
        if (value != null) {
            cell.setCellValue(value);
        }
        return cell;
    }

    private XSSFCell createCell(XSSFRow row, int col, Double value, XSSFCellStyle style) {
        XSSFCell cell = row.createCell(col);
        if (style != null) {
            cell.setCellStyle((CellStyle)style);
        }
        if (value != null) {
            cell.setCellValue(value.doubleValue());
        }
        return cell;
    }

    private XSSFCell createCell(XSSFRow row, int col, Long value, XSSFCellStyle style) {
        XSSFCell cell = row.createCell(col);
        if (style != null) {
            cell.setCellStyle((CellStyle)style);
        }
        if (value != null) {
            cell.setCellValue((double)value.longValue());
        }
        return cell;
    }

    private XSSFCell createCell(XSSFRow row, int col, Boolean value, XSSFCellStyle style) {
        XSSFCell cell = row.createCell(col);
        if (style != null) {
            cell.setCellStyle((CellStyle)style);
        }
        if (value != null && value.booleanValue()) {
            cell.setCellValue("Yes");
        }
        return cell;
    }

    private XSSFCell createCellBlock(XSSFRow row, int col, String value, XSSFCellStyle style, int width) {
        XSSFCell cell = row.createCell(col);
        if (width > 1) {
            row.getSheet().addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), col, col + width - 1));
        }
        if (style != null) {
            cell.setCellStyle((CellStyle)style);
        }
        if (value != null) {
            cell.setCellValue(value);
        }
        return cell;
    }

    public static void main(String[] args) {
        ConsoleAppender console = new ConsoleAppender();
        console.setLayout((Layout)new PatternLayout("%d{ISO8601} [%t] %-5p %c - %m%n"));
        console.setThreshold((Priority)Level.DEBUG);
        console.activateOptions();
        Logger.getRootLogger().addAppender((Appender)console);
        StatisticsExporter exporter = new StatisticsExporter();
        HashMap<String, String> criteria = new HashMap<String, String>();
        HashMap<String, String> options = new HashMap<String, String>();
        criteria.put("apiKey", args[2]);
        if (args.length > 3) {
            options.put(FROM_OPT, args[3]);
        }
        if (args.length > 4) {
            options.put(TO_OPT, args[4]);
        }
        exporter.export(criteria, new File(args[0]), args[1], options);
    }
}

