/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.exception.RestValidationException;
import javax.servlet.http.HttpServletRequest;

public class LocationBeaconRequest
extends RestRequest {
    private static final String PHONE_PARAM = "phoneNumber";
    private static final String LAT_PARAM = "lat";
    private static final String IMEI_PARAM = "imei";
    private static final String LON_PARAM = "lon";
    private static final String ACC_PARAM = "acc";
    private static final String VER_PARAM = "ver";
    private static final String DEV_ID_PARAM = "devId";
    private static final String OSVERSION_PARAM = "osVersion";
    private static final String ANDROID_ID = "androidId";
    private static final long serialVersionUID = 4549010911554976717L;
    private String phoneNumber;
    private String imei;
    private Double lat;
    private Double lon;
    private Double accuracy;
    private String appVersion;
    private String deviceIdentifier;
    private String osVersion;
    private String androidId;

    public String getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getImei() {
        return this.imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Double accuracy) {
        this.accuracy = accuracy;
    }

    public String getAndroidId() {
        return this.androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    @Override
    protected void populateErrors() {
        if (this.lon != null && this.lat == null) {
            this.addError(new RestError("5001", "Missing mandatory parameter", "lat cannot be null"));
        }
        if (this.lat != null && this.lon == null) {
            this.addError(new RestError("5001", "Missing mandatory parameter", "lon cannot be null"));
        }
        if (this.phoneNumber == null) {
            this.addError(new RestError("5001", "Missing mandatory parameter", "phoneNumber cannot be null"));
        }
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.phoneNumber = req.getParameter(PHONE_PARAM);
        this.appVersion = req.getParameter(VER_PARAM);
        this.deviceIdentifier = req.getParameter(DEV_ID_PARAM);
        this.imei = req.getParameter(IMEI_PARAM);
        this.osVersion = req.getParameter(OSVERSION_PARAM);
        this.androidId = req.getParameter(ANDROID_ID);
        try {
            if (req.getParameter(LAT_PARAM) != null) {
                this.lat = Double.parseDouble(req.getParameter(LAT_PARAM));
            }
            if (req.getParameter(LON_PARAM) != null) {
                this.lon = Double.parseDouble(req.getParameter(LON_PARAM));
            }
            if (req.getParameter(ACC_PARAM) != null) {
                this.accuracy = Double.parseDouble(req.getParameter(ACC_PARAM));
            }
        }
        catch (NumberFormatException e) {
            throw new RestValidationException(new RestError("5002", "Invalid data type", "lat, lon and acc must be doubles"), "Lat/lon must be doubles", (Exception)e);
        }
    }
}

