/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.common.Constants;
import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.akvo.flow.api.app.NoDataPointsAssignedException;
import org.akvo.flow.dao.DataPointAssignmentDao;
import org.akvo.flow.domain.DataUtils;
import org.akvo.flow.domain.persistent.DataPointAssignment;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;
import org.waterforpeople.mapping.serialization.response.MediaResponse;

public class DataPointUtil {
    private static final Logger log = Logger.getLogger(DataPointUtil.class.getName());
    SurveyedLocaleDao surveyedLocaleDao = new SurveyedLocaleDao();
    DataPointAssignmentDao dataPointAssignmentDao = new DataPointAssignmentDao();

    public List<SurveyedLocaleDto> getSimpleSurveyedLocaleDtosList(List<SurveyedLocale> slList) {
        ArrayList<SurveyedLocaleDto> dtoList = new ArrayList<SurveyedLocaleDto>();
        for (SurveyedLocale surveyedLocale : slList) {
            SurveyedLocaleDto dto = this.createSimpleSurveyedLocaleDto(surveyedLocale);
            dtoList.add(dto);
        }
        return dtoList;
    }

    public List<SurveyedLocaleDto> getSurveyedLocaleDtosList(List<SurveyedLocale> slList, Long surveyId) {
        ArrayList<SurveyedLocaleDto> dtoList = new ArrayList<SurveyedLocaleDto>();
        HashMap<Long, String> questionTypeMap = new HashMap<Long, String>();
        QuestionDao questionDao = new QuestionDao();
        List<Long> surveyedLocalesIds = this.getSurveyedLocalesIds(slList);
        Map<Long, List<SurveyInstance>> surveyInstancesMap = this.getSurveyInstances(surveyedLocalesIds);
        Map<Long, List<QuestionAnswerStore>> questionAnswerStore = this.getQuestionAnswerStoreMap(surveyInstancesMap);
        for (SurveyedLocale surveyedLocale : slList) {
            long surveyedLocaleId = surveyedLocale.getKey().getId();
            SurveyedLocaleDto dto = this.createSurveyedLocaleDto(surveyId, questionDao, questionTypeMap, surveyedLocale, questionAnswerStore, surveyInstancesMap.get(surveyedLocaleId));
            dtoList.add(dto);
        }
        return dtoList;
    }

    public List<SurveyedLocale> getAssignedDataPoints(String androidId, Long surveyId, String cursor, int limit) throws Exception {
        DeviceDAO deviceDao = new DeviceDAO();
        Device device = deviceDao.getDevice(androidId, null, null);
        if (device == null) {
            throw new Exception("Device not found");
        }
        log.fine("Found device: " + device);
        long deviceId = device.getKey().getId();
        List<DataPointAssignment> dataPointAssignments = this.dataPointAssignmentDao.listByDeviceAndSurvey(deviceId, surveyId);
        if (dataPointAssignments.isEmpty()) {
            log.log(Level.WARNING, "No assignments found for surveyId: " + surveyId + " - deviceId: " + deviceId);
            throw new NoDataPointsAssignedException("No datapoints assigned found");
        }
        return this.getDataPointList(dataPointAssignments.get(0), surveyId, cursor, limit);
    }

    private List<SurveyedLocale> getDataPointList(DataPointAssignment assignment, Long surveyId, String cursor, int limit) {
        if (assignment == null || this.allDataPointsAreAssigned(assignment)) {
            return this.getAllDataPoints(surveyId, cursor, limit);
        }
        return this.getAssignedDataPoints(assignment);
    }

    private boolean allDataPointsAreAssigned(DataPointAssignment assignment) {
        if (assignment == null) {
            return false;
        }
        HashSet<Long> assignedDataPoints = new HashSet<Long>(assignment.getDataPointIds());
        return Constants.ALL_DATAPOINTS.equals(assignedDataPoints);
    }

    private List<SurveyedLocale> getAllDataPoints(Long surveyId, String cursor, int limit) {
        return this.surveyedLocaleDao.listLocalesBySurveyGroupAndUpdateDate(surveyId, null, cursor, limit);
    }

    private List<SurveyedLocale> getAssignedDataPoints(DataPointAssignment assignment) {
        HashSet<Long> assignedDataPointIds = new HashSet<Long>();
        assignedDataPointIds.addAll(assignment.getDataPointIds());
        return this.surveyedLocaleDao.listByKeys(new ArrayList<Long>(assignedDataPointIds));
    }

    private SurveyedLocaleDto createSimpleSurveyedLocaleDto(SurveyedLocale surveyedLocale) {
        SurveyedLocaleDto dto = new SurveyedLocaleDto();
        dto.setId(surveyedLocale.getIdentifier());
        dto.setSurveyGroupId(surveyedLocale.getSurveyGroupId());
        dto.setDisplayName(surveyedLocale.getDisplayName());
        dto.setLat(surveyedLocale.getLatitude());
        dto.setLon(surveyedLocale.getLongitude());
        dto.setLastUpdateDateTime(surveyedLocale.getLastUpdateDateTime());
        return dto;
    }

    private SurveyedLocaleDto createSurveyedLocaleDto(Long surveyGroupId, QuestionDao questionDao, HashMap<Long, String> questionTypeMap, SurveyedLocale surveyedLocale, Map<Long, List<QuestionAnswerStore>> questionAnswerStoreMap, @Nullable List<SurveyInstance> surveyInstances) {
        SurveyedLocaleDto dto = new SurveyedLocaleDto();
        dto.setId(surveyedLocale.getIdentifier());
        dto.setSurveyGroupId(surveyGroupId);
        dto.setDisplayName(surveyedLocale.getDisplayName());
        dto.setLat(surveyedLocale.getLatitude());
        dto.setLon(surveyedLocale.getLongitude());
        dto.setLastUpdateDateTime(surveyedLocale.getLastUpdateDateTime());
        if (surveyInstances != null) {
            for (SurveyInstance surveyInstance : surveyInstances) {
                Long surveyInstanceId = surveyInstance.getObjectId();
                List<QuestionAnswerStore> answerStores = questionAnswerStoreMap.get(surveyInstanceId);
                SurveyInstanceDto siDto = this.createSurveyInstanceDto(questionDao, questionTypeMap, answerStores, surveyInstance);
                dto.getSurveyInstances().add(siDto);
            }
        }
        return dto;
    }

    private Map<Long, List<QuestionAnswerStore>> getQuestionAnswerStoreMap(Map<Long, List<SurveyInstance>> surveyInstanceMap) {
        QuestionAnswerStoreDao questionAnswerStoreDao = new QuestionAnswerStoreDao();
        List<Long> surveyInstancesIds = this.getSurveyInstancesIds(surveyInstanceMap);
        List questionAnswerList = questionAnswerStoreDao.fetchItemsByIdBatches(surveyInstancesIds, "surveyInstanceId");
        HashMap<Long, List<QuestionAnswerStore>> questionAnswerStoreMap = new HashMap<Long, List<QuestionAnswerStore>>();
        if (questionAnswerList != null && questionAnswerList.size() > 0) {
            for (QuestionAnswerStore questionAnswerStore : questionAnswerList) {
                Long surveyInstanceId = questionAnswerStore.getSurveyInstanceId();
                if (questionAnswerStoreMap.containsKey(surveyInstanceId)) {
                    ((List)questionAnswerStoreMap.get(surveyInstanceId)).add(questionAnswerStore);
                    continue;
                }
                ArrayList<QuestionAnswerStore> questionAnswerStores = new ArrayList<QuestionAnswerStore>();
                questionAnswerStores.add(questionAnswerStore);
                questionAnswerStoreMap.put(surveyInstanceId, questionAnswerStores);
            }
        }
        return questionAnswerStoreMap;
    }

    private List<Long> getSurveyInstancesIds(Map<Long, List<SurveyInstance>> surveyInstanceMap) {
        ArrayList<Long> surveyInstancesIds = new ArrayList<Long>();
        Collection<List<SurveyInstance>> values = surveyInstanceMap.values();
        for (List<SurveyInstance> surveyInstances : values) {
            for (SurveyInstance surveyInstance : surveyInstances) {
                surveyInstancesIds.add(surveyInstance.getObjectId());
            }
        }
        return surveyInstancesIds;
    }

    private Map<Long, List<SurveyInstance>> getSurveyInstances(List<Long> surveyedLocalesIds) {
        SurveyInstanceDAO surveyInstanceDAO = new SurveyInstanceDAO();
        SurveyedLocaleDao surveyedLocaleDao = new SurveyedLocaleDao();
        List<SurveyInstance> values = surveyInstanceDAO.getMonitoringData(surveyedLocaleDao.listByKeys(surveyedLocalesIds), 3);
        return values.stream().collect(Collectors.groupingBy(SurveyInstance::getSurveyedLocaleId));
    }

    private List<Long> getSurveyedLocalesIds(List<SurveyedLocale> slList) {
        if (slList == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> surveyedLocaleIds = new ArrayList<Long>(slList.size());
        for (SurveyedLocale surveyedLocale : slList) {
            surveyedLocaleIds.add(surveyedLocale.getKey().getId());
        }
        return surveyedLocaleIds;
    }

    private SurveyInstanceDto createSurveyInstanceDto(QuestionDao qDao, HashMap<Long, String> questionTypeMap, @Nullable List<QuestionAnswerStore> questionAnswerStores, @Nullable SurveyInstance surveyInstance) {
        SurveyInstanceDto surveyInstanceDto = new SurveyInstanceDto();
        if (surveyInstance != null) {
            surveyInstanceDto.setUuid(surveyInstance.getUuid());
            surveyInstanceDto.setSubmitter(surveyInstance.getSubmitterName());
            surveyInstanceDto.setSurveyId(surveyInstance.getSurveyId());
            surveyInstanceDto.setCollectionDate(surveyInstance.getCollectionDate());
        }
        if (questionAnswerStores != null) {
            for (QuestionAnswerStore questionAnswerStore : questionAnswerStores) {
                Long questionId = questionAnswerStore.getQuestionIDLong();
                if (questionId == null) continue;
                String type = this.getQuestionType(qDao, questionTypeMap, questionAnswerStore);
                String value = this.getAnswerValue(questionAnswerStore, type);
                surveyInstanceDto.addProperty(questionId, value, type);
            }
        }
        return surveyInstanceDto;
    }

    private String getAnswerValue(QuestionAnswerStore questionAnswerStore, String type) {
        String answerValue = questionAnswerStore.getValue();
        String value = answerValue != null ? answerValue : "";
        switch (type) {
            case "OPTION": 
            case "OTHER": {
                if (!value.startsWith("[")) break;
                value = DataUtils.jsonResponsesToPipeSeparated(value);
                break;
            }
            case "IMAGE": 
            case "VIDEO": {
                value = MediaResponse.format(value, 0);
                break;
            }
        }
        return value;
    }

    private String getQuestionType(QuestionDao questionDao, HashMap<Long, String> questionTypeMap, QuestionAnswerStore questionAnswerStore) {
        String type = questionAnswerStore.getType();
        if (type == null || "".equals(type)) {
            type = "VALUE";
        } else if ("PHOTO".equals(type)) {
            type = "IMAGE";
        } else if ("OPTION".equals(type)) {
            Long questionId = questionAnswerStore.getQuestionIDLong();
            if (questionTypeMap.containsKey(questionId)) {
                type = questionTypeMap.get(questionId);
            } else {
                Question question = questionDao.getByKey(questionId);
                if (question != null) {
                    if (question.getAllowOtherFlag().booleanValue()) {
                        type = "OTHER";
                    }
                    questionTypeMap.put(questionId, type);
                }
            }
        }
        return type;
    }
}

