/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.akvo.flow.api.app.NoDataPointsAssignedException;
import org.akvo.flow.dao.DataPointAssignmentDao;
import org.akvo.flow.domain.persistent.DataPointAssignment;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.QuestionAnswerStoreDto;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class FormInstanceUtil {
    private static final Logger log = Logger.getLogger(FormInstanceUtil.class.getName());
    SurveyedLocaleDao surveyedLocaleDao = new SurveyedLocaleDao();
    DataPointAssignmentDao dataPointAssignmentDao = new DataPointAssignmentDao();
    QuestionAnswerStoreDao qasDAO = new QuestionAnswerStoreDao();

    public List<SurveyInstance> getFormInstances(String androidId, long dataPointId, Integer pageSize, String cursor) throws Exception {
        DeviceDAO deviceDao = new DeviceDAO();
        Device device = deviceDao.getDevice(androidId, null, null);
        if (device == null) {
            throw new Exception("Device not found");
        }
        log.fine("Found device: " + device);
        SurveyedLocale dataPoint = this.surveyedLocaleDao.getById(dataPointId);
        if (dataPoint == null) {
            throw new Exception("Datapoint not found");
        }
        log.fine("Datapoint: " + dataPoint);
        List<DataPointAssignment> dataPointAssignments = this.dataPointAssignmentDao.listByDeviceAndSurvey(device.getKey().getId(), dataPoint.getSurveyGroupId());
        if (dataPointAssignments.isEmpty()) {
            throw new NoDataPointsAssignedException("No assignments found");
        }
        SurveyInstanceDAO siDAO = new SurveyInstanceDAO();
        return siDAO.listInstancesByLocale(dataPoint.getKey().getId(), null, null, pageSize, cursor);
    }

    public List<SurveyInstanceDto> getFormInstancesDtoList(List<SurveyInstance> formInstances) {
        ArrayList<SurveyInstanceDto> formInstancesDTO = new ArrayList<SurveyInstanceDto>();
        for (SurveyInstance si : formInstances) {
            SurveyInstanceDto siDTO = new SurveyInstanceDto();
            siDTO.setUuid(si.getUuid());
            siDTO.setSubmitter(si.getSubmitterName());
            siDTO.setSurveyId(si.getSurveyId());
            siDTO.setCollectionDate(si.getCollectionDate());
            ArrayList<QuestionAnswerStoreDto> qasDTOList = new ArrayList<QuestionAnswerStoreDto>();
            List<QuestionAnswerStore> questionAnswerStoreList = this.qasDAO.listBySurvey(si.getSurveyId());
            for (QuestionAnswerStore qas : questionAnswerStoreList) {
                QuestionAnswerStoreDto qasDTO = new QuestionAnswerStoreDto();
                qasDTO.setT(qas.getType());
                qasDTO.setQ(qas.getQuestionID());
                qasDTO.setA(qas.getValue());
                qasDTOList.add(qasDTO);
            }
            siDTO.setQasList(qasDTOList);
            formInstancesDTO.add(siDTO);
        }
        return formInstancesDTO;
    }
}

