/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.MailUtil;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.common.util.ZipUtil;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.waterforpeople.mapping.app.web.dto.BootstrapGeneratorRequest;

public class BootstrapGeneratorServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(BootstrapGeneratorServlet.class.getName());
    private static final long serialVersionUID = -6645180848307957119L;
    private static final String DB_INST_ENTRY = "dbinstructions.sql";
    private static final String BOOTSTRAP_UPLOAD_DIR = "bootstrapdir";
    private static final String EMAIL_FROM_ADDRESS_KEY = "emailFromAddress";
    private static final String EMAIL_SUB = "FLOW Bootstrap File";
    private static final String EMAIL_BODY = "Click the link to download the bootstrap file";
    private static final String ERROR_BODY = "There were errors while attempting to generate the bootstrap file:";
    private static final String FILENAME_REGEX = "[^a-zA-Z0-9_]";
    private static final String FILENAME_REPLACEMENT = "_";
    private static final int FILENAME_MAX_SIZE = 127;
    public static final String EXCESS_UNDERSCORE = "__";
    private SurveyDAO surveyDao = new SurveyDAO();
    private CascadeResourceDao cascadeDao = new CascadeResourceDao();
    private String bucketName = PropertyUtil.getProperty("s3bucket");
    private String keyPrefix = PropertyUtil.getProperty("surveyuploaddir");

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        BootstrapGeneratorRequest restRequest = new BootstrapGeneratorRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        RestResponse response = new RestResponse();
        BootstrapGeneratorRequest bootStrapReq = (BootstrapGeneratorRequest)req;
        if ("generate".equalsIgnoreCase(bootStrapReq.getAction())) {
            this.generateFile(bootStrapReq);
        }
        return response;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
    }

    private void generateFile(BootstrapGeneratorRequest req) {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        HashSet<String> resourcesSet = new HashSet<String>();
        StringBuilder errors = new StringBuilder();
        if (req.getSurveyIds() != null) {
            for (Long id : req.getSurveyIds()) {
                try {
                    Survey s = this.surveyDao.getById(id);
                    String surveyFilename = this.generateSanitizedFilename(s.getName());
                    long formId = s.getKey().getId();
                    URLConnection conn = S3Util.getConnection(this.bucketName, this.keyPrefix + "/" + formId + ".zip");
                    String formName = formId + ".xml";
                    String xmlContents = ZipUtil.unZipFile(formName, new ZipInputStream(new BufferedInputStream(conn.getInputStream())));
                    contentMap.put(formId + "/" + surveyFilename + ".xml", xmlContents);
                    resourcesSet.addAll(this.getSurveyResources(id));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Could not include survey id " + id + "\n", e);
                    errors.append("Could not include survey id " + id + "\n");
                }
            }
        }
        if (req.getDbInstructions() != null && req.getDbInstructions().trim().length() > 0) {
            contentMap.put(DB_INST_ENTRY, req.getDbInstructions().trim());
        }
        String filename = System.currentTimeMillis() + "-bs.zip";
        String objectKey = PropertyUtil.getProperty(BOOTSTRAP_UPLOAD_DIR) + "/" + filename;
        try {
            Map<String, byte[]> resources = this.fetchResources(resourcesSet);
            ByteArrayOutputStream os = ZipUtil.generateZip(contentMap, resources);
            S3Util.put(this.bucketName, objectKey, os.toByteArray(), "application/zip", false);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error uploading bootstrap file: " + e.getMessage(), e);
            return;
        }
        String body = EMAIL_BODY;
        body = errors.toString().trim().length() > 0 ? "There were errors while attempting to generate the bootstrap file:\n\n" + errors.toString() : body + "\n\n" + S3Util.getBrowserLink(this.bucketName, objectKey);
        MailUtil.sendMail(PropertyUtil.getProperty(EMAIL_FROM_ADDRESS_KEY), "Akvo Flow", req.getEmail(), EMAIL_SUB, body);
    }

    private String generateSanitizedFilename(@Nullable String name) {
        String filename;
        if (StringUtils.isEmpty((String)name)) {
            filename = "survey";
        } else {
            filename = name.trim().replaceAll(FILENAME_REGEX, FILENAME_REPLACEMENT);
            int maxLength = Math.min(127, filename.length());
            filename = filename.substring(0, maxLength);
            filename = filename.replaceAll(EXCESS_UNDERSCORE, FILENAME_REPLACEMENT);
        }
        return filename;
    }

    private Set<String> getSurveyResources(Long surveyId) {
        HashSet<String> resources = new HashSet<String>();
        for (Question q : new QuestionDao().listQuestionsInOrder(surveyId, Question.Type.CASCADE)) {
            CascadeResource cr;
            Long cascadeResourceId = q.getCascadeResourceId();
            if (cascadeResourceId == null || (cr = (CascadeResource)this.cascadeDao.getByKey(cascadeResourceId)) == null) continue;
            String resName = cr.getResourceId() + ".zip";
            resources.add(resName);
        }
        return resources;
    }

    private Map<String, byte[]> fetchResources(Set<String> resources) throws IOException {
        HashMap<String, byte[]> resData = new HashMap<String, byte[]>();
        for (String resource : resources) {
            byte[] data = this.fetchResource(resource);
            resData.put(resource, data);
        }
        return resData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fetchResource(String res) throws IOException {
        byte[] byArray;
        URLConnection conn = null;
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            conn = S3Util.getConnection(this.bucketName, this.keyPrefix + "/" + res);
            out = new ByteArrayOutputStream();
            in = conn.getInputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        return byArray;
    }
}

