/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.common.Constants;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.api.app.DataPointRequest;
import org.akvo.flow.api.app.DataPointResponse;
import org.akvo.flow.api.app.DataPointUtil;
import org.akvo.flow.dao.DataPointAssignmentDao;
import org.akvo.flow.domain.persistent.DataPointAssignment;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;

public class DataPointServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(DataPointServlet.class.getName());
    private SurveyedLocaleDao surveyedLocaleDao;
    private DataPointAssignmentDao dataPointAssignmentDao;
    private static final int LIMIT_DATAPOINTS = 30;

    public DataPointServlet() {
        this.setMode("JSON");
        this.surveyedLocaleDao = new SurveyedLocaleDao();
        this.dataPointAssignmentDao = new DataPointAssignmentDao();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DataPointRequest restRequest = new DataPointRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        List<SurveyedLocale> dpList;
        DataPointRequest dpReq = (DataPointRequest)req;
        DataPointResponse res = new DataPointResponse();
        if (dpReq.getSurveyId() == null) {
            res.setCode(String.valueOf(403));
            res.setMessage("Invalid Survey");
            return res;
        }
        DataPointUtil dpu = new DataPointUtil();
        try {
            dpList = dpu.getAssignedDataPoints(dpReq.getAndroidId(), dpReq.getSurveyId(), dpReq.getCursor());
        }
        catch (Exception e) {
            res.setCode(String.valueOf(404));
            res.setMessage(e.getMessage());
            return res;
        }
        res = this.convertToResponse(dpList, dpReq.getSurveyId());
        res.setCursor(BaseDAO.getCursor(dpList));
        return res;
    }

    public List<SurveyedLocale> getDataPointList(DataPointAssignment assignment, Long surveyId, String cursor) {
        if (assignment == null || this.allDataPointsAreAssigned(assignment)) {
            return this.getAllDataPoints(surveyId, cursor);
        }
        return this.getAssignedDataPoints(assignment);
    }

    private boolean allDataPointsAreAssigned(DataPointAssignment assignment) {
        if (assignment == null) {
            return false;
        }
        HashSet<Long> assignedDataPoints = new HashSet<Long>();
        assignedDataPoints.addAll(assignment.getDataPointIds());
        return Constants.ALL_DATAPOINTS.equals(assignedDataPoints);
    }

    private List<SurveyedLocale> getAllDataPoints(Long surveyId, String cursor) {
        return this.surveyedLocaleDao.listLocalesBySurveyGroupAndUpdateDate(surveyId, null, cursor, 30);
    }

    private List<SurveyedLocale> getAssignedDataPoints(DataPointAssignment assignment) {
        HashSet<Long> assignedDataPointIds = new HashSet<Long>();
        assignedDataPointIds.addAll(assignment.getDataPointIds());
        return this.surveyedLocaleDao.listByKeys(new ArrayList<Long>(assignedDataPointIds));
    }

    private DataPointResponse convertToResponse(List<SurveyedLocale> slList, Long surveyId) {
        DataPointResponse resp = new DataPointResponse();
        if (slList == null) {
            resp.setCode(String.valueOf(500));
            resp.setMessage("Internal Server Error");
            return resp;
        }
        resp.setCode(String.valueOf(200));
        resp.setResultCount(slList.size());
        DataPointUtil dpu = new DataPointUtil();
        List<SurveyedLocaleDto> dtoList = dpu.getSurveyedLocaleDtosList(slList, surveyId);
        resp.setDataPointData(dtoList);
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        int sc;
        try {
            sc = Integer.valueOf(resp.getCode());
        }
        catch (NumberFormatException ignored) {
            sc = 500;
        }
        this.getResponse().setStatus(sc);
        if (sc == 200) {
            FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
            ServletOutputStream stream = this.getResponse().getOutputStream();
            writer.writeValue((OutputStream)stream, resp);
            PrintWriter endwriter = new PrintWriter((OutputStream)stream);
            endwriter.println();
        } else {
            this.getResponse().getWriter().println(resp.getMessage());
        }
    }
}

