/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.rest.dto.PlacemarkDto;

@Controller
@RequestMapping(value={"/placemarks"})
public class PlacemarkRestService {
    final int LIMIT_PLACEMARK_POINTS = 2000;
    private static final Logger log = Logger.getLogger(PlacemarkRestService.class.getName());
    private SurveyedLocaleDao localeDao = new SurveyedLocaleDao();
    private static final String DEFAULT_NON_EXISTENT_SURVEY_ID = "-1";

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listPlaceMarks(@RequestParam(value="surveyId", defaultValue="-1") Long surveyId, @RequestParam(value="bbString", defaultValue="") String boundingBoxString, @RequestParam(value="gcLevel", defaultValue="") Integer gcLevel) {
        log.log(Level.FINE, "received request for: " + boundingBoxString + ", " + gcLevel);
        List<String> geocells = Arrays.asList(boundingBoxString.split(","));
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<PlacemarkDto> placemarkList = new ArrayList<PlacemarkDto>();
        ArrayList<SurveyedLocale> dataPointList = new ArrayList<SurveyedLocale>();
        dataPointList.addAll(this.listAllDataPoints(surveyId, geocells));
        placemarkList.addAll(this.marshallDataPointListToDto(dataPointList));
        response.put("placemarks", placemarkList);
        return response;
    }

    private List<SurveyedLocale> listAllDataPoints(Long surveyId, List<String> geocells) {
        return this.localeDao.listLocalesByGeocell(surveyId, geocells, 2000);
    }

    private List<PlacemarkDto> marshallDataPointListToDto(List<SurveyedLocale> dataPointList) {
        if (dataPointList == null) {
            return Collections.emptyList();
        }
        ArrayList<PlacemarkDto> placemarkList = new ArrayList<PlacemarkDto>();
        for (SurveyedLocale dataPoint : dataPointList) {
            placemarkList.add(this.marshallDataPointToDto(dataPoint));
        }
        return placemarkList;
    }

    private PlacemarkDto marshallDataPointToDto(SurveyedLocale dataPoint) {
        PlacemarkDto dataPointDto = this.marshallPublicDataPointToDto(dataPoint);
        dataPointDto.setSurveyId(dataPoint.getSurveyGroupId());
        dataPointDto.setFormId(dataPoint.getCreationSurveyId());
        dataPointDto.setKeyId(dataPoint.getKey().getId());
        return dataPointDto;
    }

    private PlacemarkDto marshallPublicDataPointToDto(SurveyedLocale dataPoint) {
        PlacemarkDto dataPointDto = new PlacemarkDto();
        dataPointDto.setLatitude(dataPoint.getLatitude());
        dataPointDto.setLongitude(dataPoint.getLongitude());
        dataPointDto.setCount(1);
        dataPointDto.setLevel(0);
        dataPointDto.setCollectionDate(dataPoint.getLastSurveyedDate());
        return dataPointDto;
    }
}

