/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.api.app.DataPointRequest;
import org.akvo.flow.api.app.DataPointResponse;
import org.akvo.flow.api.app.DataPointUtil;
import org.akvo.flow.dao.DataPointAssignmentDao;
import org.akvo.flow.dao.SurveyAssignmentDao;
import org.akvo.flow.domain.persistent.DataPointAssignment;
import org.akvo.flow.domain.persistent.SurveyAssignment;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;

public class DataPointServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(DataPointServlet.class.getName());
    private static Set<Long> ALL_DATAPOINTS = new HashSet<Long>(Arrays.asList(0L));
    private SurveyedLocaleDao surveyedLocaleDao;
    private DataPointAssignmentDao dataPointAssignmentDao;

    public DataPointServlet() {
        this.setMode("JSON");
        this.surveyedLocaleDao = new SurveyedLocaleDao();
        this.dataPointAssignmentDao = new DataPointAssignmentDao();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DataPointRequest restRequest = new DataPointRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DataPointRequest dpReq = (DataPointRequest)req;
        RestResponse res = new RestResponse();
        if (dpReq.getSurveyId() != null) {
            DeviceDAO deviceDao = new DeviceDAO();
            Device device = deviceDao.getDevice(dpReq.getAndroidId(), null, null);
            if (device != null) {
                log.info("Found device id: " + device.getKey().getId());
                log.fine("Found device: " + device);
                List<SurveyedLocale> dpList = this.getDataPointList(dpReq.getSurveyId(), device.getKey().getId());
                if (dpList == null) {
                    res.setCode(String.valueOf(404));
                    res.setMessage("No assignment was found");
                    return res;
                }
                res = this.convertToResponse(dpList, dpReq.getSurveyId());
                return res;
            }
            res.setCode(String.valueOf(404));
            res.setMessage("Unknown device");
        } else {
            res.setCode(String.valueOf(403));
            res.setMessage("Invalid Survey");
        }
        return res;
    }

    public List<SurveyedLocale> getDataPointList(Long surveyId, Long deviceId) {
        List<DataPointAssignment> assList = this.dataPointAssignmentDao.listByDeviceAndSurvey(deviceId, surveyId);
        if (assList.isEmpty()) {
            return this.getAllDataPointsForOldApps(deviceId, surveyId);
        }
        return this.getAssignedDataPoints(assList.get(0));
    }

    private List<SurveyedLocale> getAllDataPointsForOldApps(Long deviceId, Long surveyId) {
        SurveyAssignmentDao saDao = new SurveyAssignmentDao();
        List<SurveyAssignment> deviceSurveyAssignments = saDao.listByDeviceAndSurvey(deviceId, surveyId);
        if (deviceSurveyAssignments.isEmpty()) {
            log.log(Level.WARNING, "No assignment found for surveyId: " + surveyId + " - deviceId: " + deviceId);
            return null;
        }
        return this.surveyedLocaleDao.listLocalesBySurveyGroupId(surveyId);
    }

    private List<SurveyedLocale> getAssignedDataPoints(DataPointAssignment assignment) {
        HashSet<Long> assignedDataPointIds = new HashSet<Long>();
        assignedDataPointIds.addAll(assignment.getDataPointIds());
        if (ALL_DATAPOINTS.equals(assignedDataPointIds)) {
            return this.surveyedLocaleDao.listLocalesBySurveyGroupId(assignment.getSurveyId());
        }
        return this.surveyedLocaleDao.listByKeys(new ArrayList<Long>(assignedDataPointIds));
    }

    private DataPointResponse convertToResponse(List<SurveyedLocale> slList, Long surveyId) {
        DataPointResponse resp = new DataPointResponse();
        if (slList == null) {
            resp.setCode(String.valueOf(500));
            resp.setMessage("Internal Server Error");
            return resp;
        }
        resp.setCode(String.valueOf(200));
        resp.setResultCount(slList.size());
        DataPointUtil dpu = new DataPointUtil();
        List<SurveyedLocaleDto> dtoList = dpu.getSurveyedLocaleDtosList(slList, surveyId);
        resp.setDataPointData(dtoList);
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        int sc;
        try {
            sc = Integer.valueOf(resp.getCode());
        }
        catch (NumberFormatException ignored) {
            sc = 500;
        }
        this.getResponse().setStatus(sc);
        if (sc == 200) {
            FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
            ServletOutputStream stream = this.getResponse().getOutputStream();
            writer.writeValue((OutputStream)stream, resp);
            PrintWriter endwriter = new PrintWriter((OutputStream)stream);
            endwriter.println();
        } else {
            this.getResponse().getWriter().println(resp.getMessage());
        }
    }
}

