/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.device.dao.DeviceGroupDAO;
import com.gallatinsystems.device.domain.DeviceGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.device.DeviceGroupDto;
import org.waterforpeople.mapping.app.web.rest.dto.DeviceGroupPayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/device_groups"})
public class DeviceGroupRestService {
    private DeviceGroupDAO deviceGroupDao = new DeviceGroupDAO();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<DeviceGroupDto>> listDeviceGroups() {
        HashMap<String, List<DeviceGroupDto>> response = new HashMap<String, List<DeviceGroupDto>>();
        ArrayList<DeviceGroupDto> results = new ArrayList<DeviceGroupDto>();
        List deviceGroups = this.deviceGroupDao.list("all");
        if (deviceGroups != null) {
            for (DeviceGroup dg : deviceGroups) {
                DeviceGroupDto dto = this.marshallToDto(dg);
                results.add(dto);
            }
        }
        response.put("device_groups", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, DeviceGroupDto> findDeviceGroup(@PathVariable(value="id") Long id) {
        HashMap<String, DeviceGroupDto> response = new HashMap<String, DeviceGroupDto>();
        DeviceGroup dg = (DeviceGroup)this.deviceGroupDao.getByKey(id);
        DeviceGroupDto dto = null;
        if (dg != null) {
            dto = this.marshallToDto(dg);
        }
        response.put("device_group", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteDeviceGroupById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        DeviceGroup dg = (DeviceGroup)this.deviceGroupDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (dg != null) {
            this.deviceGroupDao.delete(dg);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingDeviceGroup(@RequestBody DeviceGroupPayload payLoad) {
        DeviceGroup dg;
        Long keyId;
        DeviceGroupDto deviceGroupDto = payLoad.getDevice_group();
        HashMap<String, Object> response = new HashMap<String, Object>();
        DeviceGroupDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (deviceGroupDto != null && (keyId = deviceGroupDto.getKeyId()) != null && (dg = (DeviceGroup)this.deviceGroupDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)deviceGroupDto, (Object)dg, (String[])new String[]{"createdDateTime"});
            dg = this.deviceGroupDao.save(dg);
            dto = this.marshallToDto(dg);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("device_group", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewDeviceGroup(@RequestBody DeviceGroupPayload payLoad) {
        DeviceGroupDto deviceGroupDto = payLoad.getDevice_group();
        HashMap<String, Object> response = new HashMap<String, Object>();
        DeviceGroupDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (deviceGroupDto != null) {
            DeviceGroup dg = new DeviceGroup();
            BeanUtils.copyProperties((Object)deviceGroupDto, (Object)dg, (String[])new String[]{"createdDateTime"});
            dg = this.deviceGroupDao.save(dg);
            dto = this.marshallToDto(dg);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("device_group", dto);
        return response;
    }

    private DeviceGroupDto marshallToDto(DeviceGroup sa) {
        DeviceGroupDto dto = new DeviceGroupDto();
        BeanUtils.copyProperties((Object)sa, (Object)dto);
        if (sa.getKey() != null) {
            dto.setKeyId(sa.getKey().getId());
        }
        return dto;
    }
}

