/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.api.app.WebFormRequest;

public class WebFormServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(WebFormServlet.class.getName());

    public WebFormServlet() {
        this.setMode("JSON");
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        WebFormRequest restRequest = new WebFormRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        RestResponse res = new RestResponse();
        res.setCode(String.valueOf(200));
        String surveyId = ((WebFormRequest)req).getSurveyId();
        String url = String.format("%s/%s/%s", PropertyUtil.getProperty("webFormRedirectionUrl"), PropertyUtil.getProperty("appId"), surveyId);
        res.setMessage(url);
        return res;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        int sc;
        try {
            sc = Integer.valueOf(resp.getCode());
        }
        catch (NumberFormatException ignored) {
            sc = 500;
        }
        this.getResponse().setStatus(sc);
        if (sc == 200) {
            HttpServletResponse response = this.getResponse();
            response.setContentType("text/html");
            response.setStatus(302);
            response.setHeader("Location", resp.getMessage());
        } else {
            this.getResponse().getWriter().println(resp.getMessage());
        }
    }
}

