/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.domain;

import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.akvo.flow.util.OneTimePadCypher;

public class WebForm {
    public static Set<String> unsupportedQuestionTypes() {
        HashSet<String> unsupportedTypes = new HashSet<String>();
        unsupportedTypes.add(Question.Type.GEOSHAPE.toString());
        unsupportedTypes.add(Question.Type.SIGNATURE.toString());
        unsupportedTypes.add(Question.Type.CADDISFLY.toString());
        return unsupportedTypes;
    }

    public static boolean validQuestionGroups(Survey survey) {
        return survey.getQuestionGroupMap().values().stream().filter(i -> i.getRepeatable()).collect(Collectors.toList()).size() == 0;
    }

    public static boolean validForm(Survey survey, SurveyGroup surveyGroup) {
        return surveyGroup.getMonitoringGroup() == false || surveyGroup.getNewLocaleSurveyId() != null && surveyGroup.getNewLocaleSurveyId().equals(survey.getKey().getId());
    }

    public static boolean validWebForm(SurveyGroup surveyGroup, Survey survey, List<Question> questions) {
        boolean validQuestionGroups = WebForm.validQuestionGroups(survey);
        if (!validQuestionGroups) {
            return false;
        }
        boolean validSurveyGroup = WebForm.validForm(survey, surveyGroup);
        if (!validSurveyGroup) {
            return false;
        }
        List validQuestions = questions.stream().filter(i -> !WebForm.unsupportedQuestionTypes().contains(i.getType().toString())).collect(Collectors.toList());
        return validQuestions.size() == questions.size();
    }

    public static String encryptId(Long surveyId, String seed, String pw) {
        return OneTimePadCypher.encrypt(seed, surveyId.toString() + "$" + pw);
    }

    public static String decryptId(String webFormId, String seed, String pw) {
        String decrypted = OneTimePadCypher.decrypt(seed, webFormId);
        String[] res = decrypted.split("\\$");
        if (res.length == 2 && res[1].equals(pw)) {
            return res[0];
        }
        return null;
    }
}

