/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.notification;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;
import org.waterforpeople.mapping.notification.AbstractReportNotificationHandler;

public class FieldStatusReportNotificationHandler
extends AbstractReportNotificationHandler {
    public static final String TYPE = "fieldStatusReport";
    private static final String EMAIL_TITLE = "FLOW Field Status Report for survey: ";
    private static final String EMAIL_BODY = "Please see the latest field status report here (Recommend you open in Microsoft Excel) for Survey : ";
    private static final int PAGE_SIZE = 100;
    private static final String REPORT_DATE_FORMAT = "MM-dd-yyyy";
    private SurveyInstanceDAO instanceDao;
    private DateFormat df = new SimpleDateFormat("MMddyyyy");
    private DateFormat reportDateFormat = new SimpleDateFormat("MM-dd-yyyy");

    public FieldStatusReportNotificationHandler() {
        this.instanceDao = new SurveyInstanceDAO();
    }

    @Override
    protected void writeReport(Long entityId, String serverBase, PrintWriter pw) {
        if (entityId != null) {
            String cursor = null;
            pw.print("Date\tCountry\tCommunity\n");
            do {
                List<SurveyInstance> tempList;
                if ((tempList = this.instanceDao.listSurveyInstanceBySurvey(entityId, 100, cursor)) == null) {
                    cursor = null;
                    continue;
                }
                for (SurveyInstance inst : tempList) {
                    pw.print(this.reportDateFormat.format(inst.getCollectionDate()) + "\t" + (inst.getCountryCode() != null ? inst.getCountryCode() : "") + "\t" + (inst.getCommunity() != null ? inst.getCommunity() : "") + "\n");
                }
                cursor = tempList.size() < 100 ? null : SurveyInstanceDAO.getCursor(tempList);
            } while (cursor != null);
            pw.flush();
        }
    }

    @Override
    protected String getEmailBody() {
        return EMAIL_BODY;
    }

    @Override
    protected String getEmailSubject() {
        return EMAIL_TITLE;
    }

    @Override
    protected String getFileName(String entityId) {
        return "fieldStatusReport-" + entityId + "-" + this.df.format(new Date()) + ".txt";
    }
}

