/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.security.google;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserServiceFactory;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.rest.security.user.GaeUser;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class GoogleAuthenticationFilter
extends GenericFilterBean {
    private static final Logger logger = Logger.getLogger(GoogleAuthenticationFilter.class.getName());
    private final AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> ads = new WebAuthenticationDetailsSource();
    private AuthenticationManager authenticationManager;
    private AuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        User googleUser;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (GoogleAuthenticationFilter.shouldClearSession(authentication, googleUser = UserServiceFactory.getUserService().getCurrentUser())) {
            SecurityContextHolder.clearContext();
            authentication = null;
            ((HttpServletRequest)request).getSession().invalidate();
        }
        if (authentication == null && googleUser != null) {
            logger.log(Level.INFO, "Currently logged on to GAE as user " + googleUser);
            logger.log(Level.INFO, "Authenticating to Spring Security");
            PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)googleUser, null);
            token.setDetails(this.ads.buildDetails((Object)((HttpServletRequest)request)));
            try {
                authentication = this.authenticationManager.authenticate((Authentication)token);
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
            catch (AuthenticationException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.failureHandler.onAuthenticationFailure((HttpServletRequest)request, (HttpServletResponse)response, e);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public static boolean shouldClearSession(Authentication authentication, User googleUser) {
        if (authentication == null) {
            return false;
        }
        GaeUser gaeUser = (GaeUser)authentication.getPrincipal();
        if (!gaeUser.isAuthByGAE()) {
            return false;
        }
        if (googleUser == null) {
            return true;
        }
        return !gaeUser.getEmail().equals(googleUser.getEmail());
    }

    public void afterPropertiesSet() throws ServletException {
        Assert.notNull((Object)this.authenticationManager, (String)"AuthenticationManager must be set");
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setFailureHandler(AuthenticationFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
    }
}

