/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import java.util.ArrayList;
import java.util.TreeMap;
import org.akvo.flow.xml.XmlQuestion;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class XmlQuestionGroup {
    @JacksonXmlProperty(localName="repeatable", isAttribute=true)
    private Boolean repeatable;
    @JacksonXmlProperty(localName="heading", isAttribute=false)
    private String heading;
    @JacksonXmlElementWrapper(localName="question", useWrapping=false)
    private ArrayList<XmlQuestion> question;
    @JsonIgnore
    private int order;

    public XmlQuestionGroup() {
    }

    public XmlQuestionGroup(QuestionGroup group) {
        this.heading = group.getCode();
        if (this.heading == null) {
            this.heading = group.getName();
        }
        this.order = group.getOrder();
        this.repeatable = group.getRepeatable();
        if (group.getQuestionMap() != null) {
            this.question = new ArrayList();
            for (Question q : group.getQuestionMap().values()) {
                this.question.add(new XmlQuestion(q));
            }
        }
    }

    public QuestionGroupDto toDto() {
        QuestionGroupDto dto = new QuestionGroupDto();
        dto.setName(this.heading);
        dto.setCode(this.heading);
        dto.setOrder(this.order);
        dto.setRepeatable(this.repeatable);
        if (this.question != null) {
            TreeMap<Integer, QuestionDto> qMap = new TreeMap<Integer, QuestionDto>();
            for (XmlQuestion q : this.question) {
                qMap.put(q.getOrder(), q.toDto());
            }
            dto.setQuestionMap(qMap);
        }
        return dto;
    }

    public String toString() {
        return "questionGroup{order='" + this.order + "',heading='" + this.heading + "',repeatable='" + this.repeatable + "}";
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String h) {
        this.heading = h;
    }

    public Boolean getRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(Boolean repeatable) {
        this.repeatable = repeatable;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public ArrayList<XmlQuestion> getQuestion() {
        return this.question;
    }

    public void setQuestion(ArrayList<XmlQuestion> qs) {
        this.question = qs;
    }
}

