/*
 * Decompiled with CFR 0.152.
 */
package com.gotometrics.orderly.example;

import com.gotometrics.orderly.Order;
import com.gotometrics.orderly.StringRowKey;
import com.gotometrics.orderly.Termination;
import com.gotometrics.orderly.TextRowKey;
import com.gotometrics.orderly.UTF8RowKey;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

public class StringExample {
    public void lengthExamples() throws Exception {
        TextRowKey i = new TextRowKey();
        System.out.println("serialize(hello) length - " + i.serialize((Object)new Text("hello")).length);
        System.out.println("serialize(null) length - " + i.serialize(null).length);
        System.out.println("serialize('') length - " + i.serialize((Object)new Text("")).length);
        System.out.println("serialize(foobar) length - " + i.serialize((Object)new Text("foobar")).length);
        i.setOrder(Order.DESCENDING);
        System.out.println("descending serialize (null) - length " + i.serialize(null).length);
        System.out.println("descending serialize (hello) - length " + i.serialize((Object)new Text("hello")).length);
        System.out.println("descending serialize ('') - length " + i.serialize((Object)new Text("")).length);
    }

    public void serializationExamples() throws Exception {
        StringRowKey l = new StringRowKey();
        ImmutableBytesWritable buffer = new ImmutableBytesWritable();
        byte[] b = new byte[l.getSerializedLength((Object)"hello")];
        buffer.set(b);
        l.serialize((Object)"hello", buffer);
        buffer.set(b);
        System.out.println("deserialize(serialize(hello)) = " + l.deserialize(buffer));
        l.setOrder(Order.DESCENDING);
        System.out.println("deserialize(serialize('')) = " + l.deserialize(l.serialize((Object)"")));
        System.out.println("deserialize(serialize(NULL)) = " + l.deserialize(l.serialize(null)));
    }

    public void mustTerminateExamples() throws Exception {
        UTF8RowKey u = new UTF8RowKey();
        System.out.println("length(serialize(foobar)) = " + u.serialize((Object)Bytes.toBytes((String)"foobar")).length);
        System.out.println("deserialize(serialize(foobar)) = " + Bytes.toString((byte[])((byte[])u.deserialize(u.serialize((Object)Bytes.toBytes((String)"foobar"))))));
        System.out.println("length(serialize(null)) = " + u.serialize(null).length);
        System.out.println("deserialize(serialize(null)) = " + u.deserialize(u.serialize(null)));
        u.setTermination(Termination.MUST);
        System.out.println("mustTerminate length(serialize(foobar)) = " + u.serialize((Object)Bytes.toBytes((String)"foobar")).length);
        System.out.println("mustTerminate - deserialize(serialize(foobar)) = " + Bytes.toString((byte[])((byte[])u.deserialize(u.serialize((Object)Bytes.toBytes((String)"foobar"))))));
        System.out.println("mustTerminate length(serialize(null)) = " + u.serialize(null).length);
        System.out.println("mustTerminate deserialize(serialize(null)) = " + u.deserialize(u.serialize(null)));
    }

    public static void main(String[] args) throws Exception {
        StringExample e = new StringExample();
        e.lengthExamples();
        e.serializationExamples();
        e.mustTerminateExamples();
    }
}

