/*
 * Decompiled with CFR 0.152.
 */
package com.gotometrics.orderly.example;

import com.gotometrics.orderly.IntWritableRowKey;
import com.gotometrics.orderly.IntegerRowKey;
import com.gotometrics.orderly.Order;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.IntWritable;

public class IntExample {
    public void lengthExamples() throws Exception {
        IntegerRowKey i = new IntegerRowKey();
        System.out.println("serialize(null) length - " + i.serialize(null).length);
        System.out.println("serialize(57) length - " + i.serialize((Object)57).length);
        System.out.println("serialize(293) length - " + i.serialize((Object)293).length);
        i.setOrder(Order.DESCENDING);
        System.out.println("descending serialize (null) - length " + i.serialize(null).length);
        System.out.println("descending serialize (57) - length " + i.serialize((Object)57).length);
    }

    public void serializationExamples() throws Exception {
        IntWritableRowKey i = new IntWritableRowKey();
        IntWritable w = new IntWritable();
        ImmutableBytesWritable buffer = new ImmutableBytesWritable();
        w.set(-93214);
        byte[] b = new byte[i.getSerializedLength((Object)w)];
        buffer.set(b);
        i.serialize((Object)w, buffer);
        buffer.set(b, 0, b.length);
        System.out.println("deserialize(serialize(-93214)) = " + ((IntWritable)i.deserialize(buffer)).get());
        i.setReservedBits(2).setReservedValue(3).setOrder(Order.DESCENDING);
        w.set(0);
        System.out.println("deserialize(serialize(0)) = " + ((IntWritable)i.deserialize(i.serialize((Object)w))).get());
        System.out.println("deserialize(serialize(NULL)) = " + i.deserialize(i.serialize(null)));
    }

    public static void main(String[] args) throws Exception {
        IntExample e = new IntExample();
        e.lengthExamples();
        e.serializationExamples();
    }
}

