/*
 * Decompiled with CFR 0.152.
 */
package com.gotometrics.orderly.example;

import com.gotometrics.orderly.DoubleRowKey;
import com.gotometrics.orderly.DoubleWritableRowKey;
import com.gotometrics.orderly.Order;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.DoubleWritable;

public class DoubleExample {
    public void lengthExamples() throws Exception {
        DoubleRowKey d = new DoubleRowKey();
        System.out.println("serialize(null) length - " + d.serialize(null).length);
        System.out.println("serialize(57.190235) length - " + d.serialize((Object)57.923924).length);
        System.out.println("serialize(1000000.999) length - " + d.serialize((Object)1000000.99).length);
        d.setOrder(Order.DESCENDING);
        System.out.println("descending serialize (null) - length " + d.serialize(null).length);
        System.out.println("descending serialize (57) - length " + d.serialize((Object)57.0).length);
    }

    public void serializationExamples() throws Exception {
        DoubleWritableRowKey d = new DoubleWritableRowKey();
        DoubleWritable w = new DoubleWritable();
        ImmutableBytesWritable buffer = new ImmutableBytesWritable();
        w.set(-93214.920352);
        byte[] b = new byte[d.getSerializedLength((Object)w)];
        buffer.set(b);
        d.serialize((Object)w, buffer);
        buffer.set(b, 0, b.length);
        System.out.println("deserialize(serialize(-93214.920352)) = " + ((DoubleWritable)d.deserialize(buffer)).get());
        d.setOrder(Order.DESCENDING);
        w.set(0.0);
        System.out.println("deserialize(serialize(0)) = " + ((DoubleWritable)d.deserialize(d.serialize((Object)w))).get());
        System.out.println("deserialize(serialize(NULL)) = " + d.deserialize(d.serialize(null)));
    }

    public static void main(String[] args) throws Exception {
        DoubleExample e = new DoubleExample();
        e.lengthExamples();
        e.serializationExamples();
    }
}

