(ns sumologic-timbre-appender.examples
  (:require [clj-http.client :as client]
            [slingshot.slingshot :refer [try+ throw+]]
            [sumologic-timbre-appender.core :refer :all]
            [taoensso.timbre :as log]))

(defn http-async-appender [url timeout]
  (fn [body]
    (client/post url {:body body
                      :socket-timeout timeout
                      :conn-timeout timeout})))

(comment
  (let [appender
        (sumologic-appender (http-async-appender (System/getenv "URL") 100) {:max-retries 1})]
    (log/merge-config! {:appenders {:sumo appender}})
    (log/info "Hello working log"))

  (let [appender
        (sumologic-appender (http-async-appender "http://localhost:3000/bad" 1000) {:max-retries 1})]
    (log/merge-config! {:appenders {:sumo appender}})
    (log/info "Hello friends"))

  (let [appender
        (sumologic-appender (http-async-appender "http://localhost:3001/bad" 10000) {:max-retries 1})]
    (log/merge-config! {:appenders {:sumo appender}})
    (log/info "Hello friends"))

  )