(ns sentry-fingerprinter.exception-fingerprint
  (:require [clojure.string :as str]
            [digest :as d]))

(defn- strip-fn-numeric [{:keys [className methodName fileName]}]
  (str/replace (str/join " " [className methodName fileName]) #"\d*" ""))

(defn- sterilize-row [r]
  (-> r
      bean
      (select-keys [:className :methodName :fileName])
      strip-fn-numeric))

(defn hash-exception [e]
  (let [{:keys [via trace]} (Throwable->map e)
        vias (map #(select-keys % [:type :at]) via)
        via-types (map :type vias)
        ats (map :at vias)
        sterile-trace (->> (concat ats trace)
                           (map sterilize-row)
                           (concat via-types)
                           (str/join "\n"))]
    (d/md5 sterile-trace)))
