(ns ring-stream-to-string.core)

(defn wrap-convert-body-stream-to-string
  "Simple middleware to convert a response body input stream
   to a string.  Lambda expects a fully-realized response
   body and clojure.data.json cannot magically slurp out
   stream content as part of JSON serialization, so this
   middleware does the slurping."
  [handler]
  (fn [request]
    (let [{:keys [body] :as result} (handler request)]
      (if (and body (not (string? body)))
        (update result :body slurp)
        result))))