(defproject opploans/request-id "0.1.0"
  :description "Generates a unique request ID and stamps it on log messages in timbre."
  :url "https://github.com/opploans/request-id"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[com.taoensso/timbre "4.10.0"]
                 [opploans/opplogs "0.2.4"]
                 [org.clojure/data.codec "0.1.1"]]
  :plugins [[lein-ancient "0.6.15"]
            [lein-bikeshed "0.5.2"]
            [lein-changelog "0.3.2"]
            [lein-kibit "0.1.7"]
            [lein-shell "0.5.0"]]
  :profiles {:dev {:dependencies [[org.clojure/clojure "1.10.1"]
                                  [pjstadig/humane-test-output "0.10.0"]
                                  [ring/ring-core "1.7.1"]
                                  [ring/ring-mock "0.4.0"]]
                   :injections [(require 'pjstadig.humane-test-output)
                                (pjstadig.humane-test-output/activate!)]}}
  :release-tasks [["bikeshed" "-r"]
                  ["kibit"]
                  ["ancient"]
                  ["test"]
                  ["shell" "git" "diff" "--exit-code"]
                  ;["change" "version" "leiningen.release/bump-version"]
                  ;["change" "version" "leiningen.release/bump-version" "release"]
                  ["changelog" "release"]
                  ["deploy" "clojars"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["vcs" "push"]])
