(defproject opploans/request-id "0.0.0"
  :description "Generates a unique request ID and stamps it on log messages in timbre."
  :url "https://github.com/opploans/request-id"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[opploans/timbre "4.10.2"]
                 [org.clojure/data.codec "0.1.1"]]
  :plugins [[lein-ancient "0.6.15"]
            [lein-bikeshed "0.5.2"]
            [lein-changelog "0.3.2"]
            [lein-cloverage "1.1.1"]
            [lein-kibit "0.1.7"]
            [lein-shell "0.5.0"]]
  :profiles {:dev {:dependencies [[org.clojure/clojure "1.10.1"]
                                  [pjstadig/humane-test-output "0.9.0"]
                                  [ring/ring-core "1.7.1"]
                                  [ring/ring-mock "0.4.0"]]
                   :injections [(require 'pjstadig.humane-test-output)
                                (pjstadig.humane-test-output/activate!)]}}
  :deploy-repositories [["releases" :clojars]]
  :aliases {"update-readme-version" ["shell" "sed" "-i" "s/\\\\[opploans\\\\/request-id \"[0-9.]*\"\\\\]/[opploans\\\\/request-id \"${:version}\"]/" "README.md"]}
  :release-tasks [["bikeshed" "-r"]
                  ["kibit"]
                  ["ancient"]
                  ["shell" "git" "diff" "--exit-code"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["changelog" "release"]
                  ["update-readme-version"]
                  ["vcs" "commit"]
                  ["vcs" "tag"]
                  ["deploy"]
                  ["vcs" "push"]])
