/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.Version;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.DictionarySerializer;
import opennlp.tools.util.model.GenericModelSerializer;
import opennlp.tools.util.model.PropertiesSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseModel {
    protected static final String MANIFEST_ENTRY = "manifest.properties";
    private static final String MANIFEST_VERSION_PROPERTY = "Manifest-Version";
    private static final String COMPONENT_NAME_PROPERTY = "Component-Name";
    private static final String VERSION_PROPERTY = "OpenNLP-Version";
    private static final String TIMESTAMP_PROPERTY = "Timestamp";
    private static final String LANGUAGE_PROPERTY = "Language";
    public static final String TRAINING_CUTOFF_PROPERTY = "Training-Cutoff";
    public static final String TRAINING_ITERATIONS_PROPERTY = "Training-Iterations";
    public static final String TRAINING_EVENTHASH_PROPERTY = "Training-Eventhash";
    private Map<String, ArtifactSerializer> artifactSerializers = new HashMap<String, ArtifactSerializer>();
    protected final Map<String, Object> artifactMap;
    private final String componentName;

    protected BaseModel(String componentName, String languageCode, Map<String, String> manifestInfoEntries) {
        if (componentName == null) {
            throw new IllegalArgumentException("componentName must not be null!");
        }
        if (languageCode == null) {
            throw new IllegalArgumentException("languageCode must not be null!");
        }
        this.componentName = componentName;
        this.artifactMap = new HashMap<String, Object>();
        this.createArtifactSerializers(this.artifactSerializers);
        Properties manifest = new Properties();
        manifest.setProperty(MANIFEST_VERSION_PROPERTY, "1.0");
        manifest.setProperty(LANGUAGE_PROPERTY, languageCode);
        manifest.setProperty(VERSION_PROPERTY, Version.currentVersion().toString());
        manifest.setProperty(TIMESTAMP_PROPERTY, Long.toString(System.currentTimeMillis()));
        manifest.setProperty(COMPONENT_NAME_PROPERTY, componentName);
        if (manifestInfoEntries != null) {
            for (Map.Entry<String, String> entry : manifestInfoEntries.entrySet()) {
                manifest.setProperty(entry.getKey(), entry.getValue());
            }
        }
        this.artifactMap.put(MANIFEST_ENTRY, manifest);
    }

    protected BaseModel(String componentName, InputStream in) throws IOException, InvalidFormatException {
        ZipEntry entry;
        if (componentName == null) {
            throw new IllegalArgumentException("componentName must not be null!");
        }
        if (in == null) {
            throw new IllegalArgumentException("in must not be null!");
        }
        this.componentName = componentName;
        HashMap artifactMap = new HashMap();
        this.createArtifactSerializers(this.artifactSerializers);
        ZipInputStream zip = new ZipInputStream(in);
        while ((entry = zip.getNextEntry()) != null) {
            String extension = this.getEntryExtension(entry.getName());
            ArtifactSerializer factory = this.artifactSerializers.get(extension);
            if (factory == null) {
                throw new InvalidFormatException("Unkown artifact format: " + extension);
            }
            artifactMap.put(entry.getName(), factory.create(zip));
            zip.closeEntry();
        }
        this.artifactMap = Collections.unmodifiableMap(artifactMap);
        this.validateArtifactMap();
    }

    private String getEntryExtension(String entry) throws InvalidFormatException {
        int extensionIndex = entry.lastIndexOf(46) + 1;
        if (extensionIndex == -1 || extensionIndex >= entry.length()) {
            throw new InvalidFormatException("Entry name must have type extension: " + entry);
        }
        return entry.substring(extensionIndex);
    }

    protected ArtifactSerializer getArtifactSerializer(String resoruceName) {
        String extension = null;
        try {
            extension = this.getEntryExtension(resoruceName);
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e);
        }
        return this.artifactSerializers.get(extension);
    }

    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        GenericModelSerializer.register(serializers);
        PropertiesSerializer.register(serializers);
        DictionarySerializer.register(serializers);
    }

    protected void validateArtifactMap() throws InvalidFormatException {
        if (!(this.artifactMap.get(MANIFEST_ENTRY) instanceof Properties)) {
            throw new InvalidFormatException("Missing the manifest.properties!");
        }
        String versionString = this.getManifestProperty(VERSION_PROPERTY);
        if (versionString != null) {
            Version version;
            try {
                version = Version.parse(versionString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("Unable to parse model version!, e");
            }
            if (Version.currentVersion().getMajor() != version.getMajor() || Version.currentVersion().getMinor() != version.getMinor()) {
                throw new InvalidFormatException("Model version " + version + " is not supported by this (" + Version.currentVersion() + ") version of OpenNLP!");
            }
        } else {
            throw new InvalidFormatException("Missing OpenNLP-Version property in manifest.properties!");
        }
        if (this.getManifestProperty(COMPONENT_NAME_PROPERTY) == null) {
            throw new InvalidFormatException("Missing Component-Name property in manifest.properties!");
        }
        if (!this.getManifestProperty(COMPONENT_NAME_PROPERTY).equals(this.componentName)) {
            throw new InvalidFormatException("The " + this.componentName + " cannot load a model for the " + this.getManifestProperty(COMPONENT_NAME_PROPERTY) + "!");
        }
        if (this.getManifestProperty(LANGUAGE_PROPERTY) == null) {
            throw new InvalidFormatException("Missing Language property in manifest.properties!");
        }
    }

    public final String getManifestProperty(String key) {
        Properties manifest = (Properties)this.artifactMap.get(MANIFEST_ENTRY);
        return manifest.getProperty(key);
    }

    protected final void setManifestProperty(String key, String value) {
        Properties manifest = (Properties)this.artifactMap.get(MANIFEST_ENTRY);
        manifest.setProperty(key, value);
    }

    public final String getLanguage() {
        return this.getManifestProperty(LANGUAGE_PROPERTY);
    }

    public final Version getVersion() {
        String version = this.getManifestProperty(VERSION_PROPERTY);
        return Version.parse(version);
    }

    public final void serialize(OutputStream out) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(out);
        for (String name : this.artifactMap.keySet()) {
            zip.putNextEntry(new ZipEntry(name));
            ArtifactSerializer serializer = this.getArtifactSerializer(name);
            if (serializer == null) {
                throw new IllegalStateException("Missing serializer for " + name);
            }
            serializer.serialize(this.artifactMap.get(name), zip);
            zip.closeEntry();
        }
        zip.finish();
        zip.flush();
    }
}

