/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.model.AbstractModel;
import opennlp.model.MaxentModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenizerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "TokenizerME";
    private static final String TOKENIZER_MODEL_ENTRY = "token.model";
    private static final String USE_ALPHA_NUMERIC_OPTIMIZATION = "useAlphaNumericOptimization";

    public TokenizerModel(String language, AbstractModel tokenizerMaxentModel, boolean useAlphaNumericOptimization, Map<String, String> manifestInfoEntries) {
        super(COMPONENT_NAME, language, manifestInfoEntries);
        if (tokenizerMaxentModel == null) {
            throw new IllegalArgumentException("tokenizerMaxentModel param must not bet null!");
        }
        if (!TokenizerModel.isModelCompatible((MaxentModel)tokenizerMaxentModel)) {
            throw new IllegalArgumentException("The maxent model is not compatible!");
        }
        this.artifactMap.put(TOKENIZER_MODEL_ENTRY, tokenizerMaxentModel);
        this.setManifestProperty(USE_ALPHA_NUMERIC_OPTIMIZATION, Boolean.toString(useAlphaNumericOptimization));
    }

    public TokenizerModel(String language, AbstractModel tokenizerMaxentModel, boolean useAlphaNumericOptimization) {
        this(language, tokenizerMaxentModel, useAlphaNumericOptimization, null);
    }

    public TokenizerModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    private static boolean isModelCompatible(MaxentModel model) {
        return ModelUtil.validateOutcomes(model, "T", "F");
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(TOKENIZER_MODEL_ENTRY) instanceof AbstractModel)) {
            throw new InvalidFormatException("Token model is incomplete!");
        }
        if (!TokenizerModel.isModelCompatible((MaxentModel)this.getMaxentModel())) {
            throw new InvalidFormatException("The maxent model is not compatible with the tokenizer!");
        }
        if (this.getManifestProperty(USE_ALPHA_NUMERIC_OPTIMIZATION) == null) {
            throw new InvalidFormatException("The useAlphaNumericOptimization parameter cannot be found!");
        }
    }

    public AbstractModel getMaxentModel() {
        return (AbstractModel)this.artifactMap.get(TOKENIZER_MODEL_ENTRY);
    }

    public boolean useAlphaNumericOptimization() {
        String optimization = this.getManifestProperty(USE_ALPHA_NUMERIC_OPTIMIZATION);
        return Boolean.parseBoolean(optimization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("TokenizerModel [-alphaNumericOptimization] languageCode packageName modelName");
            System.exit(1);
        }
        int ai = 0;
        boolean alphaNumericOptimization = false;
        if ("-alphaNumericOptimization".equals(args[ai])) {
            alphaNumericOptimization = true;
        }
        int n = ++ai;
        String languageCode = args[n];
        int n2 = ++ai;
        String packageName = args[n2];
        String modelName = args[++ai];
        AbstractModel model = new BinaryGISModelReader(new DataInputStream(new FileInputStream(modelName))).getModel();
        TokenizerModel packageModel = new TokenizerModel(languageCode, model, alphaNumericOptimization);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(packageName);
            packageModel.serialize(out);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }
}

