/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.treeinsert;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import opennlp.maxent.GIS;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.DataIndexer;
import opennlp.model.EventStream;
import opennlp.model.MaxentModel;
import opennlp.model.TwoPassDataIndexer;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.ChunkContextGenerator;
import opennlp.tools.parser.ChunkSampleStream;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParseSampleStream;
import opennlp.tools.parser.ParserChunkerSequenceValidator;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.PosSampleStream;
import opennlp.tools.parser.treeinsert.AttachContextGenerator;
import opennlp.tools.parser.treeinsert.BuildContextGenerator;
import opennlp.tools.parser.treeinsert.CheckContextGenerator;
import opennlp.tools.parser.treeinsert.ParserEventStream;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.model.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
extends AbstractBottomUpParser {
    public static final String DONE = "d";
    public static final String ATTACH_SISTER = "s";
    public static final String ATTACH_DAUGHTER = "d";
    public static final String NON_ATTACH = "n";
    public static final String BUILT = "built";
    private MaxentModel buildModel;
    private MaxentModel attachModel;
    private MaxentModel checkModel;
    static boolean checkComplete = false;
    private BuildContextGenerator buildContextGenerator;
    private AttachContextGenerator attachContextGenerator;
    private CheckContextGenerator checkContextGenerator;
    private double[] bprobs;
    private double[] aprobs;
    private double[] cprobs;
    private int doneIndex;
    private int sisterAttachIndex;
    private int daughterAttachIndex;
    private int nonAttachIndex;
    private int completeIndex;
    private int[] attachments;

    public Parser(ParserModel model, int beamSize, double advancePercentage) {
        this(model.getBuildModel(), model.getAttachModel(), model.getCheckModel(), new POSTaggerME(model.getParserTaggerModel()), new ChunkerME(model.getParserChunkerModel(), 10, new ParserChunkerSequenceValidator(model.getParserChunkerModel()), new ChunkContextGenerator(10)), model.getHeadRules(), beamSize, advancePercentage);
    }

    public Parser(ParserModel model) {
        this(model, 20, 0.95);
    }

    @Deprecated
    public Parser(AbstractModel buildModel, AbstractModel attachModel, AbstractModel checkModel, POSTagger tagger, Chunker chunker, HeadRules headRules, int beamSize, double advancePercentage) {
        super(tagger, chunker, headRules, beamSize, advancePercentage);
        this.buildModel = buildModel;
        this.attachModel = attachModel;
        this.checkModel = checkModel;
        this.buildContextGenerator = new BuildContextGenerator();
        this.attachContextGenerator = new AttachContextGenerator(this.punctSet);
        this.checkContextGenerator = new CheckContextGenerator(this.punctSet);
        this.bprobs = new double[buildModel.getNumOutcomes()];
        this.aprobs = new double[attachModel.getNumOutcomes()];
        this.cprobs = new double[checkModel.getNumOutcomes()];
        this.doneIndex = buildModel.getIndex("d");
        this.sisterAttachIndex = attachModel.getIndex(ATTACH_SISTER);
        this.daughterAttachIndex = attachModel.getIndex("d");
        this.nonAttachIndex = attachModel.getIndex(NON_ATTACH);
        this.attachments = new int[]{this.daughterAttachIndex, this.sisterAttachIndex};
        this.completeIndex = checkModel.getIndex("c");
    }

    @Deprecated
    public Parser(AbstractModel buildModel, AbstractModel attachModel, AbstractModel checkModel, POSTagger tagger, Chunker chunker, HeadRules headRules) {
        this(buildModel, attachModel, checkModel, tagger, chunker, headRules, 20, 0.95);
    }

    public static List<Parse> getRightFrontier(Parse root, Set<String> punctSet) {
        LinkedList<Parse> rf = new LinkedList<Parse>();
        Parse top = root.getType() == "TOP" || root.getType() == "INC" ? Parser.collapsePunctuation(root.getChildren(), punctSet)[0] : root;
        while (!top.isPosTag()) {
            rf.add(0, top);
            Parse[] kids = top.getChildren();
            top = kids[kids.length - 1];
        }
        return new ArrayList<Parse>(rf);
    }

    private void setBuilt(Parse p) {
        String l = p.getLabel();
        if (l == null) {
            p.setLabel(BUILT);
        } else if (this.isComplete(p)) {
            p.setLabel("built.c");
        } else {
            p.setLabel("built.i");
        }
    }

    private void setComplete(Parse p) {
        String l = p.getLabel();
        if (!this.isBuilt(p)) {
            p.setLabel("c");
        } else {
            p.setLabel("built.c");
        }
    }

    private void setIncomplete(Parse p) {
        if (!this.isBuilt(p)) {
            p.setLabel("i");
        } else {
            p.setLabel("built.i");
        }
    }

    private boolean isBuilt(Parse p) {
        String l = p.getLabel();
        if (l == null) {
            return false;
        }
        return l.startsWith(BUILT);
    }

    private boolean isComplete(Parse p) {
        String l = p.getLabel();
        if (l == null) {
            return false;
        }
        return l.endsWith("c");
    }

    @Override
    protected Parse[] advanceChunks(Parse p, double minChunkScore) {
        Parse[] parses = super.advanceChunks(p, minChunkScore);
        for (int pi = 0; pi < parses.length; ++pi) {
            Parse[] chunks = parses[pi].getChildren();
            for (int ci = 0; ci < chunks.length; ++ci) {
                this.setComplete(chunks[ci]);
            }
        }
        return parses;
    }

    @Override
    protected Parse[] advanceParses(Parse p, double probMass) {
        Parse newParse2;
        int advanceNodeIndex;
        double q = 1.0 - probMass;
        Parse advanceNode = null;
        Parse[] originalChildren = p.getChildren();
        Parse[] children = Parser.collapsePunctuation(originalChildren, this.punctSet);
        int numNodes = children.length;
        if (numNodes == 0) {
            return null;
        }
        if (numNodes == 1) {
            if (children[0].isPosTag()) {
                return null;
            }
            p.expandTopNode(children[0]);
            return new Parse[]{p};
        }
        for (advanceNodeIndex = 0; advanceNodeIndex < numNodes && this.isBuilt(advanceNode = children[advanceNodeIndex]); ++advanceNodeIndex) {
        }
        int originalZeroIndex = this.mapParseIndex(0, children, originalChildren);
        int originalAdvanceIndex = this.mapParseIndex(advanceNodeIndex, children, originalChildren);
        ArrayList<Parse> newParsesList = new ArrayList<Parse>();
        this.buildModel.eval(this.buildContextGenerator.getContext(children, advanceNodeIndex), this.bprobs);
        double doneProb = this.bprobs[this.doneIndex];
        if (this.debugOn) {
            System.out.println("adi=" + advanceNodeIndex + " " + advanceNode.getType() + "." + advanceNode.getLabel() + " " + advanceNode + " choose build=" + (1.0 - doneProb) + " attach=" + doneProb);
        }
        if (1.0 - doneProb > q) {
            double bprobSum = 0.0;
            while (bprobSum < probMass) {
                int max = 0;
                for (int pi = 1; pi < this.bprobs.length; ++pi) {
                    if (!(this.bprobs[pi] > this.bprobs[max])) continue;
                    max = pi;
                }
                if (this.bprobs[max] == 0.0) break;
                double bprob = this.bprobs[max];
                this.bprobs[max] = 0.0;
                bprobSum += bprob;
                String tag = this.buildModel.getOutcome(max);
                if (tag.equals("d")) continue;
                Parse newParse1 = (Parse)p.clone();
                Parse newNode = new Parse(p.getText(), advanceNode.getSpan(), tag, bprob, advanceNode.getHead());
                newParse1.insert(newNode);
                newParse1.addProb(Math.log(bprob));
                newParsesList.add(newParse1);
                if (checkComplete) {
                    this.cprobs = this.checkModel.eval(this.checkContextGenerator.getContext(newNode, children, advanceNodeIndex, false));
                    if (this.debugOn) {
                        System.out.println("building " + tag + " " + bprob + " c=" + this.cprobs[this.completeIndex]);
                    }
                    if (this.cprobs[this.completeIndex] > probMass) {
                        this.setComplete(newNode);
                        newParse1.addProb(Math.log(this.cprobs[this.completeIndex]));
                        if (!this.debugOn) continue;
                        System.out.println("Only advancing complete node");
                        continue;
                    }
                    if (1.0 - this.cprobs[this.completeIndex] > probMass) {
                        this.setIncomplete(newNode);
                        newParse1.addProb(Math.log(1.0 - this.cprobs[this.completeIndex]));
                        if (!this.debugOn) continue;
                        System.out.println("Only advancing incomplete node");
                        continue;
                    }
                    if (this.debugOn) {
                        System.out.println("Advancing both complete and incomplete nodes");
                    }
                    this.setComplete(newNode);
                    newParse1.addProb(Math.log(this.cprobs[this.completeIndex]));
                    newParse2 = (Parse)p.clone();
                    Parse newNode2 = new Parse(p.getText(), advanceNode.getSpan(), tag, bprob, advanceNode.getHead());
                    newParse2.insert(newNode2);
                    newParse2.addProb(Math.log(bprob));
                    newParsesList.add(newParse2);
                    newParse2.addProb(Math.log(1.0 - this.cprobs[this.completeIndex]));
                    this.setIncomplete(newNode2);
                    continue;
                }
                if (!this.debugOn) continue;
                System.out.println("building " + tag + " " + bprob);
            }
        }
        if (doneProb > q) {
            Parse newParse1 = (Parse)p.clone();
            if (checkComplete) {
                if (this.isComplete(advanceNode)) {
                    newParse1.setChild(originalAdvanceIndex, "built.c");
                } else {
                    newParse1.setChild(originalAdvanceIndex, "built.i");
                }
            } else {
                newParse1.setChild(originalAdvanceIndex, BUILT);
            }
            newParse1.addProb(Math.log(doneProb));
            if (advanceNodeIndex == 0) {
                newParsesList.add(newParse1);
            } else {
                List<Parse> rf = Parser.getRightFrontier(p, this.punctSet);
                int fs = rf.size();
                for (int fi = 0; fi < fs; ++fi) {
                    Parse fn = rf.get(fi);
                    this.attachModel.eval(this.attachContextGenerator.getContext(children, advanceNodeIndex, rf, fi), this.aprobs);
                    if (this.debugOn) {
                        System.out.println("Frontier node(" + fi + "): " + fn.getType() + "." + fn.getLabel() + " " + fn + " <- " + advanceNode.getType() + " " + advanceNode + " d=" + this.aprobs[this.daughterAttachIndex] + " s=" + this.aprobs[this.sisterAttachIndex] + " ");
                    }
                    for (int ai = 0; ai < this.attachments.length; ++ai) {
                        double prob = this.aprobs[this.attachments[ai]];
                        if (prob > q && (!checkComplete && (this.attachments[ai] != this.daughterAttachIndex || !this.isComplete(fn)) || checkComplete && (this.attachments[ai] == this.daughterAttachIndex && !this.isComplete(fn) || this.attachments[ai] == this.sisterAttachIndex && this.isComplete(fn)))) {
                            Parse updatedNode;
                            newParse2 = newParse1.cloneRoot(fn, originalZeroIndex);
                            Parse[] newKids = Parser.collapsePunctuation(newParse2.getChildren(), this.punctSet);
                            for (int ri = originalZeroIndex + 1; ri <= originalAdvanceIndex; ++ri) {
                                newParse2.remove(originalZeroIndex + 1);
                            }
                            List<Parse> crf = Parser.getRightFrontier(newParse2, this.punctSet);
                            if (this.attachments[ai] == this.daughterAttachIndex) {
                                updatedNode = crf.get(fi);
                                updatedNode.add(advanceNode, this.headRules);
                            } else if (fi + 1 < crf.size()) {
                                Parse psite = crf.get(fi + 1);
                                updatedNode = psite.adjoin(advanceNode, this.headRules);
                            } else {
                                Parse psite = newParse2;
                                newKids[0] = updatedNode = psite.adjoinRoot(advanceNode, this.headRules, originalZeroIndex);
                            }
                            for (int ni = fi + 1; ni < crf.size(); ++ni) {
                                Parse node = crf.get(ni);
                                node.updateSpan();
                            }
                            newParse2.addProb(Math.log(prob));
                            newParsesList.add(newParse2);
                            if (!checkComplete) continue;
                            this.cprobs = this.checkModel.eval(this.checkContextGenerator.getContext(updatedNode, newKids, advanceNodeIndex, true));
                            if (this.cprobs[this.completeIndex] > probMass) {
                                this.setComplete(updatedNode);
                                newParse2.addProb(Math.log(this.cprobs[this.completeIndex]));
                                if (!this.debugOn) continue;
                                System.out.println("Only advancing complete node");
                                continue;
                            }
                            if (1.0 - this.cprobs[this.completeIndex] > probMass) {
                                this.setIncomplete(updatedNode);
                                newParse2.addProb(Math.log(1.0 - this.cprobs[this.completeIndex]));
                                if (!this.debugOn) continue;
                                System.out.println("Only advancing incomplete node");
                                continue;
                            }
                            this.setComplete(updatedNode);
                            Parse newParse3 = newParse2.cloneRoot(updatedNode, originalZeroIndex);
                            newParse3.addProb(Math.log(this.cprobs[this.completeIndex]));
                            newParsesList.add(newParse3);
                            this.setIncomplete(updatedNode);
                            newParse2.addProb(Math.log(1.0 - this.cprobs[this.completeIndex]));
                            if (!this.debugOn) continue;
                            System.out.println("Advancing both complete and incomplete nodes; c=" + this.cprobs[this.completeIndex]);
                            continue;
                        }
                        if (!this.debugOn) continue;
                        System.out.println("Skipping " + fn.getType() + "." + fn.getLabel() + " " + fn + " daughter=" + (this.attachments[ai] == this.daughterAttachIndex) + " complete=" + this.isComplete(fn) + " prob=" + prob);
                    }
                    if (!checkComplete || this.isComplete(fn)) continue;
                    if (!this.debugOn) break;
                    System.out.println("Stopping at incomplete node(" + fi + "): " + fn.getType() + "." + fn.getLabel() + " " + fn);
                    break;
                }
            }
        }
        Parse[] newParses = new Parse[newParsesList.size()];
        newParsesList.toArray(newParses);
        return newParses;
    }

    @Override
    protected void advanceTop(Parse p) {
        p.setType("TOP");
    }

    public static ParserModel train(String languageCode, ObjectStream<Parse> parseSamples, HeadRules rules, int iterations, int cut) throws IOException {
        System.err.println("Building dictionary");
        Dictionary mdict = Parser.buildDictionary(parseSamples, rules, cut);
        parseSamples.reset();
        POSModel posModel = POSTaggerME.train(languageCode, new PosSampleStream(parseSamples), ModelType.MAXENT, null, null, cut, iterations);
        parseSamples.reset();
        ChunkerModel chunkModel = ChunkerME.train(languageCode, new ChunkSampleStream(parseSamples), cut, iterations, new ChunkContextGenerator());
        parseSamples.reset();
        System.err.println("Training builder");
        ParserEventStream bes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.BUILD, mdict);
        AbstractModel buildModel = Parser.train((EventStream)bes, iterations, cut);
        parseSamples.reset();
        System.err.println("Training checker");
        ParserEventStream kes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.CHECK);
        AbstractModel checkModel = Parser.train((EventStream)kes, iterations, cut);
        parseSamples.reset();
        System.err.println("Training attacher");
        ParserEventStream attachEvents = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.ATTACH);
        AbstractModel attachModel = Parser.train((EventStream)attachEvents, iterations, cut);
        return new ParserModel(languageCode, buildModel, checkModel, attachModel, posModel, chunkModel, (opennlp.tools.parser.lang.en.HeadRules)rules, ParserType.TREEINSERT);
    }

    @Deprecated
    public static AbstractModel train(EventStream es, int iterations, int cut) throws IOException {
        return GIS.trainModel((int)iterations, (DataIndexer)new TwoPassDataIndexer(es, cut));
    }

    @Deprecated
    private static void usage() {
        System.err.println("Usage: ParserME -[dict|tag|chunk|build|attach|fun] trainingFile parserModelDirectory [iterations cutoff]");
        System.err.println();
        System.err.println("Training file should be one sentence per line where each line consists of a Penn Treebank Style parse");
        System.err.println("-tag Just build the tagging model.");
        System.err.println("-chunk Just build the chunking model.");
        System.err.println("-build Just build the build model");
        System.err.println("-attach Just build the attach model");
        System.err.println("-fun Predict function tags");
    }

    @Deprecated
    public static void main(String[] args) throws IOException {
        ParserEventStream ces;
        if (args.length < 3) {
            Parser.usage();
            System.exit(1);
        }
        boolean tag = false;
        boolean chunk = false;
        boolean build = false;
        boolean attach = false;
        boolean check = false;
        boolean fun = false;
        boolean all = true;
        int argIndex = 0;
        while (args[argIndex].startsWith("-")) {
            all = false;
            if (args[argIndex].equals("-tag")) {
                tag = true;
            } else if (args[argIndex].equals("-chunk")) {
                chunk = true;
            } else if (args[argIndex].equals("-build")) {
                build = true;
            } else if (args[argIndex].equals("-attach")) {
                attach = true;
            } else if (args[argIndex].equals("-check")) {
                check = true;
            } else if (args[argIndex].equals("-fun")) {
                fun = true;
            } else {
                if (args[argIndex].equals("--")) break;
                System.err.println("Invalid option " + args[argIndex]);
                Parser.usage();
                System.exit(1);
            }
            ++argIndex;
        }
        int n = ++argIndex;
        File inFile = new File(args[n]);
        int n2 = ++argIndex;
        ++argIndex;
        String modelDirectory = args[n2];
        opennlp.tools.parser.lang.en.HeadRules rules = new opennlp.tools.parser.lang.en.HeadRules(modelDirectory + "/head_rules");
        File tagFile = new File(modelDirectory + "/tag.bin.gz");
        File chunkFile = new File(modelDirectory + "/chunk.bin.gz");
        File buildFile = new File(modelDirectory + "/build.bin.gz");
        File attachFile = new File(modelDirectory + "/attach.bin.gz");
        File checkFile = new File(modelDirectory + "/check.bin.gz");
        int iterations = 100;
        int cutoff = 5;
        if (args.length > argIndex) {
            iterations = Integer.parseInt(args[argIndex++]);
            cutoff = Integer.parseInt(args[argIndex++]);
        }
        if (fun) {
            Parse.useFunctionTags(true);
        }
        if (tag || all) {
            System.err.println("Training tagger");
            ParserEventStream tes = new ParserEventStream(new ParseSampleStream(new PlainTextByLineStream(new FileReader(inFile))), rules, ParserEventTypeEnum.TAG);
            AbstractModel tagModel = Parser.train((EventStream)tes, iterations, cutoff);
            System.out.println("Saving the tagger model as: " + tagFile);
            new SuffixSensitiveGISModelWriter(tagModel, tagFile).persist();
        }
        if (chunk || all) {
            System.err.println("Training chunker");
            ces = new ParserEventStream(new ParseSampleStream(new PlainTextByLineStream(new FileReader(inFile))), rules, ParserEventTypeEnum.CHUNK);
            AbstractModel chunkModel = Parser.train((EventStream)ces, iterations, cutoff);
            System.out.println("Saving the chunker model as: " + chunkFile);
            new SuffixSensitiveGISModelWriter(chunkModel, chunkFile).persist();
        }
        if (build || all) {
            System.err.println("Training builder");
            ParserEventStream bes = new ParserEventStream(new ParseSampleStream(new PlainTextByLineStream(new FileReader(inFile))), rules, ParserEventTypeEnum.BUILD, null);
            AbstractModel buildModel = Parser.train((EventStream)bes, iterations, cutoff);
            System.out.println("Saving the build model as: " + buildFile);
            new SuffixSensitiveGISModelWriter(buildModel, buildFile).persist();
        }
        if (attach || all) {
            System.err.println("Training attacher");
            ParserEventStream kes = new ParserEventStream(new ParseSampleStream(new PlainTextByLineStream(new FileReader(inFile))), rules, ParserEventTypeEnum.ATTACH);
            AbstractModel attachModel = Parser.train((EventStream)kes, iterations, cutoff);
            System.out.println("Saving the attach model as: " + attachFile);
            new SuffixSensitiveGISModelWriter(attachModel, attachFile).persist();
        }
        if (check || all) {
            System.err.println("Training checker");
            ces = new ParserEventStream(new ParseSampleStream(new PlainTextByLineStream(new FileReader(inFile))), rules, ParserEventTypeEnum.CHECK);
            AbstractModel checkModel = Parser.train((EventStream)ces, iterations, cutoff);
            System.out.println("Saving the check model as: " + checkFile);
            new SuffixSensitiveGISModelWriter(checkModel, checkFile).persist();
        }
    }
}

