/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.doccat;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.doccat.DoccatModelLoader;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;

public class DoccatTool
implements CmdLineTool {
    public String getName() {
        return "DocumentCategorizer";
    }

    public String getShortDescription() {
        return "learnable document categorizer";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < documents";
    }

    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        DoccatModel model = (DoccatModel)new DoccatModelLoader().load(new File(args[0]));
        DocumentCategorizerME doccat = new DocumentCategorizerME(model);
        ParagraphStream documentStream = new ParagraphStream(new PlainTextByLineStream(new InputStreamReader(System.in)));
        PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "doc");
        perfMon.start();
        try {
            String document;
            while ((document = (String)documentStream.read()) != null) {
                double[] prob = doccat.categorize(document);
                String category = doccat.getBestCategory(prob);
                DocumentSample sample = new DocumentSample(category, document);
                System.out.println(sample.toString());
                perfMon.incrementCounter();
            }
        }
        catch (IOException e) {
            CmdLineUtil.handleStdinIoError(e);
        }
        perfMon.stopAndPrintFinalResult();
    }
}

