/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import opennlp.model.AbstractModel;
import opennlp.model.DataIndexer;
import opennlp.model.EvalParameters;
import opennlp.model.MutableContext;
import opennlp.perceptron.PerceptronModel;

public class PerceptronTrainer {
    private int numUniqueEvents;
    private int numEvents;
    private int numPreds;
    private int numOutcomes;
    private int[][] contexts;
    private float[][] values;
    private int[] outcomeList;
    private int[] numTimesEventsSeen;
    private String[] outcomeLabels;
    private String[] predLabels;
    private MutableContext[] params;
    private int[][][] updates;
    private int VALUE = 0;
    private int ITER = 1;
    private int EVENT = 2;
    private MutableContext[] averageParams;
    private EvalParameters evalParams;
    private boolean printMessages = true;
    double[] modelDistribution;
    private int iterations;
    private boolean useAverage;

    public AbstractModel trainModel(int iterations, DataIndexer di, int cutoff) {
        this.iterations = iterations;
        return this.trainModel(iterations, di, cutoff, true);
    }

    public AbstractModel trainModel(int iterations, DataIndexer di, int cutoff, boolean useAverage) {
        this.display("Incorporating indexed data for training...  \n");
        this.useAverage = useAverage;
        this.contexts = di.getContexts();
        this.values = di.getValues();
        this.numTimesEventsSeen = di.getNumTimesEventsSeen();
        this.numEvents = di.getNumEvents();
        this.numUniqueEvents = this.contexts.length;
        this.iterations = iterations;
        this.outcomeLabels = di.getOutcomeLabels();
        this.outcomeList = di.getOutcomeList();
        this.predLabels = di.getPredLabels();
        this.numPreds = this.predLabels.length;
        this.numOutcomes = this.outcomeLabels.length;
        if (useAverage) {
            this.updates = new int[this.numPreds][this.numOutcomes][3];
        }
        this.display("done.\n");
        this.display("\tNumber of Event Tokens: " + this.numUniqueEvents + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        this.params = new MutableContext[this.numPreds];
        if (useAverage) {
            this.averageParams = new MutableContext[this.numPreds];
        }
        this.evalParams = new EvalParameters(this.params, this.numOutcomes);
        int[] allOutcomesPattern = new int[this.numOutcomes];
        for (int oi = 0; oi < this.numOutcomes; ++oi) {
            allOutcomesPattern[oi] = oi;
        }
        for (int pi = 0; pi < this.numPreds; ++pi) {
            this.params[pi] = new MutableContext(allOutcomesPattern, new double[this.numOutcomes]);
            if (useAverage) {
                this.averageParams[pi] = new MutableContext(allOutcomesPattern, new double[this.numOutcomes]);
            }
            for (int aoi = 0; aoi < this.numOutcomes; ++aoi) {
                this.params[pi].setParameter(aoi, 0.0);
                if (!useAverage) continue;
                this.averageParams[pi].setParameter(aoi, 0.0);
            }
        }
        this.modelDistribution = new double[this.numOutcomes];
        this.display("Computing model parameters...\n");
        this.findParameters(iterations);
        this.display("...done.\n");
        if (useAverage) {
            return new PerceptronModel(this.averageParams, this.predLabels, this.outcomeLabels);
        }
        return new PerceptronModel(this.params, this.predLabels, this.outcomeLabels);
    }

    private void display(String s) {
        if (this.printMessages) {
            System.out.print(s);
        }
    }

    private void findParameters(int iterations) {
        this.display("Performing " + iterations + " iterations.\n");
        for (int i = 1; i <= iterations; ++i) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(i + ":  ");
            }
            this.nextIteration(i);
        }
        if (this.useAverage) {
            this.trainingStats(this.averageParams);
        } else {
            this.trainingStats(this.params);
        }
        this.numTimesEventsSeen = null;
        this.contexts = null;
    }

    private void nextIteration(int iteration) {
        int oi;
        --iteration;
        int numCorrect = 0;
        int oei = 0;
        int ei = 0;
        while (ei < this.numUniqueEvents) {
            for (int ni = 0; ni < this.numTimesEventsSeen[ei]; ++ni) {
                boolean correct;
                for (int oi2 = 0; oi2 < this.numOutcomes; ++oi2) {
                    this.modelDistribution[oi2] = 0.0;
                }
                if (this.values != null) {
                    PerceptronModel.eval(this.contexts[ei], this.values[ei], this.modelDistribution, this.evalParams, false);
                } else {
                    PerceptronModel.eval(this.contexts[ei], null, this.modelDistribution, this.evalParams, false);
                }
                int max = 0;
                for (int oi3 = 1; oi3 < this.numOutcomes; ++oi3) {
                    if (!(this.modelDistribution[oi3] > this.modelDistribution[max])) continue;
                    max = oi3;
                }
                boolean bl = correct = max == this.outcomeList[oei];
                if (correct) {
                    ++numCorrect;
                }
                for (oi = 0; oi < this.numOutcomes; ++oi) {
                    int pi;
                    int ci;
                    if (oi == this.outcomeList[oei]) {
                        if (!(this.modelDistribution[oi] <= 0.0)) continue;
                        for (ci = 0; ci < this.contexts[ei].length; ++ci) {
                            pi = this.contexts[ei][ci];
                            if (this.values == null) {
                                this.params[pi].updateParameter(oi, 1.0);
                            } else {
                                this.params[pi].updateParameter(oi, this.values[ei][ci]);
                            }
                            if (!this.useAverage) continue;
                            if (this.updates[pi][oi][this.VALUE] != 0) {
                                this.averageParams[pi].updateParameter(oi, this.updates[pi][oi][this.VALUE] * (this.numEvents * (iteration - this.updates[pi][oi][this.ITER]) + (ei - this.updates[pi][oi][this.EVENT])));
                            }
                            this.updates[pi][oi][this.VALUE] = (int)this.params[pi].getParameters()[oi];
                            this.updates[pi][oi][this.ITER] = iteration;
                            this.updates[pi][oi][this.EVENT] = ei;
                        }
                        continue;
                    }
                    if (!(this.modelDistribution[oi] > 0.0)) continue;
                    for (ci = 0; ci < this.contexts[ei].length; ++ci) {
                        pi = this.contexts[ei][ci];
                        if (this.values == null) {
                            this.params[pi].updateParameter(oi, -1.0);
                        } else {
                            this.params[pi].updateParameter(oi, -1.0f * this.values[ei][ci]);
                        }
                        if (!this.useAverage) continue;
                        if (this.updates[pi][oi][this.VALUE] != 0) {
                            this.averageParams[pi].updateParameter(oi, this.updates[pi][oi][this.VALUE] * (this.numEvents * (iteration - this.updates[pi][oi][this.ITER]) + (ei - this.updates[pi][oi][this.EVENT])));
                        }
                        this.updates[pi][oi][this.VALUE] = (int)this.params[pi].getParameters()[oi];
                        this.updates[pi][oi][this.ITER] = iteration;
                        this.updates[pi][oi][this.EVENT] = ei;
                    }
                }
            }
            ++ei;
            ++oei;
        }
        double totIterations = (double)this.iterations * (double)this.numEvents;
        if (this.useAverage && iteration == this.iterations - 1) {
            for (int pi = 0; pi < this.numPreds; ++pi) {
                double[] predParams = this.averageParams[pi].getParameters();
                for (oi = 0; oi < this.numOutcomes; ++oi) {
                    if (this.updates[pi][oi][this.VALUE] != 0) {
                        int n = oi;
                        predParams[n] = predParams[n] + (double)(this.updates[pi][oi][this.VALUE] * (this.numEvents * (this.iterations - this.updates[pi][oi][this.ITER]) - this.updates[pi][oi][this.EVENT]));
                    }
                    if (predParams[oi] == 0.0) continue;
                    int n = oi;
                    predParams[n] = predParams[n] / totIterations;
                    this.averageParams[pi].setParameter(oi, predParams[oi]);
                }
            }
        }
        this.display(". (" + numCorrect + "/" + this.numEvents + ") " + (double)numCorrect / (double)this.numEvents + "\n");
    }

    private void trainingStats(MutableContext[] params) {
        int numCorrect = 0;
        for (int ei = 0; ei < this.numUniqueEvents; ++ei) {
            for (int ni = 0; ni < this.numTimesEventsSeen[ei]; ++ni) {
                for (int oi = 0; oi < this.numOutcomes; ++oi) {
                    this.modelDistribution[oi] = 0.0;
                }
                if (this.values != null) {
                    PerceptronModel.eval(this.contexts[ei], this.values[ei], this.modelDistribution, this.evalParams, false);
                } else {
                    PerceptronModel.eval(this.contexts[ei], null, this.modelDistribution, this.evalParams, false);
                }
                int max = 0;
                for (int oi = 1; oi < this.numOutcomes; ++oi) {
                    if (!(this.modelDistribution[oi] > this.modelDistribution[max])) continue;
                    max = oi;
                }
                if (max != this.outcomeList[ei]) continue;
                ++numCorrect;
            }
        }
        this.display(". (" + numCorrect + "/" + this.numEvents + ") " + (double)numCorrect / (double)this.numEvents + "\n");
    }
}

