/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.WrappedSurface;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLXContext;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory;

public class X11ExternalGLXContext
extends X11GLXContext {
    private GLContext lastContext;

    private X11ExternalGLXContext(Drawable drawable, long l) {
        super(drawable, null);
        this.contextHandle = l;
        GLContextShareSet.contextCreated(this);
        this.setGLFunctionAvailability(false, true, 0, 0, 34);
        this.getGLStateTracker().setEnabled(false);
    }

    protected static X11ExternalGLXContext create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        Object object;
        long l = GLX.glXGetCurrentContext();
        if (l == 0L) {
            throw new GLException("Error: current context null");
        }
        long l2 = GLX.glXGetCurrentDisplay();
        if (l2 == 0L) {
            throw new GLException("Error: current display null");
        }
        long l3 = GLX.glXGetCurrentDrawable();
        if (l3 == 0L) {
            throw new GLException("Error: attempted to make an external GLDrawable without a drawable/context current");
        }
        int[] nArray = new int[1];
        GLX.glXQueryContext(l2, l, 32780, nArray, 0);
        X11GraphicsScreen x11GraphicsScreen = (X11GraphicsScreen)X11GraphicsScreen.createScreenDevice(l2, nArray[0]);
        GLX.glXQueryContext(l2, l, 32787, nArray, 0);
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = null;
        if (X11GLXGraphicsConfiguration.GLXFBConfigIDValid(l2, x11GraphicsScreen.getIndex(), nArray[0])) {
            object = new GLCapabilities(GLProfile.getDefault());
            x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)object, (GLCapabilitiesImmutable)object, null, x11GraphicsScreen);
            if (DEBUG) {
                System.err.println("X11ExternalGLXContext invalid FBCONFIG_ID " + nArray[0] + ", using default cfg: " + x11GLXGraphicsConfiguration);
            }
        } else {
            x11GLXGraphicsConfiguration = X11GLXGraphicsConfiguration.create(gLProfile, x11GraphicsScreen, nArray[0]);
        }
        object = new WrappedSurface(x11GLXGraphicsConfiguration);
        ((WrappedSurface)object).setSurfaceHandle(l3);
        return new X11ExternalGLXContext(new Drawable(gLDrawableFactory, (NativeSurface)object), l);
    }

    @Override
    protected boolean createImpl() {
        return true;
    }

    @Override
    public int makeCurrent() throws GLException {
        GLContext gLContext = X11ExternalGLXContext.getCurrent();
        if (gLContext != null && gLContext != this) {
            this.lastContext = gLContext;
            X11ExternalGLXContext.setCurrent(null);
        }
        return super.makeCurrent();
    }

    @Override
    public void release() throws GLException {
        super.release();
        X11ExternalGLXContext.setCurrent(this.lastContext);
        this.lastContext = null;
    }

    @Override
    protected void makeCurrentImpl(boolean bl) throws GLException {
    }

    @Override
    protected void releaseImpl() throws GLException {
    }

    @Override
    protected void destroyImpl() throws GLException {
    }

    static class Drawable
    extends X11GLXDrawable {
        Drawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
            super(gLDrawableFactory, nativeSurface, true);
        }

        @Override
        public GLContext createContext(GLContext gLContext) {
            throw new GLException("Should not call this");
        }

        @Override
        public int getWidth() {
            throw new GLException("Should not call this");
        }

        @Override
        public int getHeight() {
            throw new GLException("Should not call this");
        }

        public void setSize(int n, int n2) {
            throw new GLException("Should not call this");
        }
    }
}

