/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.windows.WindowsGraphicsDevice;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.PIXELFORMATDESCRIPTOR;
import jogamp.opengl.Debug;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.windows.wgl.WGLGLCapabilities;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsWGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");
    static WGLGLCapabilities.PfdIDComparator PfdIDComparator = new WGLGLCapabilities.PfdIDComparator();

    WindowsWGLGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory(WindowsGraphicsDevice.class, this);
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        return WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen);
    }

    static WindowsWGLGraphicsConfiguration createDefaultGraphicsConfiguration(GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen) {
        return WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, null, abstractGraphicsScreen);
    }

    static WindowsWGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = DefaultGraphicsScreen.createDefault("Windows");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, GLDrawableFactory.getDesktopFactory().canCreateGLPbuffer(abstractGraphicsDevice));
        return new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(WindowsWGLDrawableFactory windowsWGLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        WindowsWGLDrawableFactory.SharedResource sharedResource = windowsWGLDrawableFactory.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        WindowsWGLDrawable windowsWGLDrawable = sharedResource.getDrawable();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = windowsWGLDrawable.getChosenGLCapabilities();
        WindowsWGLContext windowsWGLContext = sharedResource.getContext();
        List list = null;
        if (sharedResource.needsCurrentContext4ARBPFDQueries()) {
            if (0 == windowsWGLContext.makeCurrent()) {
                throw new GLException("Could not make Shared Context current: " + abstractGraphicsDevice);
            }
        } else {
            windowsWGLDrawable.lockSurface();
        }
        try {
            long l = windowsWGLDrawable.getHandle();
            if (0L == l) {
                throw new GLException("Error: HDC is null");
            }
            if (sharedResource.hasARBPixelFormat()) {
                list = WindowsWGLGraphicsConfigurationFactory.getAvailableGLCapabilitiesARB(l, sharedResource, gLCapabilitiesImmutable.getGLProfile());
            }
            if (null == list || list.isEmpty()) {
                list = WindowsWGLGraphicsConfigurationFactory.getAvailableGLCapabilitiesGDI(l, gLCapabilitiesImmutable.getGLProfile());
            }
        }
        finally {
            if (sharedResource.needsCurrentContext4ARBPFDQueries()) {
                windowsWGLContext.release();
            } else {
                windowsWGLDrawable.unlockSurface();
            }
        }
        if (null != list && list.size() > 1) {
            Collections.sort(list, PfdIDComparator);
        }
        return list;
    }

    static List getAvailableGLCapabilitiesARB(long l, WindowsWGLDrawableFactory.SharedResource sharedResource, GLProfile gLProfile) {
        int[] nArray = WindowsWGLGraphicsConfiguration.wglAllARBPFIDs(sharedResource.getContext(), l);
        return WindowsWGLGraphicsConfiguration.wglARBPFIDs2AllGLCapabilities(sharedResource, l, nArray, gLProfile);
    }

    static List getAvailableGLCapabilitiesGDI(long l, GLProfile gLProfile) {
        int[] nArray = WindowsWGLGraphicsConfiguration.wglAllGDIPFIDs(l);
        int n = nArray.length;
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(arrayList, gLProfile, l, nArray[i], 7);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateGraphicsConfiguration(CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, int[] nArray) {
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        if (gLDrawableFactory == null) {
            throw new IllegalArgumentException("GLDrawableFactory is null");
        }
        if (nativeSurface == null) {
            throw new IllegalArgumentException("NativeSurface is null");
        }
        if (1 >= nativeSurface.lockSurface()) {
            throw new GLException("Surface not ready (lockSurface)");
        }
        try {
            long l = nativeSurface.getSurfaceHandle();
            if (0L == l) {
                throw new GLException("Error: HDC is null");
            }
            WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
            if (!windowsWGLGraphicsConfiguration.isExternal()) {
                if (!windowsWGLGraphicsConfiguration.isDetermined()) {
                    WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(windowsWGLGraphicsConfiguration, capabilitiesChooser, gLDrawableFactory, l, false, nArray);
                } else {
                    int n = -1;
                    boolean bl = false;
                    n = GDI.GetPixelFormat(l);
                    if (1 > n) {
                        if (!GDI.SetPixelFormat(l, windowsWGLGraphicsConfiguration.getPixelFormatID(), windowsWGLGraphicsConfiguration.getPixelFormat())) {
                            throw new GLException("Unable to set pixel format " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " for device context " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ": error code " + GDI.GetLastError());
                        }
                        bl = true;
                    }
                    if (DEBUG) {
                        System.err.println("!!! setPixelFormat (post): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", " + n + " -> " + windowsWGLGraphicsConfiguration.getPixelFormatID() + ", set: " + bl);
                        Thread.dumpStack();
                    }
                }
            }
        }
        finally {
            nativeSurface.unlockSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void preselectGraphicsConfiguration(CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, int[] nArray) {
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        if (gLDrawableFactory == null) {
            throw new IllegalArgumentException("GLDrawableFactory is null");
        }
        if (windowsWGLGraphicsConfiguration == null) {
            throw new IllegalArgumentException("WindowsWGLGraphicsConfiguration is null");
        }
        WindowsWGLDrawableFactory windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)gLDrawableFactory;
        WindowsWGLDrawable windowsWGLDrawable = windowsWGLDrawableFactory.getOrCreateSharedDrawable(abstractGraphicsDevice);
        if (null == windowsWGLDrawable) {
            throw new IllegalArgumentException("Shared Drawable is null");
        }
        if (1 >= windowsWGLDrawable.lockSurface()) {
            throw new GLException("Surface not ready (lockSurface)");
        }
        try {
            long l = windowsWGLDrawable.getHandle();
            if (0L == l) {
                throw new GLException("Error: HDC is null");
            }
            WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(windowsWGLGraphicsConfiguration, capabilitiesChooser, windowsWGLDrawableFactory, l, true, nArray);
        }
        finally {
            windowsWGLDrawable.unlockSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateGraphicsConfiguration(WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, long l, boolean bl, int[] nArray) {
        if (DEBUG) {
            if (bl) {
                System.err.println("updateGraphicsConfiguration(using shared): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l));
            } else {
                System.err.println("updateGraphicsConfiguration(using target): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l));
            }
            System.err.println("!!! user chosen caps " + windowsWGLGraphicsConfiguration.getChosenCapabilities());
        }
        AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
        WindowsWGLDrawableFactory.SharedResource sharedResource = ((WindowsWGLDrawableFactory)gLDrawableFactory).getOrCreateSharedResource(abstractGraphicsDevice);
        WindowsWGLContext windowsWGLContext = null;
        if (null != sharedResource && sharedResource.needsCurrentContext4ARBPFDQueries() && 0 == (windowsWGLContext = sharedResource.getContext()).makeCurrent()) {
            throw new GLException("Could not make Shared Context current: " + abstractGraphicsDevice);
        }
        try {
            if (!WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfigurationARB(l, bl, windowsWGLGraphicsConfiguration, capabilitiesChooser, (WindowsWGLDrawableFactory)gLDrawableFactory, nArray)) {
                WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfigurationGDI(l, bl, windowsWGLGraphicsConfiguration, capabilitiesChooser, nArray);
            }
        }
        finally {
            if (null != windowsWGLContext) {
                windowsWGLContext.release();
            }
        }
    }

    private static boolean updateGraphicsConfigurationARB(long l, boolean bl, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, CapabilitiesChooser capabilitiesChooser, WindowsWGLDrawableFactory windowsWGLDrawableFactory, int[] nArray) {
        int n;
        AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
        WindowsWGLDrawableFactory.SharedResource sharedResource = windowsWGLDrawableFactory.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null == sharedResource) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: SharedResource is null: " + abstractGraphicsDevice);
            }
            return false;
        }
        if (!sharedResource.hasARBPixelFormat()) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: WGL_ARB_pixel_format not available");
            }
            return false;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        boolean bl2 = gLCapabilitiesImmutable.isBackgroundOpaque() && GDI.DwmIsCompositionEnabled();
        boolean bl3 = gLCapabilitiesImmutable.isOnscreen();
        boolean bl4 = gLCapabilitiesImmutable.isPBuffer();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        if (DEBUG) {
            System.err.println("!!! translucency requested: " + !gLCapabilitiesImmutable.isBackgroundOpaque() + ", compositioning enabled: " + GDI.DwmIsCompositionEnabled() + " -> translucency " + !bl2);
        }
        WGLGLCapabilities wGLGLCapabilities = null;
        boolean bl5 = false;
        int n2 = n = bl ? -1 : GDI.GetPixelFormat(l);
        if (1 <= n) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: Pixel format already chosen for HDC: " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", pixelformat " + n);
            }
            bl5 = true;
            wGLGLCapabilities = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, l, n, gLProfile, bl3, bl4);
            wGLGLCapabilities = (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixOpaqueGLCapabilities(wGLGLCapabilities, bl2);
        } else {
            int n3;
            Object object;
            int n4 = -1;
            if (null == nArray) {
                object = new int[512];
                int n5 = 8231;
                float[] fArray = new float[1];
                nArray = WindowsWGLGraphicsConfiguration.wglChoosePixelFormatARB(l, sharedResource, gLCapabilitiesImmutable, object, n5, fArray);
                if (null == nArray) {
                    n5 = 8230;
                    nArray = WindowsWGLGraphicsConfiguration.wglChoosePixelFormatARB(l, sharedResource, gLCapabilitiesImmutable, object, n5, fArray);
                }
                if (null == nArray) {
                    n5 = -1;
                    nArray = WindowsWGLGraphicsConfiguration.wglChoosePixelFormatARB(l, sharedResource, gLCapabilitiesImmutable, object, n5, fArray);
                }
                if (null != nArray) {
                    n4 = 0;
                } else {
                    if (DEBUG) {
                        System.err.println("updateGraphicsConfigurationARB: wglChoosePixelFormatARB failed with: " + gLCapabilitiesImmutable);
                    }
                    nArray = WindowsWGLGraphicsConfiguration.wglAllARBPFIDs(sharedResource.getContext(), l);
                    if (DEBUG) {
                        int n6 = null != nArray ? nArray.length : 0;
                        System.err.println("updateGraphicsConfigurationARB: NumFormats (wglAllARBPFIDs) " + n6);
                    }
                }
                if (null == nArray) {
                    if (DEBUG) {
                        Thread.dumpStack();
                    }
                    return false;
                }
            }
            if (null == (object = (Object)WindowsWGLGraphicsConfiguration.wglARBPFIDs2GLCapabilities(sharedResource, l, nArray, gLProfile, bl3, bl4)) || 0 == object.size()) {
                if (DEBUG) {
                    System.err.println("updateGraphicsConfigurationARB: wglARBPFIDs2GLCapabilities failed with " + nArray.length + " pfd ids, onscreen " + bl3 + ", pbuffer " + bl4);
                    Thread.dumpStack();
                }
                return false;
            }
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: " + nArray.length + " pfd ids, onscreen " + bl3 + ", pbuffer " + bl4 + ", " + object.size() + " glcaps");
                if (0 <= n4) {
                    System.err.println("updateGraphicsConfigurationARB: Used wglChoosePixelFormatARB to recommend pixel format " + nArray[n4] + ", idx " + n4 + ", " + object.get(n4));
                }
            }
            if (0 > (n3 = WindowsWGLGraphicsConfigurationFactory.chooseCapabilities(capabilitiesChooser, gLCapabilitiesImmutable, (List)object, n4))) {
                if (DEBUG) {
                    Thread.dumpStack();
                }
                return false;
            }
            wGLGLCapabilities = (WGLGLCapabilities)object.get(n3);
            if (null == wGLGLCapabilities) {
                throw new GLException("Null Capabilities with  chosen pfdID: native recommended " + (n4 + 1) + " chosen idx " + n3);
            }
            wGLGLCapabilities = (WGLGLCapabilities)GLGraphicsConfigurationUtil.fixOpaqueGLCapabilities(wGLGLCapabilities, bl2);
            if (DEBUG) {
                System.err.println("!!! chosen pfdID (ARB): native recommended " + (n4 + 1) + " chosen " + wGLGLCapabilities);
            }
        }
        if (!bl && !bl5) {
            windowsWGLGraphicsConfiguration.setPixelFormat(l, wGLGLCapabilities);
        } else {
            windowsWGLGraphicsConfiguration.setCapsPFD(wGLGLCapabilities);
        }
        return true;
    }

    private static boolean updateGraphicsConfigurationGDI(long l, boolean bl, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, CapabilitiesChooser capabilitiesChooser, int[] nArray) {
        int n;
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        if (gLCapabilitiesImmutable.isPBuffer()) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationGDI: no pbuffer supported on GDI: " + gLCapabilitiesImmutable);
            }
            return false;
        }
        boolean bl2 = gLCapabilitiesImmutable.isOnscreen();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        ArrayList arrayList = new ArrayList();
        WGLGLCapabilities wGLGLCapabilities = null;
        boolean bl3 = false;
        if (!bl && 1 <= (n = GDI.GetPixelFormat(l))) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationGDI: NOTE: pixel format already chosen for HDC: " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", pixelformat " + n);
            }
            bl3 = true;
            wGLGLCapabilities = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, l, n, bl2);
        } else {
            int n2;
            if (null == nArray) {
                nArray = WindowsWGLGraphicsConfiguration.wglAllGDIPFIDs(l);
            }
            int n3 = GLGraphicsConfigurationUtil.getWinAttributeBits(bl2, false);
            for (int i = 0; i < nArray.length; ++i) {
                WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(arrayList, gLProfile, l, nArray[i], n3);
            }
            PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
            pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.GLCapabilities2PFD(gLCapabilitiesImmutable, pIXELFORMATDESCRIPTOR);
            n = GDI.ChoosePixelFormat(l, pIXELFORMATDESCRIPTOR);
            int n4 = -1;
            if (1 <= n) {
                for (n4 = arrayList.size() - 1; 0 <= n4 && n != ((WGLGLCapabilities)arrayList.get(n4)).getPFDID(); --n4) {
                }
            }
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationGDI: ChoosePixelFormat(HDC " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ") = " + n + ", idx " + n4 + " (LastError: " + GDI.GetLastError() + ")");
            }
            if (0 > (n2 = WindowsWGLGraphicsConfigurationFactory.chooseCapabilities(capabilitiesChooser, gLCapabilitiesImmutable, arrayList, n4))) {
                if (DEBUG) {
                    Thread.dumpStack();
                }
                return false;
            }
            wGLGLCapabilities = (WGLGLCapabilities)arrayList.get(n2);
            if (DEBUG) {
                System.err.println("!!! chosen pfdID (GDI): native recommended " + (n4 + 1) + ", caps " + wGLGLCapabilities);
            }
        }
        if (!bl && !bl3) {
            windowsWGLGraphicsConfiguration.setPixelFormat(l, wGLGLCapabilities);
        } else {
            windowsWGLGraphicsConfiguration.setCapsPFD(wGLGLCapabilities);
        }
        return true;
    }
}

