/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import javax.media.opengl.GLException;
import jogamp.nativewindow.jawt.JAWTUtil;

public class AWTUtil {
    private static boolean headlessMode;
    private static Class j2dClazz;
    private static Method isOGLPipelineActive;
    private static Method isQueueFlusherThread;
    private static boolean j2dOk;
    private static boolean lockedToolkit;

    public static synchronized void lockToolkit() throws GLException {
        if (lockedToolkit) {
            throw new GLException("Toolkit already locked");
        }
        lockedToolkit = true;
        if (headlessMode) {
            return;
        }
        if (j2dOk) {
            try {
                if (!((Boolean)isOGLPipelineActive.invoke(null, (Object[])null)).booleanValue() || !((Boolean)isQueueFlusherThread.invoke(null, (Object[])null)).booleanValue()) {
                    JAWTUtil.lockToolkit();
                }
            }
            catch (Exception exception) {
                j2dOk = false;
            }
        }
        if (!j2dOk) {
            JAWTUtil.lockToolkit();
        }
    }

    public static synchronized void unlockToolkit() {
        if (lockedToolkit) {
            lockedToolkit = false;
            if (headlessMode) {
                return;
            }
            if (j2dOk) {
                try {
                    if (!((Boolean)isOGLPipelineActive.invoke(null, (Object[])null)).booleanValue() || !((Boolean)isQueueFlusherThread.invoke(null, (Object[])null)).booleanValue()) {
                        JAWTUtil.unlockToolkit();
                    }
                }
                catch (Exception exception) {
                    j2dOk = false;
                }
            }
            if (!j2dOk) {
                JAWTUtil.unlockToolkit();
            }
        }
    }

    static {
        j2dClazz = null;
        isOGLPipelineActive = null;
        isQueueFlusherThread = null;
        j2dOk = false;
        lockedToolkit = false;
        headlessMode = GraphicsEnvironment.isHeadless();
        if (!headlessMode) {
            try {
                j2dClazz = Class.forName("jogamp.opengl.awt.Java2D");
                isOGLPipelineActive = j2dClazz.getMethod("isOGLPipelineActive", null);
                isQueueFlusherThread = j2dClazz.getMethod("isQueueFlusherThread", null);
                j2dOk = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

