/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.event.ScreenModeListener;
import com.jogamp.newt.util.MonitorMode;
import com.jogamp.newt.util.ScreenModeUtil;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.SurfaceSize;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.ScreenModeStatus;

public abstract class ScreenImpl
extends Screen
implements ScreenModeListener {
    protected static final boolean DEBUG_TEST_SCREENMODE_DISABLED = Debug.isPropertyDefined("newt.test.Screen.disableScreenMode", true);
    protected DisplayImpl display;
    protected int screen_idx;
    protected String fqname;
    protected int hashCode;
    protected AbstractGraphicsScreen aScreen;
    protected int refCount;
    protected int width = -1;
    protected int height = -1;
    protected static int usrWidth = -1;
    protected static int usrHeight = -1;
    private static AccessControlContext localACC = AccessController.getContext();
    private ArrayList<ScreenModeListener> referencedScreenModeListener = new ArrayList();
    long t0;

    private static Class<? extends Screen> getScreenClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "Screen");
        if (null == clazz) {
            if ("ANDROID".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.android.AndroidScreen");
            } else if ("EGL".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.kd.KDScreen");
            } else if ("Windows".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.windows.WindowsScreen");
            } else if ("MacOSX".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.macosx.MacScreen");
            } else if ("X11".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.x11.X11Screen");
            } else if ("AWT".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.awt.AWTScreen");
            } else {
                throw new RuntimeException("Unknown window type \"" + string + "\"");
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Screen create(Display display, int n) {
        try {
            Object object;
            if (usrWidth < 0 || usrHeight < 0) {
                object = Screen.class;
                // MONITORENTER : com.jogamp.newt.Screen.class
                if (usrWidth < 0 || usrHeight < 0) {
                    usrWidth = Debug.getIntProperty("newt.ws.swidth", true, localACC);
                    usrHeight = Debug.getIntProperty("newt.ws.sheight", true, localACC);
                    if (usrWidth > 0 || usrHeight > 0) {
                        System.err.println("User screen size " + usrWidth + "x" + usrHeight);
                    }
                }
                // MONITOREXIT : object
            }
            object = screenList;
            // MONITORENTER : object
            Object object2 = ScreenImpl.getLastScreenOf(display, n, -1);
            if (null != object2) {
                if (DEBUG) {
                    System.err.println("Screen.create() REUSE: " + object2 + " " + Display.getThreadName());
                }
                // MONITOREXIT : object
                return object2;
            }
            object2 = ScreenImpl.getScreenClass(display.getType());
            ScreenImpl screenImpl = (ScreenImpl)((Class)object2).newInstance();
            screenImpl.display = (DisplayImpl)display;
            screenImpl.screen_idx = n;
            screenImpl.fqname = (display.getFQName() + n).intern();
            screenImpl.hashCode = screenImpl.fqname.hashCode();
            screenList.add(screenImpl);
            if (DEBUG) {
                System.err.println("Screen.create() NEW: " + screenImpl + " " + Display.getThreadName());
            }
            // MONITOREXIT : object
            return screenImpl;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScreenImpl screenImpl = (ScreenImpl)object;
        if (!(this.display == screenImpl.display || this.display != null && this.display.equals(screenImpl.display))) {
            return false;
        }
        return this.screen_idx == screenImpl.screen_idx;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void createNative() throws NativeWindowException {
        Object object;
        if (null == this.aScreen) {
            if (DEBUG) {
                System.err.println("Screen.createNative() START (" + DisplayImpl.getThreadName() + ", " + this + ")");
            }
            this.t0 = System.currentTimeMillis();
            this.display.addReference();
            this.createNativeImpl();
            if (null == this.aScreen) {
                throw new NativeWindowException("Screen.createNative() failed to instanciate an AbstractGraphicsScreen");
            }
            this.initScreenModeStatus();
            if (DEBUG) {
                System.err.println("Screen.createNative() END (" + DisplayImpl.getThreadName() + ", " + this + ")");
            }
            object = screenList;
            synchronized (object) {
                ++screensActive;
            }
        }
        object = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        ((ScreenModeStatus)object).addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void destroy() {
        this.releaseScreenModeStatus();
        ArrayList arrayList = screenList;
        synchronized (arrayList) {
            screenList.remove(this);
            if (0 < screensActive) {
                --screensActive;
            }
        }
        if (null != this.aScreen) {
            this.closeNativeImpl();
            this.aScreen = null;
        }
        this.refCount = 0;
        this.display.removeReference();
    }

    @Override
    public final synchronized int addReference() throws NativeWindowException {
        if (DEBUG) {
            System.err.println("Screen.addReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount + 1));
        }
        if (0 == this.refCount) {
            this.createNative();
        }
        if (null == this.aScreen) {
            throw new NativeWindowException("Screen.addReference() (refCount " + this.refCount + ") null AbstractGraphicsScreen");
        }
        return ++this.refCount;
    }

    @Override
    public final synchronized int removeReference() {
        if (DEBUG) {
            String string = "Screen.removeReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount - 1);
            System.err.println(string);
        }
        --this.refCount;
        if (0 >= this.refCount) {
            this.destroy();
            this.refCount = 0;
        }
        return this.refCount;
    }

    @Override
    public final synchronized int getReferenceCount() {
        return this.refCount;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    @Override
    public final String getFQName() {
        return this.fqname;
    }

    protected void setScreenSize(int n, int n2) {
        System.err.println("Detected screen size " + n + "x" + n2);
        this.width = n;
        this.height = n2;
    }

    @Override
    public final Display getDisplay() {
        return this.display;
    }

    @Override
    public final int getIndex() {
        return this.screen_idx;
    }

    @Override
    public final AbstractGraphicsScreen getGraphicsScreen() {
        return this.aScreen;
    }

    @Override
    public final synchronized boolean isNativeValid() {
        return null != this.aScreen;
    }

    @Override
    public final int getWidth() {
        return usrWidth > 0 ? usrWidth : (this.width > 0 ? this.width : 480);
    }

    @Override
    public final int getHeight() {
        return usrHeight > 0 ? usrHeight : (this.height > 0 ? this.height : 480);
    }

    public String toString() {
        return "NEWT-Screen[" + this.getFQName() + ", idx " + this.screen_idx + ", refCount " + this.refCount + ", " + this.getWidth() + "x" + this.getHeight() + ", " + this.aScreen + ", " + this.display + "]";
    }

    @Override
    public final List<ScreenMode> getScreenModes() {
        ArrayHashSet<ScreenMode> arrayHashSet = this.getScreenModesOrig();
        if (null != arrayHashSet && 0 < arrayHashSet.size()) {
            return arrayHashSet.toArrayList();
        }
        return null;
    }

    @Override
    public ScreenMode getOriginalScreenMode() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        return null != screenModeStatus ? screenModeStatus.getOriginalScreenMode() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScreenMode getCurrentScreenMode() {
        ScreenMode screenMode = null;
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            ScreenMode screenMode2;
            ScreenMode screenMode3 = screenMode2 = DEBUG_TEST_SCREENMODE_DISABLED ? null : this.getCurrentScreenModeImpl();
            if (null == screenMode2) {
                return null;
            }
            screenModeStatus.lock();
            try {
                screenMode = (ScreenMode)screenModeStatus.getScreenModes().getOrAdd((Object)screenMode2);
                if (screenModeStatus.getCurrentScreenMode().hashCode() != screenMode.hashCode()) {
                    screenModeStatus.fireScreenModeChanged(screenMode, true);
                }
            }
            finally {
                screenModeStatus.unlock();
            }
        }
        return screenMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCurrentScreenMode(ScreenMode screenMode) {
        ScreenMode screenMode2 = this.getCurrentScreenMode();
        ScreenMode screenMode3 = (ScreenMode)this.getScreenModesOrig().get((Object)screenMode);
        if (screenMode3.equals(screenMode2)) {
            if (DEBUG) {
                System.err.println("Screen.setCurrentScreenMode (" + (System.currentTimeMillis() - this.t0) + "): 0.0 is-current (skip) " + screenMode3 + " == " + screenMode2);
            }
            return true;
        }
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            screenModeStatus.lock();
            try {
                boolean bl;
                long l = 0L;
                long l2 = 0L;
                if (DEBUG) {
                    System.err.println("Screen.setCurrentScreenMode (" + (System.currentTimeMillis() - l) + "): 0.0 " + screenMode);
                    l = System.currentTimeMillis();
                }
                screenModeStatus.fireScreenModeChangeNotify(screenMode3);
                if (DEBUG) {
                    System.err.println("Screen.setCurrentScreenMode (" + (System.currentTimeMillis() - l) + "): 0.1 " + screenMode);
                    l2 = System.currentTimeMillis();
                }
                if (bl = this.setCurrentScreenModeImpl(screenMode3)) {
                    this.setScreenSize(screenMode.getRotatedWidth(), screenMode.getRotatedHeight());
                }
                if (DEBUG) {
                    l2 = System.currentTimeMillis() - l2;
                    System.err.println("Screen.setCurrentScreenMode (" + (System.currentTimeMillis() - l) + "): X.0 " + screenMode + ", success: " + bl);
                }
                screenModeStatus.fireScreenModeChanged(screenMode3, bl);
                if (DEBUG) {
                    l = System.currentTimeMillis() - l;
                    System.err.println("Screen.setCurrentScreenMode (" + (System.currentTimeMillis() - l) + "): X.X " + screenMode + ", success: " + bl + " - dt0 " + l + "ms, dt1 " + l2 + "ms");
                }
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                screenModeStatus.unlock();
            }
        }
        return false;
    }

    @Override
    public void screenModeChangeNotify(ScreenMode screenMode) {
        for (int i = 0; i < this.referencedScreenModeListener.size(); ++i) {
            this.referencedScreenModeListener.get(i).screenModeChangeNotify(screenMode);
        }
    }

    @Override
    public void screenModeChanged(ScreenMode screenMode, boolean bl) {
        if (bl) {
            this.setScreenSize(screenMode.getRotatedWidth(), screenMode.getRotatedHeight());
        }
        for (int i = 0; i < this.referencedScreenModeListener.size(); ++i) {
            this.referencedScreenModeListener.get(i).screenModeChanged(screenMode, bl);
        }
    }

    @Override
    public final synchronized void addScreenModeListener(ScreenModeListener screenModeListener) {
        this.referencedScreenModeListener.add(screenModeListener);
    }

    @Override
    public final synchronized void removeScreenModeListener(ScreenModeListener screenModeListener) {
        this.referencedScreenModeListener.remove(screenModeListener);
    }

    protected final ArrayHashSet<ScreenMode> getScreenModesOrig() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            return screenModeStatus.getScreenModes();
        }
        return null;
    }

    protected final IntIntHashMap getScreenModesIdx2NativeIdx() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            return screenModeStatus.getScreenModesIdx2NativeIdx();
        }
        return null;
    }

    protected int[] getScreenModeFirstImpl() {
        return null;
    }

    protected int[] getScreenModeNextImpl() {
        return null;
    }

    protected ScreenMode getCurrentScreenModeImpl() {
        return null;
    }

    protected boolean setCurrentScreenModeImpl(ScreenMode screenMode) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScreenModeStatus initScreenModeStatus() {
        ScreenModeStatus screenModeStatus;
        ScreenModeStatus.lockScreenModeStatus();
        try {
            screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
            if (null == screenModeStatus) {
                ScreenMode screenMode;
                IntIntHashMap intIntHashMap = new IntIntHashMap();
                ArrayHashSet<ScreenMode> arrayHashSet = this.collectNativeScreenModes(intIntHashMap);
                if (arrayHashSet.size() == 0) {
                    ScreenMode screenMode2 = screenMode = DEBUG_TEST_SCREENMODE_DISABLED ? null : this.getCurrentScreenModeImpl();
                    if (null != screenMode) {
                        if (DEBUG) {
                            System.err.println("ScreenImpl.initScreenModeStatus: added current (last resort, collect failed): " + screenMode);
                        }
                        arrayHashSet.getOrAdd((Object)screenMode);
                    } else if (DEBUG) {
                        System.err.println("ScreenImpl.initScreenModeStatus: Warning: No screen modes added!");
                    }
                }
                screenModeStatus = new ScreenModeStatus(arrayHashSet, intIntHashMap);
                if (arrayHashSet.size() > 0) {
                    ScreenMode screenMode3 = screenMode = DEBUG_TEST_SCREENMODE_DISABLED ? null : this.getCurrentScreenModeImpl();
                    if (null != screenMode) {
                        ScreenMode screenMode4 = (ScreenMode)arrayHashSet.get((Object)screenMode);
                        if (null == screenMode4) {
                            throw new RuntimeException(screenMode + " could not be hashed from ScreenMode list");
                        }
                        screenModeStatus.setOriginalScreenMode(screenMode4);
                    }
                }
                ScreenModeStatus.mapScreenModeStatus(this.getFQName(), screenModeStatus);
            }
        }
        finally {
            ScreenModeStatus.unlockScreenModeStatus();
        }
        return screenModeStatus;
    }

    private ArrayHashSet<ScreenMode> collectNativeScreenModes(IntIntHashMap intIntHashMap) {
        ArrayHashSet arrayHashSet = new ArrayHashSet();
        ArrayHashSet arrayHashSet2 = new ArrayHashSet();
        ArrayHashSet arrayHashSet3 = new ArrayHashSet();
        ArrayHashSet arrayHashSet4 = new ArrayHashSet();
        ArrayHashSet arrayHashSet5 = new ArrayHashSet();
        int[] nArray = null;
        int n = 0;
        do {
            if (null != (nArray = DEBUG_TEST_SCREENMODE_DISABLED ? null : (0 == n ? this.getScreenModeFirstImpl() : this.getScreenModeNextImpl())) && 0 < nArray.length && nArray[4] >= 15) {
                int n2 = nArray[0];
                int n3 = ScreenModeUtil.streamIn((ArrayHashSet<DimensionImmutable>)arrayHashSet, (ArrayHashSet<SurfaceSize>)arrayHashSet2, (ArrayHashSet<DimensionImmutable>)arrayHashSet3, (ArrayHashSet<MonitorMode>)arrayHashSet4, (ArrayHashSet<ScreenMode>)arrayHashSet5, nArray, 1);
                if (n3 >= 0) {
                    intIntHashMap.put(n3, n2);
                }
            }
            ++n;
        } while (null != nArray && 0 < nArray.length);
        if (DEBUG) {
            System.err.println("ScreenImpl.collectNativeScreenModes: ScreenMode number  : " + arrayHashSet5.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: MonitorMode number : " + arrayHashSet4.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: ScreenSizeMM number: " + arrayHashSet3.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: SurfaceSize number : " + arrayHashSet2.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: Resolution number  : " + arrayHashSet.size());
        }
        return arrayHashSet5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseScreenModeStatus() {
        block8: {
            ScreenModeStatus.lockScreenModeStatus();
            try {
                ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
                if (null == screenModeStatus) break block8;
                screenModeStatus.lock();
                try {
                    if (0 == screenModeStatus.removeListener(this)) {
                        if (!screenModeStatus.isOriginalMode()) {
                            this.setCurrentScreenMode(screenModeStatus.getOriginalScreenMode());
                        }
                        ScreenModeStatus.unmapScreenModeStatus(this.getFQName());
                    }
                }
                finally {
                    screenModeStatus.unlock();
                }
            }
            finally {
                ScreenModeStatus.unlockScreenModeStatus();
            }
        }
    }

    private final void shutdown() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatusUnlocked(this.getFQName());
        if (null != screenModeStatus) {
            if (!screenModeStatus.isOriginalMode()) {
                try {
                    this.setCurrentScreenModeImpl(screenModeStatus.getOriginalScreenMode());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ScreenModeStatus.unmapScreenModeStatusUnlocked(this.getFQName());
        }
    }

    private static final void shutdownAll() {
        for (int i = 0; i < screenList.size(); ++i) {
            ((ScreenImpl)screenList.get(i)).shutdown();
        }
    }

    private static synchronized void registerShutdownHook() {
        final Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ScreenImpl.shutdownAll();
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime.getRuntime().addShutdownHook(thread);
                return null;
            }
        });
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ScreenImpl.registerShutdownHook();
                return null;
            }
        });
    }
}

