/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt;

import com.jogamp.common.util.locks.RecursiveLock;
import java.awt.Component;
import java.awt.Window;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.Rectangle;
import javax.media.nativewindow.util.RectangleImmutable;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_Rectangle;

public abstract class JAWTWindow
implements NativeWindow {
    protected static final boolean DEBUG = JAWTUtil.DEBUG;
    protected Component component;
    protected AbstractGraphicsConfiguration config;
    protected long drawable;
    protected Rectangle bounds;
    private RecursiveLock surfaceLock = new RecursiveLock();

    public JAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (abstractGraphicsConfiguration == null) {
            throw new NativeWindowException("Error: AbstractGraphicsConfiguration is null");
        }
        this.config = abstractGraphicsConfiguration;
        this.init((Component)object);
    }

    private void init(Component component) throws NativeWindowException {
        this.invalidate();
        this.component = component;
        this.validateNative();
    }

    protected abstract void validateNative() throws NativeWindowException;

    protected synchronized void invalidate() {
        this.component = null;
        this.drawable = 0L;
        this.bounds = new Rectangle();
    }

    protected final void updateBounds(JAWT_Rectangle jAWT_Rectangle) {
        this.bounds.setX(jAWT_Rectangle.getX());
        this.bounds.setY(jAWT_Rectangle.getY());
        this.bounds.setWidth(jAWT_Rectangle.getWidth());
        this.bounds.setHeight(jAWT_Rectangle.getHeight());
    }

    public final RectangleImmutable getBounds() {
        return this.bounds;
    }

    @Override
    public final InsetsImmutable getInsets() {
        return Insets.getZero();
    }

    public final Component getAWTComponent() {
        return this.component;
    }

    @Override
    public final void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
    }

    protected abstract int lockSurfaceImpl() throws NativeWindowException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockSurface() throws NativeWindowException {
        int n;
        this.surfaceLock.lock();
        int n2 = n = this.surfaceLock.getRecursionCount() == 0 ? 1 : 3;
        if (1 == n) {
            try {
                AbstractGraphicsDevice abstractGraphicsDevice = this.config.getScreen().getDevice();
                abstractGraphicsDevice.lock();
                try {
                    n = this.lockSurfaceImpl();
                }
                finally {
                    if (1 >= n) {
                        abstractGraphicsDevice.unlock();
                    }
                }
            }
            finally {
                if (1 >= n) {
                    this.surfaceLock.unlock();
                }
            }
        }
        return n;
    }

    protected abstract void unlockSurfaceImpl() throws NativeWindowException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        this.surfaceLock.validateLocked();
        if (this.surfaceLock.getRecursionCount() == 0) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.config.getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        this.surfaceLock.unlock();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.surfaceLock.isLockedByOtherThread();
    }

    @Override
    public final boolean isSurfaceLocked() {
        return this.surfaceLock.isLocked();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.surfaceLock.getOwner();
    }

    @Override
    public final boolean surfaceSwap() {
        return false;
    }

    public final void surfaceUpdated(Object object, NativeWindow nativeWindow, long l) {
    }

    @Override
    public final long getSurfaceHandle() {
        return this.drawable;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    @Override
    public final long getDisplayHandle() {
        return this.config.getScreen().getDevice().getHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.config.getScreen().getIndex();
    }

    public final void setSize(int n, int n2) {
        this.component.setSize(n, n2);
    }

    @Override
    public final int getWidth() {
        return this.component.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.component.getHeight();
    }

    @Override
    public synchronized void destroy() {
        if (null != this.component && this.component instanceof Window) {
            ((Window)this.component).dispose();
        }
        this.invalidate();
    }

    @Override
    public final NativeWindow getParent() {
        return null;
    }

    @Override
    public long getWindowHandle() {
        return this.drawable;
    }

    @Override
    public final int getX() {
        return this.component.getX();
    }

    @Override
    public final int getY() {
        return this.component.getY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen(Point point) {
        int n = this.lockSurface();
        if (1 == n) {
            System.err.println("Warning: JAWT Lock couldn't be acquired!");
            Thread.dumpStack();
            return null;
        }
        try {
            Point point2 = this.getLocationOnScreenImpl(0, 0);
            if (null != point2) {
                if (null != point) {
                    point.translate(point2.getX(), point2.getY());
                    Point point3 = point;
                    return point3;
                }
                Point point4 = point2;
                return point4;
            }
            if (!Thread.holdsLock(this.component.getTreeLock())) {
                System.err.println("Warning: JAWT Lock hold, but not the AWT tree lock!");
                Thread.dumpStack();
                Point point5 = null;
                return point5;
            }
            java.awt.Point point6 = this.component.getLocationOnScreen();
            int n2 = (int)(point6.getX() + 0.5);
            int n3 = (int)(point6.getY() + 0.5);
            if (null != point) {
                Point point7 = point.translate(n2, n3);
                return point7;
            }
            Point point8 = new Point(n2, n3);
            return point8;
        }
        finally {
            this.unlockSurface();
        }
    }

    protected abstract Point getLocationOnScreenImpl(int var1, int var2);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JAWT-Window[windowHandle 0x" + Long.toHexString(this.getWindowHandle()) + ", surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle()) + ", bounds " + this.bounds);
        if (null != this.component) {
            stringBuilder.append(", pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ", visible " + this.component.isVisible());
        } else {
            stringBuilder.append(", component NULL");
        }
        stringBuilder.append(", lockedExt " + this.isSurfaceLockedByOtherThread() + ",\n\tconfig " + this.config + ",\n\tawtComponent " + this.getAWTComponent() + "]");
        return stringBuilder.toString();
    }
}

