/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Fixed;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class HheaTable
implements Table {
    private DirectoryEntry de;
    private int version;
    private short ascender;
    private short descender;
    private short lineGap;
    private short advanceWidthMax;
    private short minLeftSideBearing;
    private short minRightSideBearing;
    private short xMaxExtent;
    private short caretSlopeRise;
    private short caretSlopeRun;
    private short metricDataFormat;
    private int numberOfHMetrics;

    protected HheaTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this.de = (DirectoryEntry)directoryEntry.clone();
        this.version = dataInput.readInt();
        this.ascender = dataInput.readShort();
        this.descender = dataInput.readShort();
        this.lineGap = dataInput.readShort();
        this.advanceWidthMax = dataInput.readShort();
        this.minLeftSideBearing = dataInput.readShort();
        this.minRightSideBearing = dataInput.readShort();
        this.xMaxExtent = dataInput.readShort();
        this.caretSlopeRise = dataInput.readShort();
        this.caretSlopeRun = dataInput.readShort();
        for (int i = 0; i < 5; ++i) {
            dataInput.readShort();
        }
        this.metricDataFormat = dataInput.readShort();
        this.numberOfHMetrics = dataInput.readUnsignedShort();
    }

    public short getAdvanceWidthMax() {
        return this.advanceWidthMax;
    }

    public short getAscender() {
        return this.ascender;
    }

    public short getCaretSlopeRise() {
        return this.caretSlopeRise;
    }

    public short getCaretSlopeRun() {
        return this.caretSlopeRun;
    }

    public short getDescender() {
        return this.descender;
    }

    public short getLineGap() {
        return this.lineGap;
    }

    public short getMetricDataFormat() {
        return this.metricDataFormat;
    }

    public short getMinLeftSideBearing() {
        return this.minLeftSideBearing;
    }

    public short getMinRightSideBearing() {
        return this.minRightSideBearing;
    }

    public int getNumberOfHMetrics() {
        return this.numberOfHMetrics;
    }

    @Override
    public int getType() {
        return 1751672161;
    }

    public short getXMaxExtent() {
        return this.xMaxExtent;
    }

    public String toString() {
        return new StringBuffer().append("'hhea' Table - Horizontal Header\n--------------------------------").append("\n        'hhea' version:       ").append(Fixed.floatValue(this.version)).append("\n        yAscender:            ").append(this.ascender).append("\n        yDescender:           ").append(this.descender).append("\n        yLineGap:             ").append(this.lineGap).append("\n        advanceWidthMax:      ").append(this.advanceWidthMax).append("\n        minLeftSideBearing:   ").append(this.minLeftSideBearing).append("\n        minRightSideBearing:  ").append(this.minRightSideBearing).append("\n        xMaxExtent:           ").append(this.xMaxExtent).append("\n        horizCaretSlopeNum:   ").append(this.caretSlopeRise).append("\n        horizCaretSlopeDenom: ").append(this.caretSlopeRun).append("\n        reserved0:            0").append("\n        reserved1:            0").append("\n        reserved2:            0").append("\n        reserved3:            0").append("\n        reserved4:            0").append("\n        metricDataFormat:     ").append(this.metricDataFormat).append("\n        numOf_LongHorMetrics: ").append(this.numberOfHMetrics).toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this.de;
    }
}

