/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import jogamp.graph.font.typecast.ot.table.CffStandardStrings;
import jogamp.graph.font.typecast.ot.table.Charstring;
import jogamp.graph.font.typecast.ot.table.CharstringType2;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class CffTable
implements Table {
    private DirectoryEntry _de;
    private int _major;
    private int _minor;
    private int _hdrSize;
    private int _offSize;
    private NameIndex _nameIndex;
    private TopDictIndex _topDictIndex;
    private StringIndex _stringIndex;
    private Index _globalSubrIndex;
    private Index[] _charStringsIndexArray;
    private Charset[] _charsets;
    private Charstring[][] _charstringsArray;
    private byte[] _buf;

    protected CffTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._buf = new byte[directoryEntry.getLength()];
        dataInput.readFully(this._buf);
        DataInput dataInput2 = this.getDataInputForOffset(0);
        this._major = dataInput2.readUnsignedByte();
        this._minor = dataInput2.readUnsignedByte();
        this._hdrSize = dataInput2.readUnsignedByte();
        this._offSize = dataInput2.readUnsignedByte();
        dataInput2 = this.getDataInputForOffset(this._hdrSize);
        this._nameIndex = new NameIndex(dataInput2);
        this._topDictIndex = new TopDictIndex(dataInput2);
        this._stringIndex = new StringIndex(dataInput2);
        this._globalSubrIndex = new Index(dataInput2);
        this._charStringsIndexArray = new Index[this._topDictIndex.getCount()];
        this._charsets = new Charset[this._topDictIndex.getCount()];
        this._charstringsArray = new Charstring[this._topDictIndex.getCount()][];
        for (int i = 0; i < this._topDictIndex.getCount(); ++i) {
            Integer n = (Integer)this._topDictIndex.getTopDict(i).getValue(17);
            dataInput2 = this.getDataInputForOffset(n);
            this._charStringsIndexArray[i] = new Index(dataInput2);
            int n2 = this._charStringsIndexArray[i].getCount();
            Integer n3 = (Integer)this._topDictIndex.getTopDict(i).getValue(15);
            dataInput2 = this.getDataInputForOffset(n3);
            int n4 = dataInput2.readUnsignedByte();
            switch (n4) {
                case 0: {
                    this._charsets[i] = new CharsetFormat0(dataInput2, n2);
                    break;
                }
                case 1: {
                    this._charsets[i] = new CharsetFormat1(dataInput2, n2);
                    break;
                }
                case 2: {
                    this._charsets[i] = new CharsetFormat2(dataInput2, n2);
                }
            }
            this._charstringsArray[i] = new Charstring[n2];
            for (int j = 0; j < n2; ++j) {
                int n5 = this._charStringsIndexArray[i].getOffset(j) - 1;
                int n6 = this._charStringsIndexArray[i].getOffset(j + 1) - n5 - 1;
                this._charstringsArray[i][j] = new CharstringType2(i, this._stringIndex.getString(this._charsets[i].getSID(j)), this._charStringsIndexArray[i].getData(), n5, n6, null, null);
            }
        }
    }

    private DataInput getDataInputForOffset(int n) {
        return new DataInputStream(new ByteArrayInputStream(this._buf, n, this._de.getLength() - n));
    }

    public NameIndex getNameIndex() {
        return this._nameIndex;
    }

    public Charset getCharset(int n) {
        return this._charsets[n];
    }

    public Charstring getCharstring(int n, int n2) {
        return this._charstringsArray[n][n2];
    }

    public int getCharstringCount(int n) {
        return this._charstringsArray[n].length;
    }

    @Override
    public int getType() {
        return 1128678944;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'CFF' Table - Compact Font Format\n---------------------------------\n");
        stringBuffer.append("\nName INDEX\n");
        stringBuffer.append(this._nameIndex.toString());
        stringBuffer.append("\nTop DICT INDEX\n");
        stringBuffer.append(this._topDictIndex.toString());
        stringBuffer.append("\nString INDEX\n");
        stringBuffer.append(this._stringIndex.toString());
        stringBuffer.append("\nGlobal Subr INDEX\n");
        stringBuffer.append(this._globalSubrIndex.toString());
        for (int i = 0; i < this._charStringsIndexArray.length; ++i) {
            stringBuffer.append("\nCharStrings INDEX ").append(i).append("\n");
            stringBuffer.append(this._charStringsIndexArray[i].toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }

    private abstract class Charset {
        private Charset() {
        }

        public abstract int getFormat();

        public abstract int getSID(int var1);
    }

    private class CharsetFormat0
    extends Charset {
        private int[] _glyph;

        protected CharsetFormat0(DataInput dataInput, int n) throws IOException {
            this._glyph = new int[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                this._glyph[i] = dataInput.readUnsignedShort();
            }
        }

        @Override
        public int getFormat() {
            return 0;
        }

        @Override
        public int getSID(int n) {
            if (n == 0) {
                return 0;
            }
            return this._glyph[n - 1];
        }
    }

    private class CharsetFormat1
    extends Charset {
        private ArrayList<CharsetRange> _charsetRanges = new ArrayList();

        protected CharsetFormat1(DataInput dataInput, int n) throws IOException {
            CharsetRange1 charsetRange1;
            for (int i = n - 1; i > 0; i -= charsetRange1.getLeft() + 1) {
                charsetRange1 = new CharsetRange1(dataInput);
                this._charsetRanges.add(charsetRange1);
            }
        }

        @Override
        public int getFormat() {
            return 1;
        }

        @Override
        public int getSID(int n) {
            if (n == 0) {
                return 0;
            }
            int n2 = 0;
            for (CharsetRange charsetRange : this._charsetRanges) {
                if (n >= (n2 += charsetRange.getLeft())) continue;
                int n3 = n - n2 + charsetRange.getFirst();
                return n3;
            }
            return 0;
        }
    }

    private class CharsetFormat2
    extends Charset {
        private ArrayList<CharsetRange> _charsetRanges = new ArrayList();

        protected CharsetFormat2(DataInput dataInput, int n) throws IOException {
            CharsetRange2 charsetRange2;
            for (int i = n - 1; i > 0; i -= charsetRange2.getLeft() + 1) {
                charsetRange2 = new CharsetRange2(dataInput);
                this._charsetRanges.add(charsetRange2);
            }
        }

        @Override
        public int getFormat() {
            return 2;
        }

        @Override
        public int getSID(int n) {
            if (n == 0) {
                return 0;
            }
            int n2 = 0;
            for (CharsetRange charsetRange : this._charsetRanges) {
                if (n < charsetRange.getLeft() + n2) {
                    int n3 = n - n2 + charsetRange.getFirst() - 1;
                    return n3;
                }
                n2 += charsetRange.getLeft();
            }
            return 0;
        }
    }

    private class CharsetRange {
        private int _first;
        private int _left;

        private CharsetRange() {
        }

        public int getFirst() {
            return this._first;
        }

        protected void setFirst(int n) {
            this._first = n;
        }

        public int getLeft() {
            return this._left;
        }

        protected void setLeft(int n) {
            this._left = n;
        }
    }

    private class CharsetRange1
    extends CharsetRange {
        protected CharsetRange1(DataInput dataInput) throws IOException {
            this.setFirst(dataInput.readUnsignedShort());
            this.setLeft(dataInput.readUnsignedByte());
        }
    }

    private class CharsetRange2
    extends CharsetRange {
        protected CharsetRange2(DataInput dataInput) throws IOException {
            this.setFirst(dataInput.readUnsignedShort());
            this.setLeft(dataInput.readUnsignedShort());
        }
    }

    public class Dict {
        private Dictionary<Integer, Object> _entries = new Hashtable<Integer, Object>();
        private int[] _data;
        private int _index;

        protected Dict(int[] nArray, int n, int n2) {
            this._data = nArray;
            this._index = n;
            while (this._index < n + n2) {
                this.addKeyAndValueEntry();
            }
        }

        public Object getValue(int n) {
            return this._entries.get(n);
        }

        private boolean addKeyAndValueEntry() {
            int n;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object = null;
            while (this.isOperandAtIndex()) {
                object = this.nextOperand();
                arrayList.add(object);
            }
            if ((n = this._data[this._index++]) == 12) {
                n <<= 8;
                n |= this._data[this._index++];
            }
            if (arrayList.size() == 1) {
                this._entries.put(n, object);
            } else {
                this._entries.put(n, arrayList);
            }
            return true;
        }

        private boolean isOperandAtIndex() {
            int n = this._data[this._index];
            return 32 <= n && n <= 254 || n == 28 || n == 29 || n == 30;
        }

        private boolean isOperatorAtIndex() {
            int n = this._data[this._index];
            return 0 <= n && n <= 21;
        }

        private Object nextOperand() {
            int n = this._data[this._index];
            if (32 <= n && n <= 246) {
                ++this._index;
                return new Integer(n - 139);
            }
            if (247 <= n && n <= 250) {
                int n2 = this._data[this._index + 1];
                this._index += 2;
                return new Integer((n - 247) * 256 + n2 + 108);
            }
            if (251 <= n && n <= 254) {
                int n3 = this._data[this._index + 1];
                this._index += 2;
                return new Integer(-(n - 251) * 256 - n3 - 108);
            }
            if (n == 28) {
                int n4 = this._data[this._index + 1];
                int n5 = this._data[this._index + 2];
                this._index += 3;
                return new Integer(n4 << 8 | n5);
            }
            if (n == 29) {
                int n6 = this._data[this._index + 1];
                int n7 = this._data[this._index + 2];
                int n8 = this._data[this._index + 3];
                int n9 = this._data[this._index + 4];
                this._index += 5;
                return new Integer(n6 << 24 | n7 << 16 | n8 << 8 | n9);
            }
            if (n == 30) {
                StringBuffer stringBuffer = new StringBuffer();
                int n10 = 0;
                int n11 = 0;
                ++this._index;
                while (n10 != 15 && n11 != 15) {
                    n10 = this._data[this._index] >> 4;
                    n11 = this._data[this._index] & 0xF;
                    ++this._index;
                    stringBuffer.append(this.decodeRealNibble(n10));
                    stringBuffer.append(this.decodeRealNibble(n11));
                }
                return new Float(stringBuffer.toString());
            }
            return null;
        }

        private String decodeRealNibble(int n) {
            if (n < 10) {
                return Integer.toString(n);
            }
            if (n == 10) {
                return ".";
            }
            if (n == 11) {
                return "E";
            }
            if (n == 12) {
                return "E-";
            }
            if (n == 14) {
                return "-";
            }
            return "";
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration<Integer> enumeration = this._entries.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = enumeration.nextElement();
                if ((n & 0xC00) == 3072) {
                    stringBuffer.append("12 ").append((int)(n & 0xFF)).append(": ");
                } else {
                    stringBuffer.append(n.toString()).append(": ");
                }
                stringBuffer.append(this._entries.get(n).toString()).append("\n");
            }
            return stringBuffer.toString();
        }
    }

    public class Index {
        private int _count;
        private int _offSize;
        private int[] _offset;
        private int[] _data;

        protected Index(DataInput dataInput) throws IOException {
            int n;
            this._count = dataInput.readUnsignedShort();
            this._offset = new int[this._count + 1];
            this._offSize = dataInput.readUnsignedByte();
            for (n = 0; n < this._count + 1; ++n) {
                int n2 = 0;
                for (int i = 0; i < this._offSize; ++i) {
                    n2 |= dataInput.readUnsignedByte() << (this._offSize - i - 1) * 8;
                }
                this._offset[n] = n2;
            }
            this._data = new int[this.getDataLength()];
            for (n = 0; n < this.getDataLength(); ++n) {
                this._data[n] = dataInput.readUnsignedByte();
            }
        }

        public int getCount() {
            return this._count;
        }

        public int getOffset(int n) {
            return this._offset[n];
        }

        public int getDataLength() {
            return this._offset[this._offset.length - 1] - 1;
        }

        public int[] getData() {
            return this._data;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DICT\n");
            stringBuffer.append("count: ").append(this._count).append("\n");
            stringBuffer.append("offSize: ").append(this._offSize).append("\n");
            for (n = 0; n < this._count + 1; ++n) {
                stringBuffer.append("offset[").append(n).append("]: ").append(this._offset[n]).append("\n");
            }
            stringBuffer.append("data:");
            for (n = 0; n < this._data.length; ++n) {
                if (n % 8 == 0) {
                    stringBuffer.append("\n");
                } else {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this._data[n]);
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }

    public class NameIndex
    extends Index {
        protected NameIndex(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        public String getName(int n) {
            String string = null;
            int n2 = this.getOffset(n) - 1;
            int n3 = this.getOffset(n + 1) - n2 - 1;
            if (this.getData()[n2] != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = n2; i < n2 + n3; ++i) {
                    stringBuffer.append((char)this.getData()[i]);
                }
                string = stringBuffer.toString();
            } else {
                string = "DELETED NAME";
            }
            return string;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getCount(); ++i) {
                stringBuffer.append(this.getName(i)).append("\n");
            }
            return stringBuffer.toString();
        }
    }

    public class StringIndex
    extends Index {
        protected StringIndex(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        public String getString(int n) {
            if (n < CffStandardStrings.standardStrings.length) {
                return CffStandardStrings.standardStrings[n];
            }
            if ((n -= CffStandardStrings.standardStrings.length) >= this.getCount()) {
                return null;
            }
            int n2 = this.getOffset(n) - 1;
            int n3 = this.getOffset(n + 1) - n2 - 1;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n2; i < n2 + n3; ++i) {
                stringBuffer.append((char)this.getData()[i]);
            }
            return stringBuffer.toString();
        }

        @Override
        public String toString() {
            int n = CffStandardStrings.standardStrings.length;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getCount(); ++i) {
                stringBuffer.append(n + i).append(": ");
                stringBuffer.append(this.getString(n + i)).append("\n");
            }
            return stringBuffer.toString();
        }
    }

    public class TopDictIndex
    extends Index {
        protected TopDictIndex(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        public Dict getTopDict(int n) {
            int n2 = this.getOffset(n) - 1;
            int n3 = this.getOffset(n + 1) - n2 - 1;
            return new Dict(this.getData(), n2, n3);
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getCount(); ++i) {
                stringBuffer.append(this.getTopDict(i).toString()).append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

