/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import jogamp.nativewindow.x11.X11Util;
import jogamp.nativewindow.x11.XVisualInfo;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;
import jogamp.opengl.x11.glx.X11PixmapGLXContext;

public class X11PixmapGLXDrawable
extends X11GLXDrawable {
    private long pixmap;

    protected X11PixmapGLXDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, true);
        this.create();
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.create();
        } else {
            this.destroyImpl();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new X11PixmapGLXContext(this, gLContext);
    }

    private void create() {
        NativeSurface nativeSurface = this.getNativeSurface();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        XVisualInfo xVisualInfo = x11GLXGraphicsConfiguration.getXVisualInfo();
        int n = xVisualInfo.getDepth();
        AbstractGraphicsScreen abstractGraphicsScreen = x11GLXGraphicsConfiguration.getScreen();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n2 = abstractGraphicsScreen.getIndex();
        this.pixmap = X11Util.XCreatePixmap(l, X11Util.RootWindow(l, n2), this.surface.getWidth(), this.surface.getHeight(), n);
        if (this.pixmap == 0L) {
            throw new GLException("XCreatePixmap failed");
        }
        long l2 = GLX.glXCreateGLXPixmap(l, xVisualInfo, this.pixmap);
        if (l2 == 0L) {
            X11Util.XFreePixmap(l, this.pixmap);
            this.pixmap = 0L;
            throw new GLException("glXCreateGLXPixmap failed");
        }
        ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(l2);
        if (DEBUG) {
            System.err.println("Created pixmap " + X11PixmapGLXDrawable.toHexString(this.pixmap) + ", GLXPixmap " + X11PixmapGLXDrawable.toHexString(l2) + ", display " + X11PixmapGLXDrawable.toHexString(l));
        }
    }

    @Override
    protected void destroyImpl() {
        long l;
        if (this.pixmap == 0L) {
            return;
        }
        NativeSurface nativeSurface = this.getNativeSurface();
        long l2 = nativeSurface.getDisplayHandle();
        long l3 = nativeSurface.getSurfaceHandle();
        if (DEBUG) {
            System.err.println("Destroying pixmap " + X11PixmapGLXDrawable.toHexString(this.pixmap) + ", GLXPixmap " + X11PixmapGLXDrawable.toHexString(l3) + ", display " + X11PixmapGLXDrawable.toHexString(l2));
        }
        if (DEBUG && (l = GLX.glXGetCurrentContext()) != 0L) {
            System.err.println("WARNING: found context " + X11PixmapGLXDrawable.toHexString(l) + " current during pixmap destruction");
        }
        GLX.glXMakeCurrent(l2, 0L, 0L);
        GLX.glXDestroyGLXPixmap(l2, l3);
        X11Util.XFreePixmap(l2, this.pixmap);
        l3 = 0L;
        this.pixmap = 0L;
        ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(0L);
        l2 = 0L;
    }

    @Override
    protected void swapBuffersImpl() {
        if (DEBUG) {
            System.err.println("unhandled swapBuffersImpl() called for: " + this);
        }
    }
}

