/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;
import jogamp.opengl.x11.glx.X11PbufferGLXContext;

public class X11PbufferGLXDrawable
extends X11GLXDrawable {
    protected X11PbufferGLXDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, true);
        if (DEBUG) {
            System.out.println("Pbuffer config: " + this.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration());
        }
        this.createPbuffer();
        if (DEBUG) {
            System.err.println("Created pbuffer " + this);
        }
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.createPbuffer();
        } else {
            this.destroyImpl();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new X11PbufferGLXContext(this, gLContext);
    }

    @Override
    protected void destroyImpl() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (nativeSurface.getSurfaceHandle() != 0L) {
            GLX.glXDestroyPbuffer(nativeSurface.getDisplayHandle(), nativeSurface.getSurfaceHandle());
        }
        ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(0L);
    }

    private void createPbuffer() {
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsScreen abstractGraphicsScreen = x11GLXGraphicsConfiguration.getScreen();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n = abstractGraphicsScreen.getIndex();
        if (l == 0L) {
            throw new GLException("Null display");
        }
        NativeSurface nativeSurface = this.getNativeSurface();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)x11GLXGraphicsConfiguration.getChosenCapabilities();
        if (gLCapabilitiesImmutable.getPbufferRenderToTexture()) {
            throw new GLException("Render-to-texture pbuffers not supported yet on X11");
        }
        if (gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle()) {
            throw new GLException("Render-to-texture-rectangle pbuffers not supported yet on X11");
        }
        int n2 = 0;
        int[] nArray = new int[5];
        nArray[n2++] = 32833;
        nArray[n2++] = nativeSurface.getWidth();
        nArray[n2++] = 32832;
        nArray[n2++] = nativeSurface.getHeight();
        nArray[n2++] = 0;
        long l2 = GLX.glXCreatePbuffer(l, x11GLXGraphicsConfiguration.getFBConfig(), nArray, 0);
        if (l2 == 0L) {
            throw new GLException("pbuffer creation error: glXCreatePbuffer() failed");
        }
        ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(l2);
        int[] nArray2 = new int[1];
        GLX.glXQueryDrawable(l, l2, 32797, nArray2, 0);
        int n3 = nArray2[0];
        GLX.glXQueryDrawable(l, l2, 32798, nArray2, 0);
        int n4 = nArray2[0];
        ((SurfaceChangeable)((Object)nativeSurface)).setSize(n3, n4);
    }

    public int getFloatingPointMode() {
        return 3;
    }

    @Override
    protected void swapBuffersImpl() {
        if (DEBUG) {
            System.err.println("unhandled swapBuffersImpl() called for: " + this);
        }
    }
}

