/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util;

import com.jogamp.opengl.util.GLArrayDataEditable;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import jogamp.opengl.util.GLArrayHandler;

public class GLArrayHandlerInterleaved
implements GLArrayHandler {
    private GLArrayDataEditable ad;
    private List<GLArrayHandler> subArrays = new ArrayList<GLArrayHandler>();

    public GLArrayHandlerInterleaved(GLArrayDataEditable gLArrayDataEditable) {
        this.ad = gLArrayDataEditable;
    }

    @Override
    public final void addSubHandler(GLArrayHandler gLArrayHandler) {
        this.subArrays.add(gLArrayHandler);
    }

    private final void syncSubData(GL gL, boolean bl, Object object) {
        for (int i = 0; i < this.subArrays.size(); ++i) {
            this.subArrays.get(i).syncData(gL, bl, object);
        }
    }

    @Override
    public final void syncData(GL gL, boolean bl, Object object) {
        if (bl) {
            Buffer buffer = this.ad.getBuffer();
            if (this.ad.isVBO()) {
                gL.glBindBuffer(this.ad.getVBOTarget(), this.ad.getVBOName());
                if (!this.ad.isVBOWritten()) {
                    if (null != buffer) {
                        gL.glBufferData(this.ad.getVBOTarget(), buffer.limit() * this.ad.getComponentSizeInBytes(), buffer, this.ad.getVBOUsage());
                    }
                    this.ad.setVBOWritten(true);
                }
            }
            this.syncSubData(gL, true, object);
        } else {
            this.syncSubData(gL, false, object);
            if (this.ad.isVBO()) {
                gL.glBindBuffer(this.ad.getVBOTarget(), 0);
            }
        }
    }

    @Override
    public final void enableState(GL gL, boolean bl, Object object) {
        for (int i = 0; i < this.subArrays.size(); ++i) {
            this.subArrays.get(i).enableState(gL, bl, object);
        }
    }
}

