/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.ReflectionUtil;
import java.util.HashMap;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.WrappedSurface;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLES1DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLES2DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLExternalContext;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLOnscreenDrawable;
import jogamp.opengl.egl.EGLPbufferDrawable;

public class EGLDrawableFactory
extends GLDrawableFactoryImpl {
    private static final GLDynamicLookupHelper eglES1DynamicLookupHelper;
    private static final GLDynamicLookupHelper eglES2DynamicLookupHelper;
    HashMap sharedMap = new HashMap();
    EGLGraphicsDevice defaultDevice = new EGLGraphicsDevice("decon", 0);

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEGLContextAvailable(EGLGraphicsDevice eGLGraphicsDevice, String string) {
        boolean bl = false;
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get(string));
        gLCapabilities.setRedBits(5);
        gLCapabilities.setGreenBits(5);
        gLCapabilities.setBlueBits(5);
        gLCapabilities.setAlphaBits(0);
        gLCapabilities.setDoubleBuffered(false);
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        EGLDrawable eGLDrawable = (EGLDrawable)this.createGLDrawable(this.createOffscreenSurfaceImpl(eGLGraphicsDevice, gLCapabilities, gLCapabilities, null, 64, 64));
        if (null != eGLDrawable) {
            EGLContext eGLContext = (EGLContext)eGLDrawable.createContext(null);
            if (null != eGLContext) {
                eGLContext.setSynchronized(true);
                try {
                    eGLContext.makeCurrent();
                    bl = eGLContext.isCurrent();
                }
                catch (GLException gLException) {
                    if (DEBUG) {
                        System.err.println("EGLDrawableFactory.createShared: INFO: makeCurrent failed");
                        gLException.printStackTrace();
                    }
                }
                finally {
                    eGLContext.destroy();
                }
            }
            eGLDrawable.destroy();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedResource getOrCreateShared(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource;
        String string = abstractGraphicsDevice.getConnection();
        HashMap hashMap = this.sharedMap;
        synchronized (hashMap) {
            sharedResource = (SharedResource)this.sharedMap.get(string);
        }
        if (null == sharedResource) {
            long l = EGL.eglGetDisplay(0L);
            if (l == 0L) {
                throw new GLException("Failed to created EGL default display: error 0x" + Integer.toHexString(EGL.eglGetError()));
            }
            if (DEBUG) {
                System.err.println("EGLDrawableFactory.createShared: eglDisplay(EGL_DEFAULT_DISPLAY): 0x" + Long.toHexString(l));
            }
            if (!EGL.eglInitialize(l, null, null)) {
                throw new GLException("eglInitialize failed, error 0x" + Integer.toHexString(EGL.eglGetError()));
            }
            EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(l, string, abstractGraphicsDevice.getUnitID());
            sharedResource = new SharedResource(eGLGraphicsDevice, true, true);
            HashMap hashMap2 = this.sharedMap;
            synchronized (hashMap2) {
                this.sharedMap.put(string, sharedResource);
            }
            if (DEBUG) {
                System.err.println("EGLDrawableFactory.createShared: device:  " + eGLGraphicsDevice);
                System.err.println("EGLDrawableFactory.createShared: context ES1: true");
                System.err.println("EGLDrawableFactory.createShared: context ES2: true");
            }
        }
        return sharedResource;
    }

    @Override
    public final boolean getWasSharedContextCreated(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateShared(abstractGraphicsDevice);
        if (null != sharedResource) {
            return sharedResource.wasES1ContextAvailable() || sharedResource.wasES2ContextAvailable();
        }
        return false;
    }

    @Override
    protected final GLContext getOrCreateSharedContextImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null;
    }

    @Override
    protected AbstractGraphicsDevice getOrCreateSharedDeviceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateShared(abstractGraphicsDevice);
        if (null != sharedResource) {
            return sharedResource.getDevice();
        }
        return null;
    }

    SharedResource getOrCreateSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        return this.getOrCreateShared(abstractGraphicsDevice);
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        if (2 == n) {
            if (null == eglES2DynamicLookupHelper) {
                throw new GLException("GLDynamicLookupHelper for ES2 not available");
            }
            return eglES2DynamicLookupHelper;
        }
        if (1 == n) {
            if (null == eglES1DynamicLookupHelper) {
                throw new GLException("GLDynamicLookupHelper for ES1 not available");
            }
            return eglES1DynamicLookupHelper;
        }
        throw new GLException("Unsupported: ES" + n);
    }

    @Override
    protected final void shutdownInstance() {
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return EGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new EGLOnscreenDrawable(this, nativeSurface);
    }

    @Override
    protected GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new GLException("Non pbuffer not yet implemented");
        }
        return new EGLPbufferDrawable(this, nativeSurface);
    }

    @Override
    public boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    @Override
    protected NativeSurface createOffscreenSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        WrappedSurface wrappedSurface = new WrappedSurface(EGLGraphicsConfigurationFactory.createOffscreenGraphicsConfiguration(abstractGraphicsDevice, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser));
        wrappedSurface.setSize(n, n2);
        return wrappedSurface;
    }

    @Override
    protected ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, 0);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, defaultGraphicsScreen);
        WrappedSurface wrappedSurface = new WrappedSurface(eGLGraphicsConfiguration, l);
        return wrappedSurface;
    }

    @Override
    protected GLContext createExternalGLContextImpl() {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault("EGL");
        return new EGLExternalContext(abstractGraphicsScreen);
    }

    @Override
    public boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    protected GLDrawable createExternalGLDrawableImpl() {
        throw new GLException("Not yet implemented");
    }

    @Override
    public boolean canCreateContextOnJava2DSurface(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    public GLContext createContextOnJava2DSurface(Object object, GLContext gLContext) throws GLException {
        throw new GLException("Unimplemented on this platform");
    }

    static {
        GLDynamicLookupHelper gLDynamicLookupHelper;
        block10: {
            block9: {
                new EGLGraphicsConfigurationFactory();
                if ("X11".equals(NativeWindowFactory.getNativeWindowType(true))) {
                    try {
                        ReflectionUtil.createInstance((String)"jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory", (ClassLoader)EGLDrawableFactory.class.getClassLoader());
                    }
                    catch (JogampRuntimeException jogampRuntimeException) {
                        // empty catch block
                    }
                }
                gLDynamicLookupHelper = null;
                try {
                    gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES1DynamicLibraryBundleInfo());
                }
                catch (GLException gLException) {
                    if (!DEBUG) break block9;
                    gLException.printStackTrace();
                }
            }
            eglES1DynamicLookupHelper = gLDynamicLookupHelper;
            if (null != eglES1DynamicLookupHelper && eglES1DynamicLookupHelper.isLibComplete()) {
                EGL.resetProcAddressTable((DynamicLookupHelper)eglES1DynamicLookupHelper);
            }
            gLDynamicLookupHelper = null;
            try {
                gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES2DynamicLibraryBundleInfo());
            }
            catch (GLException gLException) {
                if (!DEBUG) break block10;
                gLException.printStackTrace();
            }
        }
        eglES2DynamicLookupHelper = gLDynamicLookupHelper;
        if (null != eglES2DynamicLookupHelper && eglES2DynamicLookupHelper.isLibComplete()) {
            EGL.resetProcAddressTable((DynamicLookupHelper)eglES2DynamicLookupHelper);
        }
    }

    static class SharedResource {
        private EGLGraphicsDevice device;
        private boolean wasES1ContextCreated;
        private boolean wasES2ContextCreated;

        SharedResource(EGLGraphicsDevice eGLGraphicsDevice, boolean bl, boolean bl2) {
            this.device = eGLGraphicsDevice;
            this.wasES1ContextCreated = bl;
            this.wasES2ContextCreated = bl2;
        }

        final EGLGraphicsDevice getDevice() {
            return this.device;
        }

        final boolean wasES1ContextAvailable() {
            return this.wasES1ContextCreated;
        }

        final boolean wasES2ContextAvailable() {
            return this.wasES2ContextCreated;
        }
    }
}

