/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.x11.X11GraphicsConfiguration;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.DisplayImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.x11.X11Display;
import jogamp.newt.driver.x11.X11Screen;

public class X11Window
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private long windowHandleClose;

    @Override
    protected void createNativeImpl() {
        X11Screen x11Screen = (X11Screen)this.getScreen();
        X11Display x11Display = (X11Display)x11Screen.getDisplay();
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(x11Display.getGraphicsDevice());
        this.config = graphicsConfigurationFactory.chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, x11Screen.getGraphicsScreen());
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window.createNativeImpl() factory: " + graphicsConfigurationFactory + ", chosen config: " + this.config);
        }
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        X11GraphicsConfiguration x11GraphicsConfiguration = (X11GraphicsConfiguration)this.config;
        long l = x11GraphicsConfiguration.getVisualID();
        int n = this.getReconfigureFlags(0, true) & 0xA00;
        this.setWindowHandle(this.CreateWindow0(this.getParentWindowHandle(), x11Display.getEDTHandle(), x11Screen.getIndex(), l, x11Display.getJavaObjectAtom(), x11Display.getWindowDeleteAtom(), this.x, this.y, this.width, this.height, n));
        this.windowHandleClose = this.getWindowHandle();
        if (0L == this.windowHandleClose) {
            throw new NativeWindowException("Error creating window");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        if (0L != this.windowHandleClose && null != this.getScreen()) {
            X11Display x11Display = (X11Display)this.getScreen().getDisplay();
            try {
                this.CloseWindow0(x11Display.getEDTHandle(), this.windowHandleClose, x11Display.getJavaObjectAtom(), x11Display.getWindowDeleteAtom());
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    Exception exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                this.windowHandleClose = 0L;
            }
        }
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window reconfig: " + n + "/" + n2 + " " + n3 + "x" + n4 + ", " + X11Window.getReconfigureFlagsAsString(null, n5));
        }
        if (0 == (0x200 & n5) && 0 <= n && 0 <= n2) {
            InsetsImmutable insetsImmutable = this.getInsets();
            n2 -= insetsImmutable.getTopHeight();
            if (0 > (n -= insetsImmutable.getLeftWidth())) {
                n = 0;
            }
            if (0 > n2) {
                n2 = 0;
            }
        }
        this.reconfigureWindow0(this.getDisplayEDTHandle(), this.getScreenIndex(), this.getParentWindowHandle(), this.getWindowHandle(), n, n2, n3, n4, n5);
        return true;
    }

    protected void reparentNotify(long l) {
        if (DEBUG_IMPLEMENTATION) {
            long l2 = this.getParentWindowHandle();
            System.err.println("Window.reparentNotify (" + X11Window.getThreadName() + "): " + X11Window.toHexString(l2) + " -> " + X11Window.toHexString(l));
        }
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getDisplayEDTHandle(), this.getWindowHandle(), bl);
    }

    @Override
    protected void setTitleImpl(final String string) {
        this.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable(){

            @Override
            public Object run(long l) {
                X11Window.this.setTitle0(l, X11Window.this.getWindowHandle(), string);
                return null;
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return X11Util.GetRelativeLocation(this.getScreen().getDisplay().getHandle(), this.getScreenIndex(), this.getWindowHandle(), 0L, n, n2);
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    private final long getDisplayEDTHandle() {
        return ((X11Display)this.getScreen().getDisplay()).getEDTHandle();
    }

    private final Object runWithLockedDisplayHandle(DisplayImpl.DisplayRunnable displayRunnable) {
        return ((DisplayImpl)this.getScreen().getDisplay()).runWithLockedDisplayHandle(displayRunnable);
    }

    protected static native boolean initIDs0();

    private native long CreateWindow0(long var1, long var3, int var5, long var6, long var8, long var10, int var12, int var13, int var14, int var15, int var16);

    private native void CloseWindow0(long var1, long var3, long var5, long var7);

    private native void reconfigureWindow0(long var1, int var3, long var4, long var6, int var8, int var9, int var10, int var11, int var12);

    private native void setTitle0(long var1, long var3, String var5);

    private native void requestFocus0(long var1, long var3, boolean var5);

    private native long getParentWindow0(long var1, long var3);

    static {
        X11Display.initSingleton();
    }
}

