/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.newt.Screen;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.event.ScreenModeListener;
import java.util.ArrayList;
import java.util.HashMap;

public class ScreenModeStatus {
    private static boolean DEBUG = Screen.DEBUG;
    private RecursiveLock lock = new RecursiveLock();
    private ArrayHashSet<ScreenMode> screenModes;
    private IntIntHashMap screenModesIdx2NativeIdx;
    private ScreenMode currentScreenMode;
    private ScreenMode originalScreenMode;
    private ArrayList<ScreenModeListener> listener = new ArrayList();
    private static HashMap<String, ScreenModeStatus> screenFQN2ScreenModeStatus = new HashMap();
    private static RecursiveLock screen2ScreenModeStatusLock = new RecursiveLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void mapScreenModeStatus(String string, ScreenModeStatus screenModeStatus) {
        screen2ScreenModeStatusLock.lock();
        try {
            ScreenModeStatus screenModeStatus2 = screenFQN2ScreenModeStatus.get(string);
            if (null != screenModeStatus2) {
                throw new RuntimeException("ScreenModeStatus " + screenModeStatus2 + " already mapped to " + string);
            }
            screenFQN2ScreenModeStatus.put(string, screenModeStatus);
            if (DEBUG) {
                System.err.println("ScreenModeStatus.map " + string + " -> " + screenModeStatus);
            }
        }
        finally {
            screen2ScreenModeStatusLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unmapScreenModeStatus(String string) {
        screen2ScreenModeStatusLock.lock();
        try {
            ScreenModeStatus.unmapScreenModeStatusUnlocked(string);
        }
        finally {
            screen2ScreenModeStatusLock.unlock();
        }
    }

    protected static void unmapScreenModeStatusUnlocked(String string) {
        ScreenModeStatus screenModeStatus = screenFQN2ScreenModeStatus.remove(string);
        if (DEBUG) {
            System.err.println("ScreenModeStatus.unmap " + string + " -> " + screenModeStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ScreenModeStatus getScreenModeStatus(String string) {
        screen2ScreenModeStatusLock.lock();
        try {
            ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatusUnlocked(string);
            return screenModeStatus;
        }
        finally {
            screen2ScreenModeStatusLock.unlock();
        }
    }

    protected static ScreenModeStatus getScreenModeStatusUnlocked(String string) {
        return screenFQN2ScreenModeStatus.get(string);
    }

    protected static void lockScreenModeStatus() {
        screen2ScreenModeStatusLock.lock();
    }

    protected static void unlockScreenModeStatus() {
        screen2ScreenModeStatusLock.unlock();
    }

    public ScreenModeStatus(ArrayHashSet<ScreenMode> arrayHashSet, IntIntHashMap intIntHashMap) {
        this.screenModes = arrayHashSet;
        this.screenModesIdx2NativeIdx = intIntHashMap;
    }

    protected final void setOriginalScreenMode(ScreenMode screenMode) {
        this.originalScreenMode = screenMode;
        this.currentScreenMode = screenMode;
    }

    public final ScreenMode getOriginalScreenMode() {
        return this.originalScreenMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ScreenMode getCurrentScreenMode() {
        this.lock();
        try {
            ScreenMode screenMode = this.currentScreenMode;
            return screenMode;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOriginalMode() {
        this.lock();
        try {
            if (null != this.currentScreenMode && null != this.originalScreenMode) {
                boolean bl = this.currentScreenMode.hashCode() == this.originalScreenMode.hashCode();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    protected final ArrayHashSet<ScreenMode> getScreenModes() {
        return this.screenModes;
    }

    protected final IntIntHashMap getScreenModesIdx2NativeIdx() {
        return this.screenModesIdx2NativeIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int addListener(ScreenModeListener screenModeListener) {
        this.lock();
        try {
            this.listener.add(screenModeListener);
            if (DEBUG) {
                System.err.println("ScreenModeStatus.addListener (size: " + this.listener.size() + "): " + screenModeListener);
            }
            int n = this.listener.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int removeListener(ScreenModeListener screenModeListener) {
        this.lock();
        try {
            if (!this.listener.remove(screenModeListener)) {
                throw new RuntimeException("ScreenModeListener " + screenModeListener + " not contained");
            }
            if (DEBUG) {
                System.err.println("ScreenModeStatus.removeListener (size: " + this.listener.size() + "): " + screenModeListener);
            }
            int n = this.listener.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireScreenModeChangeNotify(ScreenMode screenMode) {
        this.lock();
        try {
            for (int i = 0; i < this.listener.size(); ++i) {
                this.listener.get(i).screenModeChangeNotify(screenMode);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireScreenModeChanged(ScreenMode screenMode, boolean bl) {
        this.lock();
        try {
            if (bl) {
                this.currentScreenMode = screenMode;
            }
            for (int i = 0; i < this.listener.size(); ++i) {
                this.listener.get(i).screenModeChanged(screenMode, bl);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected final void lock() throws RuntimeException {
        this.lock.lock();
    }

    protected final void unlock() throws RuntimeException {
        this.lock.unlock();
    }
}

